/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.commons.mail.BaseEmailTestCase;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.mocks.MockEmailConcrete;

public class EmailTest
extends BaseEmailTestCase {
    public static final String[] ARR_VALID_EMAILS = new String[]{"me@home.com", "joe.doe@apache.org", "someone_here@work-address.com.au"};
    private MockEmailConcrete email;

    public EmailTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.email = new MockEmailConcrete();
    }

    public void testGetSetDebug() {
        boolean[] tests = new boolean[]{true, false};
        for (int i = 0; i < tests.length; ++i) {
            this.email.setDebug(tests[i]);
            EmailTest.assertEquals((boolean)tests[i], (boolean)this.email.isDebug());
        }
    }

    public void testGetSetSession() throws Exception {
        Properties properties = new Properties(System.getProperties());
        properties.setProperty("mail.transport.protocol", "smtp");
        properties.setProperty("mail.smtp.port", String.valueOf(this.getMailServerPort()));
        properties.setProperty("mail.smtp.host", this.strTestMailServer);
        properties.setProperty("mail.debug", String.valueOf(false));
        Session mySession = Session.getInstance((Properties)properties, null);
        this.email.setMailSession(mySession);
        EmailTest.assertEquals((Object)mySession, (Object)this.email.getMailSession());
    }

    public void testGetSetAuthentication() {
        String strUsername = "user.name";
        String strPassword = "user.pwd";
        this.email.setAuthentication(strUsername, strPassword);
        DefaultAuthenticator retrievedAuth = (DefaultAuthenticator)this.email.getAuthenticator();
        EmailTest.assertTrue((boolean)Authenticator.class.isInstance(this.email.getAuthenticator()));
        EmailTest.assertEquals((String)strUsername, (String)retrievedAuth.getPasswordAuthentication().getUserName());
        EmailTest.assertEquals((String)strPassword, (String)retrievedAuth.getPasswordAuthentication().getPassword());
    }

    public void testGetSetAuthenticator() {
        String strUsername = "user.name";
        String strPassword = "user.pwd";
        DefaultAuthenticator authenicator = new DefaultAuthenticator(strUsername, strPassword);
        this.email.setAuthenticator((Authenticator)authenicator);
        DefaultAuthenticator retrievedAuth = (DefaultAuthenticator)this.email.getAuthenticator();
        EmailTest.assertTrue((boolean)Authenticator.class.isInstance(this.email.getAuthenticator()));
        EmailTest.assertEquals((String)strUsername, (String)retrievedAuth.getPasswordAuthentication().getUserName());
        EmailTest.assertEquals((String)strPassword, (String)retrievedAuth.getPasswordAuthentication().getPassword());
    }

    public void testGetSetCharset() {
        Charset set = Charset.forName("US-ASCII");
        this.email.setCharset(set.name());
        EmailTest.assertEquals((String)set.name(), (String)this.email.getCharset());
        set = Charset.forName("UTF-8");
        this.email.setCharset(set.name());
        EmailTest.assertEquals((String)set.name(), (String)this.email.getCharset());
    }

    public void testSetContentMimeMultipart() {
        MimeMultipart[] tests = new MimeMultipart[]{new MimeMultipart(), new MimeMultipart("abc123"), null};
        for (int i = 0; i < tests.length; ++i) {
            this.email.setContent(tests[i]);
            EmailTest.assertEquals((Object)tests[i], (Object)this.email.getContentMimeMultipart());
        }
    }

    public void testSetContentObject() {
        String testObject = "test string object";
        String testContentType = "";
        testObject = "test string object";
        testContentType = " ; charset=us-ascii";
        this.email.setContent(testObject, testContentType);
        EmailTest.assertEquals((Object)testObject, (Object)this.email.getContentObject());
        EmailTest.assertEquals((String)testContentType, (String)this.email.getContentType());
        testObject = null;
        testContentType = " ; charset=us-ascii some more here";
        this.email.setContent(testObject, testContentType);
        EmailTest.assertEquals((Object)testObject, (Object)this.email.getContentObject());
        EmailTest.assertEquals((String)testContentType, (String)this.email.getContentType());
        testObject = "test string object";
        testContentType = null;
        this.email.setContent(testObject, testContentType);
        EmailTest.assertEquals((Object)testObject, (Object)this.email.getContentObject());
        EmailTest.assertEquals((String)testContentType, (String)this.email.getContentType());
        testObject = "test string object";
        testContentType = " something incorrect ";
        this.email.setContent(testObject, testContentType);
        EmailTest.assertEquals((Object)testObject, (Object)this.email.getContentObject());
        EmailTest.assertEquals((String)testContentType, (String)this.email.getContentType());
    }

    public void testGetSetHostName() {
        for (int i = 0; i < this.testCharsValid.length; ++i) {
            this.email.setHostName(this.testCharsValid[i]);
            EmailTest.assertEquals((String)this.testCharsValid[i], (String)this.email.getHostName());
        }
    }

    public void testGetSetSmtpPort() {
        int[] tests = new int[]{1, Integer.MAX_VALUE};
        for (int i = 0; i < tests.length; ++i) {
            this.email.setSmtpPort(tests[i]);
            EmailTest.assertEquals((int)tests[i], (int)Integer.valueOf(this.email.getSmtpPort()));
        }
        int[] testExs = new int[]{Integer.MIN_VALUE, -1, 0};
        for (int i = 0; i < testExs.length; ++i) {
            try {
                this.email.setSmtpPort(testExs[i]);
                EmailTest.fail((String)"Should have thrown an exception");
                continue;
            }
            catch (IllegalArgumentException e) {
                EmailTest.assertTrue((boolean)true);
            }
        }
    }

    public void testSetFrom() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.setFrom(ARR_VALID_EMAILS[i]);
            EmailTest.assertEquals(arrExpected.get(i), (Object)this.email.getFromAddress());
        }
    }

    public void testSetFromWithEncoding() throws Exception {
        String testValidEmail = "me@home.com";
        InternetAddress inetExpected = new InternetAddress("me@home.com", "me@home.com", "iso-8859-1");
        this.email.setFrom(testValidEmail, testValidEmail, "iso-8859-1");
        EmailTest.assertEquals((Object)inetExpected, (Object)this.email.getFromAddress());
    }

    public void testSetFrom2() throws Exception {
        String[] testEmails = new String[]{"me@home.com", "joe.doe@apache.org", "someone_here@work-address.com.au"};
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        for (int i = 0; i < testEmails.length; ++i) {
            this.email.setFrom(testEmails[i], testEmailNames[i]);
            EmailTest.assertEquals(arrExpected.get(i), (Object)this.email.getFromAddress());
        }
        MockEmailConcrete anotherEmail = new MockEmailConcrete();
        try {
            anotherEmail.setFrom("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
            EmailTest.fail((String)"setting invalid charset should have failed!");
        }
        catch (IllegalCharsetNameException e) {
            // empty catch block
        }
    }

    public void testAddTo() throws EmailException, AddressException, UnsupportedEncodingException {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addTo(ARR_VALID_EMAILS[i]);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getToAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getToAddresses().toString());
    }

    public void testAddToArray() throws EmailException, AddressException, UnsupportedEncodingException {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        this.email.addTo(ARR_VALID_EMAILS);
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getToAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getToAddresses().toString());
    }

    public void testAddToWithEncoding() throws UnsupportedEncodingException, AddressException, EmailException {
        String testCharset = "iso-8859-1";
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addTo(ARR_VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getToAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getToAddresses().toString());
    }

    public void testAddTo2() throws UnsupportedEncodingException, AddressException, EmailException {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addTo(ARR_VALID_EMAILS[i], testEmailNames[i]);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getToAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getToAddresses().toString());
        MockEmailConcrete anotherEmail = new MockEmailConcrete();
        try {
            anotherEmail.addTo("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
            EmailTest.fail((String)"setting invalid charset should have failed!");
        }
        catch (IllegalCharsetNameException e) {
            // empty catch block
        }
    }

    public void testSetTo() throws UnsupportedEncodingException, EmailException {
        ArrayList<InternetAddress> testEmailValid2 = new ArrayList<InternetAddress>();
        testEmailValid2.add(new InternetAddress("me@home.com", "Name1"));
        testEmailValid2.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        testEmailValid2.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        this.email.setTo(testEmailValid2);
        EmailTest.assertEquals((int)testEmailValid2.size(), (int)this.email.getToAddresses().size());
        EmailTest.assertEquals((String)((Object)testEmailValid2).toString(), (String)this.email.getToAddresses().toString());
        try {
            this.email.setTo(null);
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            EmailTest.assertTrue((boolean)true);
        }
        try {
            this.email.setTo(new ArrayList());
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            EmailTest.assertTrue((boolean)true);
        }
    }

    public void testAddCc() throws UnsupportedEncodingException, AddressException, EmailException {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addCc(ARR_VALID_EMAILS[i]);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getCcAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getCcAddresses().toString());
    }

    public void testAddCcArray() throws UnsupportedEncodingException, AddressException, EmailException {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        this.email.addCc(ARR_VALID_EMAILS);
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getCcAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getCcAddresses().toString());
    }

    public void testAddCcWithEncoding() throws UnsupportedEncodingException, AddressException, EmailException {
        String testCharset = "iso-8859-1";
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addCc(ARR_VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getCcAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getCcAddresses().toString());
    }

    public void testAddCc2() throws UnsupportedEncodingException, AddressException, EmailException {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addCc(ARR_VALID_EMAILS[i], testEmailNames[i]);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getCcAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getCcAddresses().toString());
        MockEmailConcrete anotherEmail = new MockEmailConcrete();
        try {
            anotherEmail.addCc("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
            EmailTest.fail((String)"setting invalid charset should have failed!");
        }
        catch (IllegalCharsetNameException e) {
            // empty catch block
        }
    }

    public void testSetCc() throws EmailException, AddressException {
        ArrayList<InternetAddress> testEmailValid2 = new ArrayList<InternetAddress>();
        testEmailValid2.add(new InternetAddress("Name1 <me@home.com>"));
        testEmailValid2.add(new InternetAddress("\"joe.doe@apache.org\" <joe.doe@apache.org>"));
        testEmailValid2.add(new InternetAddress("\"someone_here@work.com.au\" <someone_here@work.com.au>"));
        this.email.setCc(testEmailValid2);
        EmailTest.assertEquals(testEmailValid2, (Object)this.email.getCcAddresses());
        try {
            this.email.setCc(null);
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            EmailTest.assertTrue((boolean)true);
        }
        try {
            this.email.setCc(new ArrayList());
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            EmailTest.assertTrue((boolean)true);
        }
    }

    public void testAddBcc() throws UnsupportedEncodingException, AddressException, EmailException {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addBcc(ARR_VALID_EMAILS[i]);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getBccAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getBccAddresses().toString());
    }

    public void testAddBccArray() throws UnsupportedEncodingException, AddressException, EmailException {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        this.email.addBcc(ARR_VALID_EMAILS);
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getBccAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getBccAddresses().toString());
    }

    public void testAddBccWithEncoding() throws UnsupportedEncodingException, AddressException, EmailException {
        String testCharset = "iso-8859-1";
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addBcc(ARR_VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getBccAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getBccAddresses().toString());
    }

    public void testAddBcc2() throws UnsupportedEncodingException, AddressException, EmailException {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addBcc(ARR_VALID_EMAILS[i], testEmailNames[i]);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getBccAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getBccAddresses().toString());
        MockEmailConcrete anotherEmail = new MockEmailConcrete();
        try {
            anotherEmail.addBcc("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
            EmailTest.fail((String)"setting invalid charset should have failed!");
        }
        catch (IllegalCharsetNameException e) {
            // empty catch block
        }
    }

    public void testSetBcc() throws UnsupportedEncodingException, EmailException {
        ArrayList<InternetAddress> testInetEmailValid = new ArrayList<InternetAddress>();
        testInetEmailValid.add(new InternetAddress("me@home.com", "Name1"));
        testInetEmailValid.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        testInetEmailValid.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        this.email.setBcc(testInetEmailValid);
        EmailTest.assertEquals(testInetEmailValid, (Object)this.email.getBccAddresses());
        try {
            this.email.setBcc(null);
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            EmailTest.assertTrue((boolean)true);
        }
        try {
            this.email.setBcc(new ArrayList());
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            EmailTest.assertTrue((boolean)true);
        }
    }

    public void testAddReplyTo() throws UnsupportedEncodingException, AddressException, EmailException {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addReplyTo(ARR_VALID_EMAILS[i]);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getReplyToAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getReplyToAddresses().toString());
    }

    public void testAddReplyToWithEncoding() throws UnsupportedEncodingException, AddressException, EmailException {
        String testCharset = "iso-8859-1";
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addReplyTo(ARR_VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getReplyToAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getReplyToAddresses().toString());
    }

    public void testAddReplyTo2() throws UnsupportedEncodingException, AddressException, EmailException {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < ARR_VALID_EMAILS.length; ++i) {
            this.email.addReplyTo(ARR_VALID_EMAILS[i], testEmailNames[i]);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getReplyToAddresses().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getReplyToAddresses().toString());
        MockEmailConcrete anotherEmail = new MockEmailConcrete();
        try {
            anotherEmail.addReplyTo("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
            EmailTest.fail((String)"setting invalid charset should have failed!");
        }
        catch (IllegalCharsetNameException e) {
            // empty catch block
        }
    }

    public void testAddHeader() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("X-Priority", "1");
        ht.put("Disposition-Notification-To", "me@home.com");
        ht.put("X-Mailer", "Sendmail");
        for (Map.Entry entry : ht.entrySet()) {
            String strName = (String)entry.getKey();
            String strValue = (String)entry.getValue();
            this.email.addHeader(strName, strValue);
        }
        EmailTest.assertEquals((int)ht.size(), (int)this.email.getHeaders().size());
        EmailTest.assertEquals(ht, this.email.getHeaders());
    }

    public void testAddHeaderEx() {
        Hashtable<String, String> htBad = new Hashtable<String, String>();
        htBad.put("X-Mailer", "");
        htBad.put("X-Priority", "");
        htBad.put("", "me@home.com");
        Hashtable arrExpected = new Hashtable();
        for (Map.Entry element : htBad.entrySet()) {
            try {
                String strName = (String)element.getKey();
                String strValue = (String)element.getValue();
                this.email.addHeader(strName, strValue);
                EmailTest.fail((String)"Should have thrown an exception");
            }
            catch (IllegalArgumentException e) {
                EmailTest.assertTrue((boolean)true);
            }
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getHeaders().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getHeaders().toString());
    }

    public void testSetHeaders() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("X-Priority", "1");
        ht.put("Disposition-Notification-To", "me@home.com");
        ht.put("X-Mailer", "Sendmail");
        this.email.setHeaders(ht);
        EmailTest.assertEquals((int)ht.size(), (int)this.email.getHeaders().size());
        EmailTest.assertEquals(ht, this.email.getHeaders());
    }

    public void testFoldingHeaders() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        String headerValue = "1234567890 1234567890 123456789 01234567890 123456789 0123456789 01234567890 01234567890";
        this.email.addHeader("X-LongHeader", "1234567890 1234567890 123456789 01234567890 123456789 0123456789 01234567890 01234567890");
        EmailTest.assertTrue((this.email.getHeaders().size() == 1 ? 1 : 0) != 0);
        EmailTest.assertTrue((this.email.getHeaders().get("X-LongHeader").toString().indexOf("\r\n") == -1 ? 1 : 0) != 0);
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        String[] values = msg.getHeader("X-LongHeader");
        EmailTest.assertEquals((int)1, (int)values.length);
        String[] lines = values[0].split("\\r\\n");
        EmailTest.assertEquals((int)2, (int)lines.length);
        EmailTest.assertTrue((values[0].indexOf("\n") == values[0].lastIndexOf("\n") ? 1 : 0) != 0);
    }

    public void testSetHeadersEx() {
        Hashtable<String, String> htBad = new Hashtable<String, String>();
        htBad.put("X-Mailer", "");
        Hashtable arrExpected = new Hashtable();
        try {
            this.email.setHeaders(htBad);
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            EmailTest.assertTrue((boolean)true);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getHeaders().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getHeaders().toString());
        htBad = new Hashtable();
        htBad.put("", "me@home.com");
        try {
            this.email.setHeaders(htBad);
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            EmailTest.assertTrue((boolean)true);
        }
        EmailTest.assertEquals((int)arrExpected.size(), (int)this.email.getHeaders().size());
        EmailTest.assertEquals((String)((Object)arrExpected).toString(), (String)this.email.getHeaders().toString());
    }

    public void testSetSubject() {
        for (int i = 0; i < this.testCharsValid.length; ++i) {
            this.email.setSubject(this.testCharsValid[i]);
            EmailTest.assertEquals((String)this.testCharsValid[i], (String)this.email.getSubject());
        }
    }

    public void testSendEx() {
        try {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.send();
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            this.fakeMailServer.stop();
            EmailTest.assertTrue((boolean)true);
        }
        try {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.setSubject("Test Email #1 Subject");
            this.email.setHostName("bad.host.com");
            this.email.setFrom("me@home.com");
            this.email.addTo("me@home.com");
            this.email.addCc("me@home.com");
            this.email.addBcc("me@home.com");
            this.email.addReplyTo("me@home.com");
            this.email.setContent("test string object", " ; charset=us-ascii");
            this.email.send();
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            EmailTest.assertTrue((boolean)(e.getCause() instanceof ParseException));
            this.fakeMailServer.stop();
            EmailTest.assertTrue((boolean)true);
        }
        try {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.setHostName(this.strTestMailServer);
            this.email.setSmtpPort(this.getMailServerPort());
            this.email.send();
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            this.fakeMailServer.stop();
            EmailTest.assertTrue((boolean)true);
        }
        try {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.setHostName(this.strTestMailServer);
            this.email.setSmtpPort(this.getMailServerPort());
            this.email.setFrom("me@home.com");
            this.email.send();
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            this.fakeMailServer.stop();
            EmailTest.assertTrue((boolean)true);
        }
        try {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.setHostName(this.strTestMailServer);
            this.email.setSmtpPort(this.getMailServerPort());
            this.email.setFrom(this.strTestMailFrom);
            this.email.addTo(this.strTestMailTo);
            this.email.setAuthentication(null, null);
            this.email.send();
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            this.fakeMailServer.stop();
            EmailTest.assertTrue((boolean)true);
        }
        try {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.setHostName("bad.host.com");
            this.email.setSSLOnConnect(true);
            this.email.setFrom(this.strTestMailFrom);
            this.email.addTo(this.strTestMailTo);
            this.email.setAuthentication(null, null);
            this.email.send();
            EmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            EmailTest.assertTrue((boolean)e.getMessage().contains("bad.host.com:465"));
            this.fakeMailServer.stop();
            EmailTest.assertTrue((boolean)true);
        }
    }

    public void testGetSetSentDate() {
        Date dtTest = Calendar.getInstance().getTime();
        this.email.setSentDate(dtTest);
        EmailTest.assertEquals((Object)dtTest, (Object)this.email.getSentDate());
        this.email.setSentDate(null);
        Date sentDate = this.email.getSentDate();
        EmailTest.assertTrue((Math.abs(sentDate.getTime() - dtTest.getTime()) < 1000L ? 1 : 0) != 0);
    }

    public void testToInternetAddressArray() throws EmailException, UnsupportedEncodingException {
        ArrayList<InternetAddress> testInetEmailValid = new ArrayList<InternetAddress>();
        testInetEmailValid.add(new InternetAddress("me@home.com", "Name1"));
        testInetEmailValid.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        testInetEmailValid.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        this.email.setBcc(testInetEmailValid);
        EmailTest.assertEquals((int)testInetEmailValid.size(), (int)this.email.getBccAddresses().size());
    }

    public void testSetPopBeforeSmtp() {
        boolean boolPopBeforeSmtp = true;
        String strHost = "mail.home.com";
        String strUsername = "user.name";
        String strPassword = "user.passwd";
        this.email.setPopBeforeSmtp(boolPopBeforeSmtp, strHost, strUsername, strPassword);
        EmailTest.assertEquals((boolean)boolPopBeforeSmtp, (boolean)this.email.isPopBeforeSmtp());
        EmailTest.assertEquals((String)strHost, (String)this.email.getPopHost());
        EmailTest.assertEquals((String)strUsername, (String)this.email.getPopUsername());
        EmailTest.assertEquals((String)strPassword, (String)this.email.getPopPassword());
    }

    public void testDefaultCharsetAppliesToTextContent() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset("ISO-8859-1");
        this.email.setContent("test content", "text/plain");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        EmailTest.assertEquals((String)"text/plain; charset=ISO-8859-1", (String)msg.getContentType());
    }

    public void testDefaultCharsetCanBeOverriddenByContentType() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset("ISO-8859-1");
        this.email.setContent("test content", "text/plain; charset=US-ASCII");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        EmailTest.assertEquals((String)"text/plain; charset=US-ASCII", (String)msg.getContentType());
    }

    public void testDefaultCharsetIgnoredByNonTextContent() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset("ISO-8859-1");
        this.email.setContent("test content", "application/octet-stream");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        EmailTest.assertEquals((String)"application/octet-stream", (String)msg.getContentType());
    }

    public void testCorrectContentTypeForPNG() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset("ISO-8859-1");
        File png = new File("./target/test-classes/images/logos/maven-feather.png");
        this.email.setContent(png, "image/png");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        EmailTest.assertEquals((String)"image/png", (String)msg.getContentType());
    }
}

