/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.mail.BaseEmailTestCase;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.mocks.MockHtmlEmailConcrete;
import org.apache.commons.mail.settings.EmailConfiguration;
import org.apache.commons.mail.util.MimeMessageParser;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MockHtmlEmailConcrete.class})
public class HtmlEmailTest
extends BaseEmailTestCase {
    private MockHtmlEmailConcrete email;

    public HtmlEmailTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.email = new MockHtmlEmailConcrete();
    }

    public void testGetSetTextMsg() throws EmailException {
        int i;
        for (i = 0; i < this.testCharsValid.length; ++i) {
            this.email.setTextMsg(this.testCharsValid[i]);
            HtmlEmailTest.assertEquals((String)this.testCharsValid[i], (String)this.email.getTextMsg());
        }
        for (i = 0; i < this.testCharsNotValid.length; ++i) {
            try {
                this.email.setTextMsg(this.testCharsNotValid[i]);
                HtmlEmailTest.fail((String)"Should have thrown an exception");
                continue;
            }
            catch (EmailException e) {
                HtmlEmailTest.assertTrue((boolean)true);
            }
        }
    }

    public void testGetSetHtmlMsg() throws EmailException {
        int i;
        for (i = 0; i < this.testCharsValid.length; ++i) {
            this.email.setHtmlMsg(this.testCharsValid[i]);
            HtmlEmailTest.assertEquals((String)this.testCharsValid[i], (String)this.email.getHtmlMsg());
        }
        for (i = 0; i < this.testCharsNotValid.length; ++i) {
            try {
                this.email.setHtmlMsg(this.testCharsNotValid[i]);
                HtmlEmailTest.fail((String)"Should have thrown an exception");
                continue;
            }
            catch (EmailException e) {
                HtmlEmailTest.assertTrue((boolean)true);
            }
        }
    }

    public void testGetSetMsg() throws EmailException {
        int i;
        for (i = 0; i < this.testCharsValid.length; ++i) {
            this.email.setMsg(this.testCharsValid[i]);
            HtmlEmailTest.assertEquals((String)this.testCharsValid[i], (String)this.email.getTextMsg());
            HtmlEmailTest.assertTrue((this.email.getHtmlMsg().indexOf(this.testCharsValid[i]) != -1 ? 1 : 0) != 0);
        }
        for (i = 0; i < this.testCharsNotValid.length; ++i) {
            try {
                this.email.setMsg(this.testCharsNotValid[i]);
                HtmlEmailTest.fail((String)"Should have thrown an exception");
                continue;
            }
            catch (EmailException e) {
                HtmlEmailTest.assertTrue((boolean)true);
            }
        }
    }

    public void testEmbedUrl() throws Exception {
        String strEmbed = this.email.embed(new URL(this.strTestURL), "Test name");
        HtmlEmailTest.assertNotNull((Object)strEmbed);
        HtmlEmailTest.assertEquals((int)10, (int)strEmbed.length());
        String testCid = this.email.embed(new URL(this.strTestURL), "Test name");
        HtmlEmailTest.assertEquals((String)strEmbed, (String)testCid);
        String newCid = this.email.embed(new URL(this.strTestURL), "Test name 2");
        HtmlEmailTest.assertFalse((boolean)strEmbed.equals(newCid));
        try {
            this.email.embed(this.createInvalidURL(), "Bad URL");
            HtmlEmailTest.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            // empty catch block
        }
        try {
            this.email.embed(new URL("http://www.google.com"), "Test name");
            HtmlEmailTest.fail((String)"shouldn't be able to use an existing name with a different URL!");
        }
        catch (EmailException e) {
            // empty catch block
        }
    }

    public void testEmbedFile() throws Exception {
        File file = File.createTempFile("testEmbedFile", "txt");
        file.deleteOnExit();
        String strEmbed = this.email.embed(file);
        HtmlEmailTest.assertNotNull((Object)strEmbed);
        HtmlEmailTest.assertEquals((String)"generated CID has wrong length", (int)10, (int)strEmbed.length());
        String testCid = this.email.embed(file);
        HtmlEmailTest.assertEquals((String)"didn't get same CID after embedding same file twice", (String)strEmbed, (String)testCid);
        File otherFile = File.createTempFile("testEmbedFile2", "txt");
        otherFile.deleteOnExit();
        String newCid = this.email.embed(otherFile);
        HtmlEmailTest.assertFalse((String)"didn't get unique CID from embedding new file", (boolean)strEmbed.equals(newCid));
    }

    public void testEmbedUrlAndFile() throws Exception {
        File tmpFile = File.createTempFile("testfile", "txt");
        tmpFile.deleteOnExit();
        String fileCid = this.email.embed(tmpFile);
        URL fileUrl = tmpFile.toURI().toURL();
        String urlCid = this.email.embed(fileUrl, "urlName");
        HtmlEmailTest.assertFalse((String)"file and URL cids should be different even for same resource", (boolean)fileCid.equals(urlCid));
    }

    public void testEmbedDataSource() throws Exception {
        File tmpFile = File.createTempFile("testEmbedDataSource", "txt");
        tmpFile.deleteOnExit();
        FileDataSource dataSource = new FileDataSource(tmpFile);
        try {
            this.email.embed((DataSource)dataSource, "");
            HtmlEmailTest.fail((String)"embedding with an empty string for a name should fail");
        }
        catch (EmailException e) {
            // empty catch block
        }
        String cid = this.email.embed((DataSource)dataSource, "testname");
        String sameCid = this.email.embed((DataSource)dataSource, "testname");
        HtmlEmailTest.assertEquals((String)"didn't get same CID for embedding same datasource twice", (String)cid, (String)sameCid);
        File anotherFile = File.createTempFile("testEmbedDataSource2", "txt");
        anotherFile.deleteOnExit();
        FileDataSource anotherDS = new FileDataSource(anotherFile);
        try {
            this.email.embed((DataSource)anotherDS, "testname");
        }
        catch (EmailException e) {
            // empty catch block
        }
    }

    public void testSend() throws EmailException, IOException {
        EmailAttachment attachment = new EmailAttachment();
        File testFile = null;
        testFile = File.createTempFile("commons-email-testfile", ".txt");
        testFile.deleteOnExit();
        this.getMailServer();
        String strSubject = "Test HTML Send #1 Subject (w charset)";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        attachment.setName("Test Attachment");
        attachment.setDescription("Test Attachment Desc");
        attachment.setPath(testFile.getAbsolutePath());
        this.email.attach(attachment);
        this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        this.email.setCharset("iso-8859-1");
        this.email.setSubject(strSubject);
        URL url = new URL(EmailConfiguration.TEST_URL);
        String cid = this.email.embed(url, "Apache Logo");
        String strHtmlMsg = "<html>The Apache logo - <img src=\"cid:" + cid + "\"><html>";
        this.email.setHtmlMsg(strHtmlMsg);
        this.email.setTextMsg("Your email client does not support HTML emails");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getTextMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtmlMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        this.validateSend(this.fakeMailServer, strSubject, attachment.getName(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        this.getMailServer();
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        strSubject = "Test HTML Send #1 Subject (wo charset)";
        this.email.setSubject(strSubject);
        this.email.setTextMsg("Test message");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getTextMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }

    public void testSend2() throws Exception {
        this.getMailServer();
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "Test HTML Send #2 Subject (wo charset)";
        this.email.setSubject(strSubject);
        this.email.setMsg("Test txt msg");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getTextMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtmlMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        this.getMailServer();
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setFrom(this.strTestMailFrom);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.addTo(this.strTestMailTo);
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        strSubject = "Test HTML Send #2 Subject (w charset)";
        this.email.setCharset("iso-8859-1");
        this.email.setSubject(strSubject);
        this.email.setMsg("Test txt msg");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getTextMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtmlMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
    }

    public void testAddZipUrl() throws Exception {
        String htmlMsg = "Please click on the following link: <br><br><a href=\"http://paradisedelivery.homeip.net/delivery/?file=3DTZC268X93337.zip\">http://paradisedelivery.homeip.net/delivery/?file=3DTZC268X93337.zip</a><br><br>Customer satisfaction is very important for us.";
        this.getMailServer();
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setCharset("iso-8859-1");
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "A dot (\".\") is appended to some ULRs of a HTML mail.";
        this.email.setSubject(strSubject);
        this.email.setHtmlMsg(htmlMsg);
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtmlMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        HtmlEmailTest.assertTrue((this.email.getHtmlMsg().indexOf("3DTZC268X93337.zip") >= 0 ? 1 : 0) != 0);
        HtmlEmailTest.assertFalse((this.email.getHtmlMsg().indexOf("3DTZC268X93337..zip") >= 0 ? 1 : 0) != 0);
    }

    public void testCallingBuildMimeMessageBeforeSent() throws Exception {
        String htmlMsg = "<b>Hello World</b>";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setCharset("iso-8859-1");
        if (this.strTestUser != null && this.strTestPasswd != null) {
            this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        String strSubject = "testCallingBuildMimeMessageBeforeSent";
        this.email.setSubject(strSubject);
        this.email.setHtmlMsg(htmlMsg);
        this.email.buildMimeMessage();
        try {
            this.email.send();
        }
        catch (IllegalStateException e) {
            return;
        }
        HtmlEmailTest.fail((String)"Expecting an exception when calling buildMimeMessage() before send() ...");
    }

    public void testSendWithPlainTextButNoHtmlContent() throws EmailException, IOException {
        this.getMailServer();
        String strSubject = "testSendWithPlainTextButNoHtmlContent";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        this.email.setCharset("iso-8859-1");
        this.email.setSubject(strSubject);
        this.email.setMsg("This is a plain text content : <b><&npsb;></html></b>");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getTextMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }

    public void testEmbedFileWithCID() throws Exception {
        File file = File.createTempFile("testEmbedFile", "txt");
        file.deleteOnExit();
        String testCid = "Test CID";
        String encodedCid = EmailUtils.encodeUrl((String)testCid);
        String strEmbed = this.email.embed(file, testCid);
        HtmlEmailTest.assertNotNull((Object)strEmbed);
        HtmlEmailTest.assertEquals((String)"didn't get same CID when embedding with a specified CID", (String)encodedCid, (String)strEmbed);
        String returnedCid = this.email.embed(file);
        HtmlEmailTest.assertEquals((String)"didn't get same CID after embedding same file twice", (String)encodedCid, (String)returnedCid);
    }

    public void testHtmlMailMimeLayout() throws Exception {
        this.assertCorrectContentType("contentTypeTest.gif", "image/gif");
        this.assertCorrectContentType("contentTypeTest.jpg", "image/jpeg");
        this.assertCorrectContentType("contentTypeTest.png", "image/png");
    }

    private void assertCorrectContentType(String picture, String contentType) throws Exception {
        HtmlEmail htmlEmail = this.createDefaultHtmlEmail();
        String cid = htmlEmail.embed(new File("./src/test/resources/images/" + picture), "Apache Logo");
        String htmlMsg = "<html><img src=\"cid:" + cid + "\"><html>";
        htmlEmail.setHtmlMsg(htmlMsg);
        htmlEmail.buildMimeMessage();
        MimeMessage mm = htmlEmail.getMimeMessage();
        mm.saveChanges();
        MimeMessageParser mmp = new MimeMessageParser(mm);
        mmp.parse();
        List attachments = mmp.getAttachmentList();
        HtmlEmailTest.assertEquals((String)"Attachment size", (int)1, (int)attachments.size());
        DataSource ds = (DataSource)attachments.get(0);
        HtmlEmailTest.assertEquals((String)"Content type", (String)contentType, (String)ds.getContentType());
    }

    private HtmlEmail createDefaultHtmlEmail() throws EmailException {
        HtmlEmail htmlEmail = new HtmlEmail();
        htmlEmail.setHostName(this.strTestMailServer);
        htmlEmail.setSmtpPort(this.getMailServerPort());
        htmlEmail.setFrom("a@b.com");
        htmlEmail.addTo("c@d.com");
        return htmlEmail;
    }
}

