/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.BaseEmailTestCase;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.mocks.MockHtmlEmailConcrete;
import org.apache.commons.mail.settings.EmailConfiguration;

public class SendWithAttachmentsTest
extends BaseEmailTestCase {
    private MockHtmlEmailConcrete email;

    public SendWithAttachmentsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.email = new MockHtmlEmailConcrete();
    }

    public void testSendNoAttachments() throws EmailException, IOException {
        this.getMailServer();
        String strSubject = "Test HTML Send #1 Subject (w charset)";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        this.email.setCharset("iso-8859-1");
        this.email.setSubject(strSubject);
        URL url = new URL(EmailConfiguration.TEST_URL);
        String cid = this.email.embed(url, "Apache Logo");
        String strHtmlMsg = "<html>The Apache logo - <img src=\"cid:" + cid + "\"><html>";
        this.email.setHtmlMsg(strHtmlMsg);
        this.email.setTextMsg("Your email client does not support HTML emails");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getTextMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtmlMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
    }

    public void testSendWAttachments() throws EmailException, IOException {
        EmailAttachment attachment = new EmailAttachment();
        File testFile = null;
        testFile = File.createTempFile("commons-email-testfile", ".txt");
        this.getMailServer();
        String strSubject = "Test HTML Send #1 Subject (w charset)";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        attachment.setName("Test Attachment");
        attachment.setDescription("Test Attachment Desc");
        attachment.setPath(testFile.getAbsolutePath());
        this.email.attach(attachment);
        this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        this.email.setCharset("iso-8859-1");
        this.email.setSubject(strSubject);
        URL url = new URL(EmailConfiguration.TEST_URL);
        String cid = this.email.embed(url, "Apache Logo");
        String strHtmlMsg = "<html>The Apache logo - <img src=\"cid:" + cid + "\"><html>";
        this.email.setHtmlMsg(strHtmlMsg);
        this.email.setTextMsg("Your email client does not support HTML emails");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getTextMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtmlMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        this.validateSend(this.fakeMailServer, strSubject, attachment.getName(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
    }
}

