/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail.resolver.DataSourceClassPathResolver;

public class DataSourceClassPathResolverTest
extends TestCase {
    private final int IMG_SIZE = 5866;

    public DataSourceClassPathResolverTest(String name) {
        super(name);
    }

    public void testResolvingClassPathLenient() throws Exception {
        DataSourceClassPathResolver dataSourceResolver = new DataSourceClassPathResolver("/", true);
        DataSourceClassPathResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceClassPathResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("./images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceClassPathResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("/images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceClassPathResolverTest.assertNull((Object)dataSourceResolver.resolve("/asf_logo_wide.gif"));
        dataSourceResolver = new DataSourceClassPathResolver("/images", true);
        DataSourceClassPathResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceClassPathResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("./asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceClassPathResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceClassPathResolverTest.assertNull((Object)dataSourceResolver.resolve("./images/asf_logo_wide.gif"));
    }

    public void testResolvingClassPathNonLenient() throws Exception {
        DataSourceClassPathResolver dataSourceResolver = new DataSourceClassPathResolver("/", false);
        DataSourceClassPathResolverTest.assertNotNull((Object)dataSourceResolver.resolve("images/asf_logo_wide.gif"));
        try {
            dataSourceResolver.resolve("asf_logo_wide.gif");
            DataSourceClassPathResolverTest.fail((String)"Expecting an IOException");
        }
        catch (IOException e) {
            return;
        }
    }

    private byte[] toByteArray(DataSource dataSource) throws IOException {
        if (dataSource != null) {
            InputStream is = dataSource.getInputStream();
            return IOUtils.toByteArray((InputStream)is);
        }
        return null;
    }
}

