/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail.resolver.DataSourceFileResolver;

public class DataSourceFileResolverTest
extends TestCase {
    private final int IMG_SIZE = 5866;

    public DataSourceFileResolverTest(String name) {
        super(name);
    }

    public void testResolvingFileLenient() throws Exception {
        DataSourceFileResolver dataSourceResolver = new DataSourceFileResolver(new File("./src/test/resources"), true);
        DataSourceFileResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceFileResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("./images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceFileResolverTest.assertTrue((this.toByteArray(dataSourceResolver.resolve("../resources/images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        DataSourceFileResolverTest.assertNull((Object)this.toByteArray(dataSourceResolver.resolve("/images/does-not-exist.gif")));
        DataSourceFileResolverTest.assertNull((Object)dataSourceResolver.resolve("./images/does-not-exist.gif"));
    }

    public void testResolvingFileNonLenient() throws Exception {
        DataSourceFileResolver dataSourceResolver = new DataSourceFileResolver(new File("."), false);
        DataSourceFileResolverTest.assertNotNull((Object)dataSourceResolver.resolve("./src/test/resources/images/asf_logo_wide.gif"));
        try {
            dataSourceResolver.resolve("asf_logo_wide.gif");
            DataSourceFileResolverTest.fail((String)"Expecting an IOException");
        }
        catch (IOException e) {
            return;
        }
    }

    private byte[] toByteArray(DataSource dataSource) throws IOException {
        if (dataSource != null) {
            InputStream is = dataSource.getInputStream();
            return IOUtils.toByteArray((InputStream)is);
        }
        return null;
    }
}

