/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.util;

import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;
import org.apache.commons.mail.util.MimeMessageParser;
import org.apache.commons.mail.util.MimeMessageUtils;

public class MimeMessageParserTest
extends TestCase {
    public MimeMessageParserTest(String name) {
        super(name);
    }

    public void testParseSimpleEmail() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/simple.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        MimeMessageParserTest.assertEquals((String)"Test HTML Send #1 Subject (wo charset)", (String)mimeMessageParser.getSubject());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.isMultipart());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getPlainContent());
        MimeMessageParserTest.assertNull((Object)mimeMessageParser.getHtmlContent());
        MimeMessageParserTest.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertEquals((String)"test_from@apache.org", (String)mimeMessageParser.getFrom());
        MimeMessageParserTest.assertEquals((String)"test_from@apache.org", (String)mimeMessageParser.getReplyTo());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    public void testParseSimpleReplyEmail() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/simple-reply.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        MimeMessageParserTest.assertEquals((String)"Re: java.lang.NoClassDefFoundError: org/bouncycastle/asn1/pkcs/PrivateKeyInfo", (String)mimeMessageParser.getSubject());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.isMultipart());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getPlainContent());
        MimeMessageParserTest.assertNull((Object)mimeMessageParser.getHtmlContent());
        MimeMessageParserTest.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertEquals((String)"coheigea@apache.org", (String)mimeMessageParser.getFrom());
        MimeMessageParserTest.assertEquals((String)"dev@ws.apache.org", (String)mimeMessageParser.getReplyTo());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    public void testParseHtmlEmailWithAttachments() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/html-attachment.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        MimeMessageParserTest.assertEquals((String)"Test", (String)mimeMessageParser.getSubject());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.isMultipart());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getPlainContent());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        MimeMessageParserTest.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertEquals((String)"siegfried.goeschl@it20one.at", (String)mimeMessageParser.getFrom());
        MimeMessageParserTest.assertEquals((String)"siegfried.goeschl@it20one.at", (String)mimeMessageParser.getReplyTo());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        MimeMessageParserTest.assertTrue((attachmentList.size() == 2 ? 1 : 0) != 0);
        DataSource dataSource = mimeMessageParser.findAttachmentByName("Wasserlilien.jpg");
        MimeMessageParserTest.assertNotNull((Object)dataSource);
        MimeMessageParserTest.assertEquals((String)"image/jpeg", (String)dataSource.getContentType());
        dataSource = mimeMessageParser.findAttachmentByName("it20one.pdf");
        MimeMessageParserTest.assertNotNull((Object)dataSource);
        MimeMessageParserTest.assertEquals((String)"application/pdf", (String)dataSource.getContentType());
    }

    public void testParseMultipartReport() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/multipart-report.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        MimeMessageParserTest.assertEquals((String)"Gelesen: ", (String)mimeMessageParser.getSubject());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.isMultipart());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        MimeMessageParserTest.assertNull((Object)mimeMessageParser.getPlainContent());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        MimeMessageParserTest.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertEquals((String)"siegfried.goeschl@it20one.at", (String)mimeMessageParser.getFrom());
        MimeMessageParserTest.assertEquals((String)"siegfried.goeschl@it20one.at", (String)mimeMessageParser.getReplyTo());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        MimeMessageParserTest.assertTrue((attachmentList.size() == 1 ? 1 : 0) != 0);
        DataSource dataSource = (DataSource)attachmentList.get(0);
        MimeMessageParserTest.assertNotNull((Object)dataSource);
        MimeMessageParserTest.assertNull((Object)dataSource.getName());
        MimeMessageParserTest.assertEquals((String)"message/disposition-notification", (String)dataSource.getContentType());
    }

    public void testAttachmentOnly() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/attachment-only.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        MimeMessageParserTest.assertEquals((String)"Kunde 100029   Auftrag   3600", (String)mimeMessageParser.getSubject());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.isMultipart());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        MimeMessageParserTest.assertNull((Object)mimeMessageParser.getPlainContent());
        MimeMessageParserTest.assertNull((Object)mimeMessageParser.getHtmlContent());
        MimeMessageParserTest.assertTrue((mimeMessageParser.getTo().size() == 1 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getCc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertTrue((mimeMessageParser.getBcc().size() == 0 ? 1 : 0) != 0);
        MimeMessageParserTest.assertEquals((String)"siegfried.goeschl@it20one.at", (String)mimeMessageParser.getFrom());
        MimeMessageParserTest.assertEquals((String)"siegfried.goeschl@it20one.at", (String)mimeMessageParser.getReplyTo());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        MimeMessageParserTest.assertTrue((attachmentList.size() == 1 ? 1 : 0) != 0);
        DataSource dataSource = mimeMessageParser.findAttachmentByName("Kunde 100029   Auftrag   3600.pdf");
        MimeMessageParserTest.assertNotNull((Object)dataSource);
        MimeMessageParserTest.assertEquals((String)"application/pdf", (String)dataSource.getContentType());
    }

    public void testParseNoHeaderSeperatorWithOutOfMemory() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/outofmemory-no-header-seperation.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        MimeMessageParserTest.assertEquals((String)"A corrupt Attachment", (String)mimeMessageParser.getSubject());
        MimeMessageParserTest.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        MimeMessageParserTest.assertTrue((boolean)mimeMessageParser.isMultipart());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        MimeMessageParserTest.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        MimeMessageParserTest.assertNull((Object)mimeMessageParser.getPlainContent());
        MimeMessageParserTest.assertNull((Object)mimeMessageParser.getHtmlContent());
        MimeMessageParserTest.assertEquals((int)mimeMessageParser.getTo().size(), (int)1);
        MimeMessageParserTest.assertEquals((int)mimeMessageParser.getCc().size(), (int)0);
        MimeMessageParserTest.assertEquals((int)mimeMessageParser.getBcc().size(), (int)0);
    }
}

