/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import org.apache.commons.mail.AbstractEmailTest;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.mocks.MockEmailConcrete;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InvalidAddressTest
extends AbstractEmailTest {
    private static final String[] ARR_INVALID_EMAILS = new String[]{"local name@domain.com", "local(name@domain.com", "local)name@domain.com", "local<name@domain.com", "local>name@domain.com", "local,name@domain.com", "local;name@domain.com", "local:name@domain.com", "local[name@domain.com", "local]name@domain.com", "local\"name@domain.com", "local\tname@domain.com", "local\nname@domain.com", "local\rname@domain.com", "local.name@domain com", "local.name@domain(com", "local.name@domain)com", "local.name@domain<com", "local.name@domain>com", "local.name@domain,com", "local.name@domain;com", "local.name@domain:com", "local.name@domain]com", "local.name@domain\\com", "local.name@domain\tcom", "local.name@domain\ncom", "local.name@domain\rcom", "local.name@", "@domain.com"};
    private MockEmailConcrete email;

    @Before
    public void setUpInvalidAddressTest() {
        this.email = new MockEmailConcrete();
    }

    @Test
    public void testSetInvalidFrom() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            try {
                this.email.setFrom(ARR_INVALID_EMAILS[i]);
                Assert.fail((String)("setFrom " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (EmailException emailException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAddInvalidTo() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            try {
                this.email.addTo(ARR_INVALID_EMAILS[i], "Joe");
                Assert.fail((String)("addTo " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (EmailException emailException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAddInvalidCc() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            try {
                this.email.addCc(ARR_INVALID_EMAILS[i], "Joe");
                Assert.fail((String)("addCc " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (EmailException emailException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAddInvalidBcc() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            try {
                this.email.addBcc(ARR_INVALID_EMAILS[i], "Joe");
                Assert.fail((String)("addBcc " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (EmailException emailException) {
                // empty catch block
            }
        }
    }
}

