/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.mail.AbstractEmailTest;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.mocks.MockMultiPartEmailConcrete;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MockMultiPartEmailConcrete.class, URLDataSource.class})
public class MultiPartEmailTest
extends AbstractEmailTest {
    private MockMultiPartEmailConcrete email;
    private File testFile;

    @Before
    public void setUpMultiPartEmailTest() throws Exception {
        this.email = new MockMultiPartEmailConcrete();
        this.testFile = File.createTempFile("testfile", ".txt");
    }

    @Test
    public void testSetMsg() throws EmailException {
        for (String validChar : this.testCharsValid) {
            this.email.setMsg(validChar);
            Assert.assertEquals((Object)validChar, (Object)this.email.getMsg());
        }
        this.email.setCharset("us-ascii");
        for (String validChar : this.testCharsValid) {
            this.email.setMsg(validChar);
            Assert.assertEquals((Object)validChar, (Object)this.email.getMsg());
        }
        for (String invalidChar : this.testCharsNotValid) {
            try {
                this.email.setMsg(invalidChar);
                Assert.fail((String)"Should have thrown an exception");
            }
            catch (EmailException e) {
                Assert.assertTrue((boolean)true);
            }
        }
    }

    @Test
    public void testSend() throws EmailException, IOException {
        this.getMailServer();
        String strSubject = "Test Multipart Send Subject";
        EmailAttachment attachment = new EmailAttachment();
        attachment.setPath(this.testFile.getAbsolutePath());
        attachment.setDisposition("attachment");
        attachment.setName("Test_Attachment");
        attachment.setDescription("Test Attachment Desc");
        MockMultiPartEmailConcrete testEmail = new MockMultiPartEmailConcrete();
        testEmail.setHostName(this.strTestMailServer);
        testEmail.setSmtpPort(this.getMailServerPort());
        testEmail.setFrom(this.strTestMailFrom);
        testEmail.addTo(this.strTestMailTo);
        testEmail.attach(attachment);
        testEmail.setSubType("subType");
        if (EmailUtils.isNotEmpty((String)this.strTestUser) && EmailUtils.isNotEmpty((String)this.strTestPasswd)) {
            testEmail.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        testEmail.setSubject(strSubject);
        testEmail.setMsg("Test Message");
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("X-Priority", "2");
        ht.put("Disposition-Notification-To", this.strTestMailFrom);
        ht.put("X-Mailer", "Sendmail");
        testEmail.setHeaders(ht);
        testEmail.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, testEmail.getMsg(), testEmail.getFromAddress(), (List<InternetAddress>)testEmail.getToAddresses(), (List<InternetAddress>)testEmail.getCcAddresses(), (List<InternetAddress>)testEmail.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, strSubject, attachment.getName(), testEmail.getFromAddress(), (List<InternetAddress>)testEmail.getToAddresses(), (List<InternetAddress>)testEmail.getCcAddresses(), (List<InternetAddress>)testEmail.getBccAddresses(), false);
        try {
            this.getMailServer();
            this.email.send();
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            this.fakeMailServer.stop();
        }
    }

    @Test
    public void testAttach() throws Exception {
        EmailAttachment attachment = new EmailAttachment();
        attachment.setName("Test Attachment");
        attachment.setDescription("Test Attachment Desc");
        attachment.setPath(this.testFile.getAbsolutePath());
        this.email.attach(attachment);
        Assert.assertTrue((boolean)this.email.isBoolHasAttachments());
        attachment = new EmailAttachment();
        attachment.setName("Test Attachment");
        attachment.setDescription("Test Attachment Desc");
        attachment.setURL(new URL(this.strTestURL));
        this.email.attach(attachment);
        this.email.attach(this.testFile);
        Assert.assertTrue((boolean)this.email.isBoolHasAttachments());
        try {
            this.email.attach(null);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            Assert.assertTrue((boolean)true);
        }
        attachment = new EmailAttachment();
        try {
            attachment.setURL(this.createInvalidURL());
            this.email.attach(attachment);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            Assert.assertTrue((boolean)true);
        }
        attachment = new EmailAttachment();
        try {
            attachment.setPath("");
            this.email.attach(attachment);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testAttach2() throws MalformedURLException, EmailException {
        this.email.attach(new URL(this.strTestURL), "Test Attachment", "Test Attachment Desc");
        this.email.attach(new URL(this.strTestURL), null, "Test Attachment Desc");
    }

    @Test
    public void testAttach3() throws Exception {
        URLDataSource urlDs;
        this.email.attach((DataSource)new URLDataSource(new URL(this.strTestURL)), "Test Attachment", "Test Attachment Desc");
        try {
            urlDs = null;
            this.email.attach((DataSource)urlDs, "Test Attachment", "Test Attachment Desc");
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            urlDs = new URLDataSource(this.createInvalidURL());
            this.email.attach((DataSource)urlDs, "Test Attachment", "Test Attachment Desc");
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testAttachFileLocking() throws Exception {
        File tmpFile = File.createTempFile("attachment", ".eml");
        this.email.attach((DataSource)new FileDataSource(tmpFile), "Test Attachment", "Test Attachment Desc");
        Assert.assertTrue((boolean)tmpFile.delete());
    }

    @Test
    public void testAddPart() throws Exception {
        this.email = new MockMultiPartEmailConcrete();
        String strMessage = "hello";
        String strContentType = "text/plain";
        this.email.addPart(strMessage, strContentType);
        Assert.assertEquals((Object)strContentType, (Object)this.email.getContainer().getBodyPart(0).getContentType());
        Assert.assertEquals((Object)strMessage, (Object)this.email.getContainer().getBodyPart(0).getDataHandler().getContent());
    }

    @Test
    public void testAddPart2() throws Exception {
        this.email = new MockMultiPartEmailConcrete();
        String strSubtype = "subtype/abc123";
        this.email.addPart(new MimeMultipart(strSubtype));
        Assert.assertTrue((boolean)this.email.getContainer().getBodyPart(0).getDataHandler().getContentType().contains(strSubtype));
    }

    @Test
    public void testGetContainer() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testInit() {
        try {
            this.email.init();
            this.email.init();
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testGetSetSubType() {
        for (String validChar : this.testCharsValid) {
            this.email.setSubType(validChar);
            Assert.assertEquals((Object)validChar, (Object)this.email.getSubType());
        }
    }
}

