/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.mail.resolver.AbstractDataSourceResolverTest;
import org.apache.commons.mail.resolver.DataSourceUrlResolver;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceUrlResolverTest
extends AbstractDataSourceResolverTest {
    @Test
    public void testResolvingFilesLenient() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new File("./src/test/resources").toURI().toURL(), true);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("./images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertNull((Object)dataSourceResolver.resolve("./images/does-not-exist.gif"));
        Assert.assertNull((Object)dataSourceResolver.resolve("/images/asf_logo_wide.gif"));
    }

    @Test
    public void testResolvingHttpLenient() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new URL("http://www.apache.org"), true);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("http://www.apache.org/images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("./images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("/images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.toByteArray(dataSourceResolver.resolve("/images/does-not-exist.gif")));
    }

    @Test(expected=IOException.class)
    public void testResolvingHttpNonLenient() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new URL("http://www.apache.org"), false);
        Assert.assertNotNull((Object)dataSourceResolver.resolve("images/asf_logo_wide.gif"));
        dataSourceResolver.resolve("images/does-not-exist.gif");
    }
}

