/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.commons.mail.AbstractEmailTest;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.mocks.MockEmailConcrete;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EmailTest
extends AbstractEmailTest {
    private static final String[] VALID_EMAILS = new String[]{"me@home.com", "joe.doe@apache.org", "someone_here@work-address.com.au"};
    private MockEmailConcrete email;

    @Before
    public void setUpEmailTest() {
        this.email = new MockEmailConcrete();
    }

    @Test
    public void testGetSetDebug() {
        this.email.setDebug(true);
        Assert.assertTrue((boolean)this.email.isDebug());
        this.email.setDebug(false);
        Assert.assertFalse((boolean)this.email.isDebug());
    }

    @Test
    public void testGetSetSession() throws Exception {
        Properties properties = new Properties(System.getProperties());
        properties.setProperty("mail.transport.protocol", "smtp");
        properties.setProperty("mail.smtp.port", String.valueOf(this.getMailServerPort()));
        properties.setProperty("mail.smtp.host", this.strTestMailServer);
        properties.setProperty("mail.debug", String.valueOf(false));
        Session mySession = Session.getInstance((Properties)properties, null);
        this.email.setMailSession(mySession);
        Assert.assertEquals((Object)mySession, (Object)this.email.getMailSession());
    }

    @Test
    public void testGetSetAuthentication() {
        String strUsername = "user.name";
        String strPassword = "user.pwd";
        this.email.setAuthentication(strUsername, strPassword);
        DefaultAuthenticator retrievedAuth = (DefaultAuthenticator)this.email.getAuthenticator();
        Assert.assertEquals((Object)strUsername, (Object)retrievedAuth.getPasswordAuthentication().getUserName());
        Assert.assertEquals((Object)strPassword, (Object)retrievedAuth.getPasswordAuthentication().getPassword());
    }

    @Test
    public void testGetSetAuthenticator() {
        String strUsername = "user.name";
        String strPassword = "user.pwd";
        DefaultAuthenticator authenticator = new DefaultAuthenticator(strUsername, strPassword);
        this.email.setAuthenticator((Authenticator)authenticator);
        DefaultAuthenticator retrievedAuth = (DefaultAuthenticator)this.email.getAuthenticator();
        Assert.assertEquals((Object)strUsername, (Object)retrievedAuth.getPasswordAuthentication().getUserName());
        Assert.assertEquals((Object)strPassword, (Object)retrievedAuth.getPasswordAuthentication().getPassword());
    }

    @Test
    public void testGetSetCharset() {
        Charset set = Charset.forName("US-ASCII");
        this.email.setCharset(set.name());
        Assert.assertEquals((Object)set.name(), (Object)this.email.getCharset());
        set = Charset.forName("UTF-8");
        this.email.setCharset(set.name());
        Assert.assertEquals((Object)set.name(), (Object)this.email.getCharset());
    }

    @Test
    public void testSetContentEmptyMimeMultipart() {
        MimeMultipart part = new MimeMultipart();
        this.email.setContent(part);
        Assert.assertEquals((Object)part, (Object)this.email.getContentMimeMultipart());
    }

    @Test
    public void testSetContentMimeMultipart() {
        MimeMultipart part = new MimeMultipart("abc123");
        this.email.setContent(part);
        Assert.assertEquals((Object)part, (Object)this.email.getContentMimeMultipart());
    }

    @Test
    public void testSetContentNull() throws Exception {
        this.email.setContent(null);
        Assert.assertNull((Object)this.email.getContentMimeMultipart());
    }

    @Test
    public void testSetContentObject() {
        String testObject = "test string object";
        String testContentType = " ; charset=us-ascii";
        this.email.setContent(testObject, testContentType);
        Assert.assertEquals((Object)testObject, (Object)this.email.getContentObject());
        Assert.assertEquals((Object)testContentType, (Object)this.email.getContentType());
        testObject = null;
        testContentType = " ; charset=us-ascii some more here";
        this.email.setContent(testObject, testContentType);
        Assert.assertEquals((Object)testObject, (Object)this.email.getContentObject());
        Assert.assertEquals((Object)testContentType, (Object)this.email.getContentType());
        testObject = "test string object";
        testContentType = null;
        this.email.setContent(testObject, testContentType);
        Assert.assertEquals((Object)testObject, (Object)this.email.getContentObject());
        Assert.assertEquals((Object)testContentType, (Object)this.email.getContentType());
        testObject = "test string object";
        testContentType = " something incorrect ";
        this.email.setContent(testObject, testContentType);
        Assert.assertEquals((Object)testObject, (Object)this.email.getContentObject());
        Assert.assertEquals((Object)testContentType, (Object)this.email.getContentType());
    }

    @Test
    public void testGetSetHostName() {
        for (String validChar : this.testCharsValid) {
            this.email.setHostName(validChar);
            Assert.assertEquals((Object)validChar, (Object)this.email.getHostName());
        }
    }

    @Test
    public void testGetSetSmtpPort() {
        this.email.setSmtpPort(1);
        Assert.assertEquals((long)1L, (long)Integer.valueOf(this.email.getSmtpPort()).intValue());
        this.email.setSmtpPort(Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Integer.valueOf(this.email.getSmtpPort()).intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetSmtpPortZero() {
        this.email.setSmtpPort(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetSmptPortNegative() {
        this.email.setSmtpPort(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetSmtpPortMinValue() {
        this.email.setSmtpPort(Integer.MIN_VALUE);
    }

    @Test
    public void testSetFrom() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.setFrom(VALID_EMAILS[i]);
            Assert.assertEquals(arrExpected.get(i), (Object)this.email.getFromAddress());
        }
    }

    @Test
    public void testSetFromWithEncoding() throws Exception {
        String testValidEmail = "me@home.com";
        InternetAddress inetExpected = new InternetAddress("me@home.com", "me@home.com", "iso-8859-1");
        this.email.setFrom(testValidEmail, testValidEmail, "iso-8859-1");
        Assert.assertEquals((Object)inetExpected, (Object)this.email.getFromAddress());
    }

    @Test
    public void testSetFrom2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.setFrom(VALID_EMAILS[i], testEmailNames[i]);
            Assert.assertEquals(arrExpected.get(i), (Object)this.email.getFromAddress());
        }
    }

    @Test(expected=IllegalCharsetNameException.class)
    public void testSetFromBadEncoding() throws Exception {
        this.email.setFrom("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
    }

    @Test
    public void testAddTo() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (String address : VALID_EMAILS) {
            this.email.addTo(address);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getToAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test
    public void testAddToArray() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        this.email.addTo(VALID_EMAILS);
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getToAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test
    public void testAddToWithEncoding() throws Exception {
        String testCharset = "iso-8859-1";
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addTo(VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getToAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test
    public void testAddTo2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addTo(VALID_EMAILS[i], testEmailNames[i]);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getToAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test(expected=IllegalCharsetNameException.class)
    public void testAddToBadEncoding() throws Exception {
        this.email.addTo("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
    }

    @Test
    public void testSetTo() throws Exception {
        ArrayList<InternetAddress> testEmailValid2 = new ArrayList<InternetAddress>();
        testEmailValid2.add(new InternetAddress("me@home.com", "Name1"));
        testEmailValid2.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        testEmailValid2.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        this.email.setTo(testEmailValid2);
        Assert.assertEquals((long)testEmailValid2.size(), (long)this.email.getToAddresses().size());
        Assert.assertEquals((Object)((Object)testEmailValid2).toString(), (Object)this.email.getToAddresses().toString());
    }

    @Test(expected=EmailException.class)
    public void testSetToNull() throws Exception {
        this.email.setTo(null);
    }

    @Test(expected=EmailException.class)
    public void testSetToEmpty() throws Exception {
        this.email.setTo(Collections.emptyList());
    }

    @Test
    public void testAddCc() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (String address : VALID_EMAILS) {
            this.email.addCc(address);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getCcAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getCcAddresses().toString());
    }

    @Test
    public void testAddCcArray() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        this.email.addCc(VALID_EMAILS);
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getCcAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getCcAddresses().toString());
    }

    @Test
    public void testAddCcWithEncoding() throws Exception {
        String testCharset = "iso-8859-1";
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addCc(VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getCcAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getCcAddresses().toString());
    }

    @Test
    public void testAddCc2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addCc(VALID_EMAILS[i], testEmailNames[i]);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getCcAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getCcAddresses().toString());
    }

    @Test(expected=IllegalCharsetNameException.class)
    public void testAddCcBadEncoding() throws Exception {
        this.email.addCc("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
    }

    @Test
    public void testSetCc() throws Exception {
        ArrayList<InternetAddress> testEmailValid2 = new ArrayList<InternetAddress>();
        testEmailValid2.add(new InternetAddress("Name1 <me@home.com>"));
        testEmailValid2.add(new InternetAddress("\"joe.doe@apache.org\" <joe.doe@apache.org>"));
        testEmailValid2.add(new InternetAddress("\"someone_here@work.com.au\" <someone_here@work.com.au>"));
        this.email.setCc(testEmailValid2);
        Assert.assertEquals(testEmailValid2, (Object)this.email.getCcAddresses());
    }

    @Test(expected=EmailException.class)
    public void testSetCcNull() throws Exception {
        this.email.setCc(null);
    }

    @Test(expected=EmailException.class)
    public void testSetCcEmpty() throws Exception {
        this.email.setCc(Collections.emptyList());
    }

    @Test
    public void testAddBcc() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (String address : VALID_EMAILS) {
            this.email.addBcc(address);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getBccAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getBccAddresses().toString());
    }

    @Test
    public void testAddBccArray() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        this.email.addBcc(VALID_EMAILS);
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getBccAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getBccAddresses().toString());
    }

    @Test
    public void testAddBccWithEncoding() throws Exception {
        String testCharset = "iso-8859-1";
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addBcc(VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getBccAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getBccAddresses().toString());
    }

    @Test
    public void testAddBcc2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addBcc(VALID_EMAILS[i], testEmailNames[i]);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getBccAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getBccAddresses().toString());
    }

    @Test(expected=IllegalCharsetNameException.class)
    public void testAddBccBadEncoding() throws Exception {
        this.email.addBcc("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
    }

    @Test
    public void testSetBcc() throws Exception {
        ArrayList<InternetAddress> testInetEmailValid = new ArrayList<InternetAddress>();
        testInetEmailValid.add(new InternetAddress("me@home.com", "Name1"));
        testInetEmailValid.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        testInetEmailValid.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        this.email.setBcc(testInetEmailValid);
        Assert.assertEquals(testInetEmailValid, (Object)this.email.getBccAddresses());
    }

    @Test(expected=EmailException.class)
    public void testSetBccNull() throws Exception {
        this.email.setBcc(null);
    }

    @Test(expected=EmailException.class)
    public void testSetBccEmpty() throws Exception {
        this.email.setBcc(Collections.emptyList());
    }

    @Test
    public void testAddReplyTo() throws Exception {
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (String address : VALID_EMAILS) {
            this.email.addReplyTo(address);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getReplyToAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getReplyToAddresses().toString());
    }

    @Test
    public void testAddReplyToWithEncoding() throws Exception {
        String testCharset = "iso-8859-1";
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1", testCharset));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addReplyTo(VALID_EMAILS[i], testEmailNames[i], testCharset);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getReplyToAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getReplyToAddresses().toString());
    }

    @Test
    public void testAddReplyTo2() throws Exception {
        String[] testEmailNames = new String[]{"Name1", "", null};
        ArrayList<InternetAddress> arrExpected = new ArrayList<InternetAddress>();
        arrExpected.add(new InternetAddress("me@home.com", "Name1"));
        arrExpected.add(new InternetAddress("joe.doe@apache.org"));
        arrExpected.add(new InternetAddress("someone_here@work-address.com.au"));
        for (int i = 0; i < VALID_EMAILS.length; ++i) {
            this.email.addReplyTo(VALID_EMAILS[i], testEmailNames[i]);
        }
        Assert.assertEquals((long)arrExpected.size(), (long)this.email.getReplyToAddresses().size());
        Assert.assertEquals((Object)((Object)arrExpected).toString(), (Object)this.email.getReplyToAddresses().toString());
    }

    @Test(expected=IllegalCharsetNameException.class)
    public void testAddReplyToBadEncoding() throws Exception {
        this.email.addReplyTo("me@home.com", "me@home.com", "bad.encoding\uc5ec\n");
    }

    @Test
    public void testAddHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Priority", "1");
        headers.put("Disposition-Notification-To", "me@home.com");
        headers.put("X-Mailer", "Sendmail");
        for (Map.Entry header : headers.entrySet()) {
            String name = (String)header.getKey();
            String value = (String)header.getValue();
            this.email.addHeader(name, value);
        }
        Assert.assertEquals((long)headers.size(), (long)this.email.getHeaders().size());
        Assert.assertEquals(headers, this.email.getHeaders());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddHeaderEmptyName() throws Exception {
        this.email.addHeader("", "me@home.com");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddHeaderNullName() throws Exception {
        this.email.addHeader(null, "me@home.com");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddHeaderEmptyValue() throws Exception {
        this.email.addHeader("X-Mailer", "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddHeaderNullValue() throws Exception {
        this.email.addHeader("X-Mailer", null);
    }

    @Test
    public void testSetHeaders() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("X-Priority", "1");
        ht.put("Disposition-Notification-To", "me@home.com");
        ht.put("X-Mailer", "Sendmail");
        this.email.setHeaders(ht);
        Assert.assertEquals((long)ht.size(), (long)this.email.getHeaders().size());
        Assert.assertEquals(ht, this.email.getHeaders());
    }

    @Test
    public void testFoldingHeaders() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        String headerValue = "1234567890 1234567890 123456789 01234567890 123456789 0123456789 01234567890 01234567890";
        this.email.addHeader("X-LongHeader", "1234567890 1234567890 123456789 01234567890 123456789 0123456789 01234567890 01234567890");
        Assert.assertTrue((this.email.getHeaders().size() == 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.email.getHeaders().get("X-LongHeader").contains("\r\n"));
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        String[] values = msg.getHeader("X-LongHeader");
        Assert.assertEquals((long)1L, (long)values.length);
        String[] lines = values[0].split("\\r\\n");
        Assert.assertEquals((long)2L, (long)lines.length);
        Assert.assertTrue((values[0].indexOf("\n") == values[0].lastIndexOf("\n") ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetHeaderEmptyValue() throws Exception {
        this.email.setHeaders(Collections.singletonMap("X-Mailer", ""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetHeaderNullValue() throws Exception {
        this.email.setHeaders(Collections.singletonMap("X-Mailer", null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetHeaderEmptyName() throws Exception {
        this.email.setHeaders(Collections.singletonMap("", "me@home.com"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetHeaderNullName() throws Exception {
        this.email.setHeaders(Collections.singletonMap(null, "me@home.com"));
    }

    @Test
    public void testSetSubject() {
        for (String validChar : this.testCharsValid) {
            this.email.setSubject(validChar);
            Assert.assertEquals((Object)validChar, (Object)this.email.getSubject());
        }
    }

    @Test(expected=EmailException.class)
    public void testSendNoHostName() throws Exception {
        this.getMailServer();
        this.email = new MockEmailConcrete();
        this.email.send();
    }

    @Test
    public void testSendBadHostName() {
        try {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.setSubject("Test Email #1 Subject");
            this.email.setHostName("bad.host.com");
            this.email.setFrom("me@home.com");
            this.email.addTo("me@home.com");
            this.email.addCc("me@home.com");
            this.email.addBcc("me@home.com");
            this.email.addReplyTo("me@home.com");
            this.email.setContent("test string object", " ; charset=us-ascii");
            this.email.send();
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ParseException));
            this.fakeMailServer.stop();
        }
    }

    @Test(expected=EmailException.class)
    public void testSendFromNotSet() throws Exception {
        this.getMailServer();
        this.email = new MockEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.send();
    }

    @Test(expected=EmailException.class)
    public void testSendDestinationNotSet() throws Exception {
        this.getMailServer();
        this.email = new MockEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("me@home.com");
        this.email.send();
    }

    @Test(expected=EmailException.class)
    public void testSendBadAuthSet() throws Exception {
        this.getMailServer();
        this.email = new MockEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setAuthentication(null, null);
        this.email.send();
    }

    @Test
    public void testSendCorrectSmtpPortContainedInException() {
        try {
            this.getMailServer();
            this.email = new MockEmailConcrete();
            this.email.setHostName("bad.host.com");
            this.email.setSSLOnConnect(true);
            this.email.setFrom(this.strTestMailFrom);
            this.email.addTo(this.strTestMailTo);
            this.email.setAuthentication(null, null);
            this.email.send();
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (EmailException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("bad.host.com:465"));
            this.fakeMailServer.stop();
        }
    }

    @Test
    public void testGetSetSentDate() {
        Date dtTest = Calendar.getInstance().getTime();
        this.email.setSentDate(dtTest);
        Assert.assertEquals((Object)dtTest, (Object)this.email.getSentDate());
        this.email.setSentDate(null);
        Date sentDate = this.email.getSentDate();
        Assert.assertTrue((Math.abs(sentDate.getTime() - dtTest.getTime()) < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testToInternetAddressArray() throws Exception {
        ArrayList<InternetAddress> testInetEmailValid = new ArrayList<InternetAddress>();
        testInetEmailValid.add(new InternetAddress("me@home.com", "Name1"));
        testInetEmailValid.add(new InternetAddress("joe.doe@apache.org", "joe.doe@apache.org"));
        testInetEmailValid.add(new InternetAddress("someone_here@work-address.com.au", "someone_here@work-address.com.au"));
        this.email.setBcc(testInetEmailValid);
        Assert.assertEquals((long)testInetEmailValid.size(), (long)this.email.getBccAddresses().size());
    }

    @Test
    public void testSetPopBeforeSmtp() {
        boolean boolPopBeforeSmtp = true;
        String strHost = "mail.home.com";
        String strUsername = "user.name";
        String strPassword = "user.passwd";
        this.email.setPopBeforeSmtp(boolPopBeforeSmtp, strHost, strUsername, strPassword);
        Assert.assertEquals((Object)boolPopBeforeSmtp, (Object)this.email.isPopBeforeSmtp());
        Assert.assertEquals((Object)strHost, (Object)this.email.getPopHost());
        Assert.assertEquals((Object)strUsername, (Object)this.email.getPopUsername());
        Assert.assertEquals((Object)strPassword, (Object)this.email.getPopPassword());
    }

    @Test
    public void testDefaultCharsetAppliesToTextContent() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset("ISO-8859-1");
        this.email.setContent("test content", "text/plain");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        Assert.assertEquals((Object)"text/plain; charset=ISO-8859-1", (Object)msg.getContentType());
    }

    @Test
    public void testDefaultCharsetCanBeOverriddenByContentType() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset("ISO-8859-1");
        this.email.setContent("test content", "text/plain; charset=US-ASCII");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        Assert.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)msg.getContentType());
    }

    @Test
    public void testDefaultCharsetIgnoredByNonTextContent() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset("ISO-8859-1");
        this.email.setContent("test content", "application/octet-stream");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        Assert.assertEquals((Object)"application/octet-stream", (Object)msg.getContentType());
    }

    @Test
    public void testCorrectContentTypeForPNG() throws Exception {
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom("a@b.com");
        this.email.addTo("c@d.com");
        this.email.setSubject("test mail");
        this.email.setCharset("ISO-8859-1");
        File png = new File("./target/test-classes/images/logos/maven-feather.png");
        this.email.setContent(png, "image/png");
        this.email.buildMimeMessage();
        MimeMessage msg = this.email.getMimeMessage();
        msg.saveChanges();
        Assert.assertEquals((Object)"image/png", (Object)msg.getContentType());
    }
}

