/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmailTest;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.commons.mail.mocks.MockImageHtmlEmailConcrete;
import org.apache.commons.mail.resolver.DataSourceClassPathResolver;
import org.apache.commons.mail.resolver.DataSourceCompositeResolver;
import org.apache.commons.mail.resolver.DataSourceUrlResolver;
import org.apache.commons.mail.util.MimeMessageParser;
import org.apache.commons.mail.util.MimeMessageUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.subethamail.wiser.WiserMessage;

public class ImageHtmlEmailTest
extends HtmlEmailTest {
    private static final boolean TEST_IS_LENIENT = true;
    private static final URL TEST_IMAGE_URL = ImageHtmlEmailTest.class.getResource("/images/asf_logo_wide.gif");
    private static final File TEST_IMAGE_DIR = new File(TEST_IMAGE_URL.getPath()).getParentFile();
    private static final URL TEST_HTML_URL = ImageHtmlEmailTest.class.getResource("/attachments/download_email.cgi.html");
    private static final URL TEST2_HTML_URL = ImageHtmlEmailTest.class.getResource("/attachments/classpathtest.html");
    private MockImageHtmlEmailConcrete email;

    @Before
    public void setupImageHtmlEmailTest() {
        this.email = new MockImageHtmlEmailConcrete();
    }

    @Test
    public void testSendHtml() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(TEST_IMAGE_DIR.toURI().toURL(), true));
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject(strSubject);
        String html = this.loadUrlContent(TEST_HTML_URL);
        this.email.setHtmlMsg(html);
        this.email.setTextMsg("Your email client does not support HTML messages");
        this.email.send();
        this.fakeMailServer.stop();
        Assert.assertEquals((long)1L, (long)this.fakeMailServer.getMessages().size());
        MimeMessage mimeMessage = ((WiserMessage)this.fakeMailServer.getMessages().get(0)).getMimeMessage();
        MimeMessageParser mimeMessageParser = new MimeMessageParser(mimeMessage).parse();
        Assert.assertTrue((boolean)mimeMessageParser.getHtmlContent().contains("\"cid:"));
        Assert.assertTrue((mimeMessageParser.getAttachmentList().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testSendEmptyHTML() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        ImageHtmlEmail email = new ImageHtmlEmail();
        try {
            email.setHtmlMsg(null);
            Assert.fail((String)"Should fail here!");
        }
        catch (EmailException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid message supplied"));
        }
    }

    @Test
    public void testSendEmptyHTML2() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        ImageHtmlEmail email = new ImageHtmlEmail();
        try {
            email.setHtmlMsg("");
            Assert.fail((String)"Should fail here!");
        }
        catch (EmailException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid message supplied"));
        }
    }

    @Test
    public void testSendHtmlUrl() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default with URL";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject(strSubject);
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(TEST_IMAGE_DIR.toURI().toURL(), true));
        this.email.setHtmlMsg("<html><body><img src=\"http://www.apache.org/images/feather.gif\"/></body></html>");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtmlMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }

    @Test
    public void testSendHTMLAbsoluteLocalFile() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default with absolute local path";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject(strSubject);
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(TEST_IMAGE_DIR.toURI().toURL(), true));
        File file = File.createTempFile("emailtest", ".tst");
        FileUtils.writeStringToFile((File)file, (String)"just some silly data that we won't be able to display anyway");
        this.email.setHtmlMsg("<html><body><img src=\"" + file.getAbsolutePath() + "\"/></body></html>");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtmlMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }

    @Test
    public void testSendHTMLClassPathFile() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceClassPathResolver("/", true));
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject(strSubject);
        String html = this.loadUrlContent(TEST2_HTML_URL);
        this.email.setHtmlMsg(html);
        this.email.setTextMsg("Your email client does not support HTML messages");
        this.email.send();
        this.fakeMailServer.stop();
        Assert.assertEquals((long)1L, (long)this.fakeMailServer.getMessages().size());
        MimeMessage mimeMessage = ((WiserMessage)this.fakeMailServer.getMessages().get(0)).getMimeMessage();
        MimeMessageUtils.writeMimeMessage((MimeMessage)mimeMessage, (File)new File("./target/test-emails/testSendHTMLClassPathFile.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(mimeMessage).parse();
        Assert.assertTrue((boolean)mimeMessageParser.getHtmlContent().contains("\"cid:"));
        Assert.assertTrue((mimeMessageParser.getAttachmentList().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSendHTMLAutoResolveFile() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default";
        this.email = new MockImageHtmlEmailConcrete();
        DataSourceResolver[] dataSourceResolvers = new DataSourceResolver[]{new DataSourceUrlResolver(new URL("http://foo"), true), new DataSourceClassPathResolver("/", true)};
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceCompositeResolver(dataSourceResolvers));
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject(strSubject);
        String html = this.loadUrlContent(TEST2_HTML_URL);
        this.email.setHtmlMsg(html);
        this.email.setTextMsg("Your email client does not support HTML messages");
        this.email.send();
        this.fakeMailServer.stop();
        Assert.assertEquals((long)1L, (long)this.fakeMailServer.getMessages().size());
        MimeMessage mimeMessage = ((WiserMessage)this.fakeMailServer.getMessages().get(0)).getMimeMessage();
        MimeMessageUtils.writeMimeMessage((MimeMessage)mimeMessage, (File)new File("./target/test-emails/testSendHTMLAutoFile.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(mimeMessage).parse();
        Assert.assertTrue((boolean)mimeMessageParser.getHtmlContent().contains("\"cid:"));
        Assert.assertTrue((mimeMessageParser.getAttachmentList().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSendHTMLAutoResolveMultipleFiles() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default";
        this.email = new MockImageHtmlEmailConcrete();
        DataSourceClassPathResolver dataSourceResolver = new DataSourceClassPathResolver("/", true);
        this.email.setDataSourceResolver((DataSourceResolver)dataSourceResolver);
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject(strSubject);
        String html = "<p>First image  <img src=\"images/contentTypeTest.gif\"/></p><p>Second image <img src=\"images/contentTypeTest.jpg\"/></p><p>Third image  <img src=\"images/contentTypeTest.png\"/></p>";
        this.email.setHtmlMsg(html);
        this.email.setTextMsg("Your email client does not support HTML messages");
        this.email.send();
        this.fakeMailServer.stop();
        Assert.assertEquals((long)1L, (long)this.fakeMailServer.getMessages().size());
        MimeMessage mimeMessage = ((WiserMessage)this.fakeMailServer.getMessages().get(0)).getMimeMessage();
        MimeMessageUtils.writeMimeMessage((MimeMessage)mimeMessage, (File)new File("./target/test-emails/testSendHTMLAutoMultipleFiles.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(mimeMessage).parse();
        Assert.assertTrue((boolean)mimeMessageParser.getHtmlContent().contains("\"cid:"));
        Assert.assertTrue((mimeMessageParser.getAttachmentList().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testRegex() {
        Pattern pattern = Pattern.compile("(<[Ii][Mm][Gg]\\s*[^>]*?\\s+[Ss][Rr][Cc]\\s*=\\s*[\"'])([^\"']+?)([\"'])");
        Matcher matcher = pattern.matcher("<html><body><img src=\"h\"/></body></html>");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"h", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><img id=\"laskdasdkj\" src=\"h\"/></body></html>");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"h", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><IMG id=\"laskdasdkj\" SRC=\"h\"/></body></html>");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"h", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><img id=\"laskdasdkj\" src=\"http://dstadler1.org/\"/><img id=\"laskdasdkj\" src=\"http://dstadler2.org/\"/></body></html>");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"http://dstadler1.org/", (Object)matcher.group(2));
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"http://dstadler2.org/", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><img\n \rid=\"laskdasdkj\"\n \rsrc=\"http://dstadler1.org/\"/><img id=\"laskdasdkj\" src=\"http://dstadler2.org/\"/></body></html>");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"http://dstadler1.org/", (Object)matcher.group(2));
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"http://dstadler2.org/", (Object)matcher.group(2));
        matcher = pattern.matcher("<html><body><img\n \t\rid=\"laskdasdkj\"\n \rsrc \n =\r  \"http://dstadler1.org/\"/><img  \r  id=\" laskdasdkj\"    src    =   \"http://dstadler2.org/\"/></body></html>");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"http://dstadler1.org/", (Object)matcher.group(2));
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"http://dstadler2.org/", (Object)matcher.group(2));
        matcher = pattern.matcher("<img alt=\"Chart?ck=xradar&amp;w=120&amp;h=120&amp;c=7fff00|7fff00&amp;m=4&amp;g=0\" src=\"/chart?ck=xradar&amp;w=120&amp;h=120&amp;c=7fff00|7fff00&amp;m=4&amp;g=0.2&amp;l=A,C,S,T&amp;v=3.0,3.0,2.0,2.0\"");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"/chart?ck=xradar&amp;w=120&amp;h=120&amp;c=7fff00|7fff00&amp;m=4&amp;g=0.2&amp;l=A,C,S,T&amp;v=3.0,3.0,2.0,2.0", (Object)matcher.group(2));
        matcher = pattern.matcher("<img src=\"file1\"/><img src=\"file2\"/>");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"file1", (Object)matcher.group(2));
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"file2", (Object)matcher.group(2));
        matcher = pattern.matcher("<img src=\"file1\"/><img src=\"file2\"/><img src=\"file3\"/><img src=\"file4\"/><img src=\"file5\"/>");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"file1", (Object)matcher.group(2));
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"file2", (Object)matcher.group(2));
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"file3", (Object)matcher.group(2));
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"file4", (Object)matcher.group(2));
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"file5", (Object)matcher.group(2));
        matcher = pattern.matcher("<img src=\"file1\"><img src=\"file2\">");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"file1", (Object)matcher.group(2));
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"file2", (Object)matcher.group(2));
    }

    @Test
    public void testEmail127() throws Exception {
        Logger.getLogger(ImageHtmlEmail.class.getName()).setLevel(Level.FINEST);
        this.getMailServer();
        String strSubject = "Test HTML Send default with URL";
        this.email = new MockImageHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setSubject(strSubject);
        this.email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(TEST_IMAGE_DIR.toURI().toURL(), true));
        this.email.setHtmlMsg("<html><body><img title=\"$\" src=\"http://www.apache.org/images/feather.gif\"/></body></html>");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, strSubject, this.email.getHtmlMsg(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadUrlContent(URL url) throws IOException {
        InputStream stream = url.openStream();
        StringBuilder html = new StringBuilder();
        try {
            List lines = IOUtils.readLines((InputStream)stream);
            for (String line : lines) {
                html.append(line).append("\n");
            }
        }
        finally {
            stream.close();
        }
        return html.toString();
    }
}

