/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.File;
import java.io.IOException;
import org.apache.commons.mail.resolver.AbstractDataSourceResolverTest;
import org.apache.commons.mail.resolver.DataSourceFileResolver;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceFileResolverTest
extends AbstractDataSourceResolverTest {
    @Test
    public void testResolvingFileLenient() throws Exception {
        DataSourceFileResolver dataSourceResolver = new DataSourceFileResolver(new File("./src/test/resources"), true);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("./images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertTrue((this.toByteArray(dataSourceResolver.resolve("../resources/images/asf_logo_wide.gif")).length == 5866 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.toByteArray(dataSourceResolver.resolve("/images/does-not-exist.gif")));
        Assert.assertNull((Object)dataSourceResolver.resolve("./images/does-not-exist.gif"));
    }

    @Test(expected=IOException.class)
    public void testResolvingFileNonLenient() throws Exception {
        DataSourceFileResolver dataSourceResolver = new DataSourceFileResolver(new File("."), false);
        Assert.assertNotNull((Object)dataSourceResolver.resolve("./src/test/resources/images/asf_logo_wide.gif"));
        dataSourceResolver.resolve("asf_logo_wide.gif");
    }
}

