/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.UnsupportedEncodingException;
import org.apache.commons.mail.EmailUtils;
import org.junit.Assert;
import org.junit.Test;

public class EmailUtilsTest {
    @Test
    public void testClearEndOfLineCharacters() {
        Assert.assertEquals(null, (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces(null));
        Assert.assertEquals((Object)"", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)""));
        Assert.assertEquals((Object)"   ", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"   "));
        Assert.assertEquals((Object)"abcdefg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abcdefg"));
        Assert.assertEquals((Object)"abc defg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abc\rdefg"));
        Assert.assertEquals((Object)"abc defg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abc\ndefg"));
        Assert.assertEquals((Object)"abc  defg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abc\r\ndefg"));
        Assert.assertEquals((Object)"abc  defg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abc\n\rdefg"));
    }

    @Test
    public void testUrlEncoding() throws UnsupportedEncodingException {
        Assert.assertEquals((Object)"abcdefg", (Object)EmailUtils.encodeUrl((String)"abcdefg"));
        Assert.assertEquals((Object)"0123456789", (Object)EmailUtils.encodeUrl((String)"0123456789"));
        Assert.assertEquals((Object)"Test%20CID", (Object)EmailUtils.encodeUrl((String)"Test CID"));
        Assert.assertEquals((Object)"joe.doe@apache.org", (Object)EmailUtils.encodeUrl((String)"joe.doe@apache.org"));
        Assert.assertEquals((Object)"joe+doe@apache.org", (Object)EmailUtils.encodeUrl((String)"joe+doe@apache.org"));
        Assert.assertEquals((Object)"peter%26paul%26mary@oldmusic.org", (Object)EmailUtils.encodeUrl((String)"peter&paul&mary@oldmusic.org"));
    }
}

