/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.mail.activation.InputStreamDataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InputStreamDataSourceTest {
    @Test
    public void testGetContentType() {
        Assertions.assertEquals((Object)"text/plain", (Object)new InputStreamDataSource(null, "text/plain").getContentType());
    }

    @Test
    public void testGetInputStream() throws IOException {
        byte[] testData = "Test data for InputStream".getBytes();
        ByteArrayInputStream testInputStream = new ByteArrayInputStream(testData);
        InputStreamDataSource dataSource = new InputStreamDataSource((InputStream)testInputStream, "application/octet-stream");
        try (InputStream inputStream = dataSource.getInputStream();){
            byte[] readData = new byte[testData.length];
            int bytesRead = inputStream.read(readData);
            Assertions.assertEquals((int)testData.length, (int)bytesRead);
            Assertions.assertArrayEquals((byte[])testData, (byte[])readData);
        }
    }

    @Test
    public void testGetName() {
        Assertions.assertEquals((Object)"document.pdf", (Object)new InputStreamDataSource(null, "application/pdf", "document.pdf").getName());
    }

    @Test
    public void testGetOutputStream() {
        InputStreamDataSource dataSource = new InputStreamDataSource(null, "text/html");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((InputStreamDataSource)dataSource).getOutputStream());
    }

    @Test
    public void testSetName() {
        Assertions.assertEquals((Object)"image.jpg", (Object)new InputStreamDataSource(null, "image/jpeg", "image.jpg").getName());
    }
}

