/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.mail.AbstractEmailTest;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailConstants;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.mocks.MockMultiPartEmailConcrete;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MultiPartEmailTest
extends AbstractEmailTest {
    private MockMultiPartEmailConcrete email;
    private File testFile;
    private Path testPath;

    @BeforeEach
    public void setUpMultiPartEmailTest() throws Exception {
        this.email = new MockMultiPartEmailConcrete();
        this.testFile = File.createTempFile("testfile", ".txt");
        this.testPath = this.testFile.toPath();
    }

    @Test
    public void testAddPart() throws Exception {
        this.email = new MockMultiPartEmailConcrete();
        String strMessage = "hello";
        String strContentType = "text/plain";
        this.email.addPart("hello", "text/plain");
        Assertions.assertEquals((Object)"text/plain", (Object)this.email.getContainer().getBodyPart(0).getContentType());
        Assertions.assertEquals((Object)"hello", (Object)this.email.getContainer().getBodyPart(0).getDataHandler().getContent());
    }

    @Test
    public void testAddPart2() throws Exception {
        this.email = new MockMultiPartEmailConcrete();
        String strSubtype = "subtype/abc123";
        this.email.addPart(new MimeMultipart("subtype/abc123"));
        Assertions.assertTrue((boolean)this.email.getContainer().getBodyPart(0).getDataHandler().getContentType().contains("subtype/abc123"));
    }

    @Test
    public void testAttach2() throws MalformedURLException, EmailException {
        this.email.attach(new URL(this.strTestURL), "Test Attachment", "Test Attachment Desc");
        this.email.attach(new URL(this.strTestURL), null, "Test Attachment Desc");
    }

    @Test
    public void testAttach3() throws Exception {
        this.email.attach((DataSource)new URLDataSource(new URL(this.strTestURL)), "Test Attachment", "Test Attachment Desc");
        Assertions.assertThrows(EmailException.class, () -> this.email.attach((DataSource)((URLDataSource)null), "Test Attachment", "Test Attachment Desc"));
        Assertions.assertThrows(EmailException.class, () -> this.email.attach((DataSource)new URLDataSource(this.createInvalidURL()), "Test Attachment", "Test Attachment Desc"));
    }

    @Test
    public void testAttachFile() throws Exception {
        EmailAttachment attachment1 = new EmailAttachment();
        attachment1.setName("Test Attachment");
        attachment1.setDescription("Test Attachment Desc");
        attachment1.setPath(this.testFile.getAbsolutePath());
        this.email.attach(attachment1);
        Assertions.assertTrue((boolean)this.email.isBoolHasAttachments());
        EmailAttachment attachment2 = new EmailAttachment();
        attachment2.setName("Test Attachment");
        attachment2.setDescription("Test Attachment Desc");
        attachment2.setURL(new URL(this.strTestURL));
        this.email.attach(attachment2);
        this.email.attach(this.testFile);
        Assertions.assertTrue((boolean)this.email.isBoolHasAttachments());
        Assertions.assertThrows(EmailException.class, () -> this.email.attach(null));
        EmailAttachment attachment3 = new EmailAttachment();
        attachment3.setURL(this.createInvalidURL());
        Assertions.assertThrows(EmailException.class, () -> this.email.attach(attachment3));
        EmailAttachment attachment4 = new EmailAttachment();
        attachment4.setPath("");
        Assertions.assertThrows(EmailException.class, () -> this.email.attach(attachment4));
    }

    @Test
    public void testAttachFileLocking() throws Exception {
        File tmpFile = File.createTempFile("attachment", ".eml");
        this.email.attach((DataSource)new FileDataSource(tmpFile), "Test Attachment", "Test Attachment Desc");
        Assertions.assertTrue((boolean)tmpFile.delete());
    }

    @Test
    public void testAttachPath() throws Exception {
        EmailAttachment attachment1 = new EmailAttachment();
        attachment1.setName("Test Attachment");
        attachment1.setDescription("Test Attachment Desc");
        attachment1.setPath(this.testPath.toAbsolutePath().toString());
        this.email.attach(attachment1);
        Assertions.assertTrue((boolean)this.email.isBoolHasAttachments());
        EmailAttachment attachment2 = new EmailAttachment();
        attachment2.setName("Test Attachment");
        attachment2.setDescription("Test Attachment Desc");
        attachment2.setURL(new URL(this.strTestURL));
        this.email.attach(attachment2);
        this.email.attach(this.testPath, new OpenOption[0]);
        Assertions.assertTrue((boolean)this.email.isBoolHasAttachments());
        Assertions.assertThrows(EmailException.class, () -> this.email.attach(null));
        EmailAttachment attachment3 = new EmailAttachment();
        attachment3.setURL(this.createInvalidURL());
        Assertions.assertThrows(EmailException.class, () -> this.email.attach(attachment3));
        EmailAttachment attachment4 = new EmailAttachment();
        attachment4.setPath("");
        Assertions.assertThrows(EmailException.class, () -> this.email.attach(attachment4));
    }

    @Test
    public void testGetContainer() {
        Assertions.assertTrue((boolean)true);
    }

    @Test
    public void testGetSetSubType() {
        for (String validChar : this.testCharsValid) {
            this.email.setSubType(validChar);
            Assertions.assertEquals((Object)validChar, (Object)this.email.getSubType());
        }
    }

    @Test
    public void testInit() {
        this.email.init();
        Assertions.assertThrows(IllegalStateException.class, () -> ((MockMultiPartEmailConcrete)this.email).init());
    }

    @Test
    public void testSend() throws EmailException, IOException {
        this.getMailServer();
        String strSubject = "Test Multipart Send Subject";
        EmailAttachment attachment = new EmailAttachment();
        attachment.setPath(this.testFile.getAbsolutePath());
        attachment.setDisposition("attachment");
        attachment.setName("Test_Attachment");
        attachment.setDescription("Test Attachment Desc");
        MockMultiPartEmailConcrete testEmail = new MockMultiPartEmailConcrete();
        testEmail.setHostName(this.strTestMailServer);
        testEmail.setSmtpPort(this.getMailServerPort());
        testEmail.setFrom(this.strTestMailFrom);
        testEmail.addTo(this.strTestMailTo);
        testEmail.attach(attachment);
        testEmail.setSubType("subType");
        if (EmailUtils.isNotEmpty((String)this.strTestUser) && EmailUtils.isNotEmpty((String)this.strTestPasswd)) {
            testEmail.setAuthentication(this.strTestUser, this.strTestPasswd);
        }
        testEmail.setSubject("Test Multipart Send Subject");
        testEmail.setMsg("Test Message");
        HashMap<String, String> ht = new HashMap<String, String>();
        ht.put("X-Priority", "2");
        ht.put("Disposition-Notification-To", this.strTestMailFrom);
        ht.put("X-Mailer", "Sendmail");
        testEmail.setHeaders(ht);
        testEmail.send();
        this.stopServer();
        this.validateSend(this.fakeMailServer, "Test Multipart Send Subject", testEmail.getMsg(), testEmail.getFromAddress(), (List<InternetAddress>)testEmail.getToAddresses(), (List<InternetAddress>)testEmail.getCcAddresses(), (List<InternetAddress>)testEmail.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, "Test Multipart Send Subject", attachment.getName(), testEmail.getFromAddress(), (List<InternetAddress>)testEmail.getToAddresses(), (List<InternetAddress>)testEmail.getCcAddresses(), (List<InternetAddress>)testEmail.getBccAddresses(), false);
        this.getMailServer();
        Assertions.assertThrows(EmailException.class, () -> ((MockMultiPartEmailConcrete)this.email).send());
    }

    @Test
    public void testSetMsg() throws EmailException {
        for (String validChar : this.testCharsValid) {
            this.email.setMsg(validChar);
            Assertions.assertEquals((Object)validChar, (Object)this.email.getMsg());
        }
        this.email.setCharset(EmailConstants.US_ASCII);
        for (String validChar : this.testCharsValid) {
            this.email.setMsg(validChar);
            Assertions.assertEquals((Object)validChar, (Object)this.email.getMsg());
        }
        for (String invalidChar : this.testCharsNotValid) {
            Assertions.assertThrows(EmailException.class, () -> this.email.setMsg(invalidChar));
        }
    }
}

