/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.apache.commons.mail.AbstractEmailTest;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailConstants;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.mocks.MockHtmlEmailConcrete;
import org.apache.commons.mail.settings.EmailConfiguration;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SendWithAttachmentsTest
extends AbstractEmailTest {
    private MockHtmlEmailConcrete email;

    @BeforeEach
    public void setUpSendWithAttachmentsTest() {
        this.email = new MockHtmlEmailConcrete();
    }

    @Test
    public void testSendNoAttachments() throws EmailException, IOException {
        this.getMailServer();
        String strSubject = "Test HTML Send #1 Subject (w charset)";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        this.email.setCharset(EmailConstants.ISO_8859_1);
        this.email.setSubject("Test HTML Send #1 Subject (w charset)");
        URL url = new URL(EmailConfiguration.TEST_URL);
        String cid = this.email.embed(url, "Apache Logo");
        String strHtmlMsg = "<html>The Apache logo - <img src=\"cid:" + cid + "\"><html>";
        this.email.setHtmlMsg(strHtmlMsg);
        this.email.setTextMsg("Your email client does not support HTML emails");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "Test HTML Send #1 Subject (w charset)", this.email.getText(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, "Test HTML Send #1 Subject (w charset)", this.email.getHtml(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
    }

    @Test
    public void testSendWAttachments() throws EmailException, IOException {
        EmailAttachment attachment = new EmailAttachment();
        File testFile = File.createTempFile("commons-email-testfile", ".txt");
        this.getMailServer();
        String strSubject = "Test HTML Send #1 Subject (w charset)";
        this.email = new MockHtmlEmailConcrete();
        this.email.setHostName(this.strTestMailServer);
        this.email.setSmtpPort(this.getMailServerPort());
        this.email.setFrom(this.strTestMailFrom);
        this.email.addTo(this.strTestMailTo);
        attachment.setName("a>\u00e4, o>\u00f6, u>\u00fc, au>\u00e4u");
        attachment.setDescription("Test Attachment Desc");
        attachment.setPath(testFile.getAbsolutePath());
        this.email.attach(attachment);
        this.email.setAuthentication(this.strTestUser, this.strTestPasswd);
        this.email.setCharset(EmailConstants.ISO_8859_1);
        this.email.setSubject("Test HTML Send #1 Subject (w charset)");
        String strHtmlMsg = "<html>Test Message<html>";
        this.email.setHtmlMsg("<html>Test Message<html>");
        this.email.setTextMsg("Your email client does not support HTML emails");
        this.email.send();
        this.fakeMailServer.stop();
        this.validateSend(this.fakeMailServer, "Test HTML Send #1 Subject (w charset)", this.email.getText(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), true);
        this.validateSend(this.fakeMailServer, "Test HTML Send #1 Subject (w charset)", this.email.getHtml(), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
        this.validateSend(this.fakeMailServer, "Test HTML Send #1 Subject (w charset)", MimeUtility.encodeText((String)attachment.getName()), this.email.getFromAddress(), (List<InternetAddress>)this.email.getToAddresses(), (List<InternetAddress>)this.email.getCcAddresses(), (List<InternetAddress>)this.email.getBccAddresses(), false);
    }
}

