/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.mail.mocks;

import java.io.IOException;
import java.util.List;

import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

import org.apache.commons.mail.MultiPartEmail;

/**
 * Extension of MultiPartEmail Class
 * (used to allow testing only)
 *
 * @since 1.0
 * @author <a href="mailto:corey.scott@gmail.com">Corey Scott</a>
 * @version $Id: MockMultiPartEmailConcrete.java 480401 2006-11-29 04:40:04Z bayard $
 */
public class MockMultiPartEmailConcrete extends MultiPartEmail
{

    /**
     * Retrieve the message content
     * @return Message Content
     */
    public String getMsg()
    {
        try
        {
            return this.getPrimaryBodyPart().getContent().toString();
        }
        catch (IOException ioE)
        {
            return null;
        }
        catch (MessagingException msgE)
        {
            return null;
        }
    }

    /**
     */
    public void initTest()
    {
        this.init();
    }

    /**
     * @return fromAddress
     */
    public InternetAddress getFromAddress()
    {
        return this.fromAddress;
    }

    /**
     * @return toList
     */
    public List getToList()
    {
        return this.toList;
    }

    /**
     * @return bccList
     */
    public List getBccList()
    {
        return this.bccList;
    }

    /**
     * @return ccList
     */
    public List getCcList()
    {
        return this.ccList;
    }

}
