/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.util.Arrays;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.exec.OS;

public final class TestUtil {
    private TestUtil() {
    }

    public static File resolveScriptForOS(String script) {
        if (OS.isFamilyWindows()) {
            return new File(script + ".bat");
        }
        if (OS.isFamilyUnix()) {
            return new File(script + ".sh");
        }
        if (OS.isFamilyOpenVms()) {
            return new File(script + ".dcl");
        }
        throw new AssertionFailedError("Test not supported for this OS");
    }

    public static int[] getTestScriptCodesForOS() {
        if (OS.isFamilyWindows()) {
            return new int[]{0, 1};
        }
        if (OS.isFamilyUnix()) {
            return new int[]{0, 1};
        }
        if (OS.isFamilyOpenVms()) {
            return new int[]{1, 2};
        }
        throw new AssertionFailedError("Test not supported for this OS");
    }

    public static void assertEquals(Object[] expected, Object[] actual, boolean orderSignificant) {
        if (expected != null || actual != null) {
            if (actual == null) {
                throw new AssertionFailedError("Expected non null array");
            }
            if (expected == null) {
                throw new AssertionFailedError("Expected null array");
            }
            if (expected.length != actual.length) {
                throw new AssertionFailedError("Arrays not of same length");
            }
            if (!orderSignificant) {
                Arrays.sort(expected);
                Arrays.sort(actual);
            }
            for (int i = 0; i < actual.length; ++i) {
                TestCase.assertEquals((String)("Array element at " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
    }
}

