/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.TestUtil;

public class TutorialTest
extends TestCase {
    private final File testDir = new File("src/test/scripts");
    private final File acroRd32Script = TestUtil.resolveScriptForOS(this.testDir + "/acrord32");

    public void testTutorialExample() throws Exception {
        PrintResultHandler printResult;
        long printJobTimeout = 15000L;
        boolean printInBackground = false;
        File pdfFile = new File("/Documents and Settings/foo.pdf");
        try {
            System.out.println("[main] Preparing print job ...");
            printResult = this.print(pdfFile, 15000L, false);
            System.out.println("[main] Successfully sent the print job ...");
        }
        catch (Exception e) {
            e.printStackTrace();
            TutorialTest.fail((String)("[main] Printing of the following document failed : " + pdfFile.getAbsolutePath()));
            throw e;
        }
        System.out.println("[main] Test is exiting but waiting for the print job to finish...");
        printResult.waitFor();
        System.out.println("[main] The print job has finished ...");
    }

    public PrintResultHandler print(File file, long printJobTimeout, boolean printInBackground) throws IOException {
        PrintResultHandler resultHandler;
        ExecuteWatchdog watchdog = null;
        HashMap<String, File> map = new HashMap<String, File>();
        map.put("file", file);
        CommandLine commandLine = new CommandLine(this.acroRd32Script);
        commandLine.addArgument("/p");
        commandLine.addArgument("/h");
        commandLine.addArgument("${file}");
        commandLine.setSubstitutionMap(map);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(1);
        if (printJobTimeout > 0L) {
            watchdog = new ExecuteWatchdog(printJobTimeout);
            executor.setWatchdog(watchdog);
        }
        if (printInBackground) {
            System.out.println("[print] Executing non-blocking print job  ...");
            resultHandler = new PrintResultHandler(watchdog);
            executor.execute(commandLine, (ExecuteResultHandler)resultHandler);
        } else {
            System.out.println("[print] Executing blocking print job  ...");
            int exitValue = executor.execute(commandLine);
            resultHandler = new PrintResultHandler(exitValue);
        }
        return resultHandler;
    }

    private class PrintResultHandler
    extends DefaultExecuteResultHandler {
        private ExecuteWatchdog watchdog;

        public PrintResultHandler(ExecuteWatchdog watchdog) {
            this.watchdog = watchdog;
        }

        public PrintResultHandler(int exitValue) {
            super.onProcessComplete(exitValue);
        }

        public void onProcessComplete(int exitValue) {
            super.onProcessComplete(exitValue);
            System.out.println("[resultHandler] The document was successfully printed ...");
        }

        public void onProcessFailed(ExecuteException e) {
            super.onProcessFailed(e);
            if (this.watchdog != null && this.watchdog.killedProcess()) {
                System.err.println("[resultHandler] The print process timed out");
            } else {
                System.err.println("[resultHandler] The print process failed to do : " + e.getMessage());
            }
        }
    }
}

