/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.environment;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.TestUtil;
import org.apache.commons.exec.environment.EnvironmentUtils;

public class EnvironmentUtilTest
extends TestCase {
    public void testToStrings() {
        TestUtil.assertEquals(null, EnvironmentUtils.toStrings(null), false);
        HashMap<String, String> env = new HashMap<String, String>();
        TestUtil.assertEquals(new String[0], EnvironmentUtils.toStrings(env), false);
        env.put("foo2", "bar2");
        env.put("foo", "bar");
        Object[] envStrings = EnvironmentUtils.toStrings(env);
        Object[] expected = new String[]{"foo=bar", "foo2=bar2"};
        TestUtil.assertEquals(expected, envStrings, false);
    }

    public void testGetProcEnvironment() throws IOException {
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        EnvironmentUtilTest.assertTrue((String)"Expecting non-zero environment size", (procEnvironment.size() > 0 ? 1 : 0) != 0);
        String[] envArgs = EnvironmentUtils.toStrings((Map)procEnvironment);
        for (int i = 0; i < envArgs.length; ++i) {
            EnvironmentUtilTest.assertNotNull((String)("Entry " + i + " should not be null"), (Object)envArgs[i]);
            EnvironmentUtilTest.assertTrue((String)("Entry " + i + " should not be empty"), (envArgs[i].length() > 0 ? 1 : 0) != 0);
        }
    }

    public void testGetProcEnvironmentCaseInsensitiveLookup() throws IOException {
        if (!OS.isFamilyWindows()) {
            return;
        }
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        Iterator it = procEnvironment.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            EnvironmentUtilTest.assertEquals((Object)value, procEnvironment.get(key.toLowerCase(Locale.ENGLISH)));
            EnvironmentUtilTest.assertEquals((Object)value, procEnvironment.get(key.toUpperCase(Locale.ENGLISH)));
        }
        EnvironmentUtils.addVariableToEnvironment((Map)procEnvironment, (String)"foo=bar");
        EnvironmentUtilTest.assertEquals((Object)"bar", procEnvironment.get("FOO"));
        EnvironmentUtilTest.assertEquals((Object)"bar", procEnvironment.get("Foo"));
        EnvironmentUtilTest.assertEquals((Object)"bar", procEnvironment.get("foo"));
    }

    public void testCaseInsensitiveVariableLookup() throws Exception {
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        EnvironmentUtils.addVariableToEnvironment((Map)procEnvironment, (String)"foo=bAr");
        EnvironmentUtilTest.assertEquals((Object)"bAr", procEnvironment.get("foo"));
    }
}

