/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.util.StringUtils;

public class CommandLineTest
extends TestCase {
    private void assertEquals(String[] expected, String[] actual) {
        if (!Arrays.equals(expected, actual)) {
            throw new AssertionFailedError("Arrays not equal");
        }
    }

    public void testExecutable() {
        CommandLine cmdl = new CommandLine("test");
        CommandLineTest.assertEquals((String)"[test]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test"}, cmdl.toStrings());
        CommandLineTest.assertEquals((String)"test", (String)cmdl.getExecutable());
        CommandLineTest.assertTrue((cmdl.getArguments().length == 0 ? 1 : 0) != 0);
    }

    public void testExecutableZeroLengthString() {
        try {
            new CommandLine("");
            CommandLineTest.fail((String)"Must throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecutableWhitespaceString() {
        try {
            new CommandLine("   ");
            CommandLineTest.fail((String)"Must throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullExecutable() {
        try {
            new CommandLine((String)null);
            CommandLineTest.fail((String)"Must throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddArgument() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("foo");
        cmdl.addArgument("bar");
        CommandLineTest.assertEquals((String)"[test, foo, bar]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "bar"}, cmdl.toStrings());
    }

    public void testAddNullArgument() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument(null);
        CommandLineTest.assertEquals((String)"[test]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test"}, cmdl.toStrings());
    }

    public void testAddArgumentWithSpace() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("foo");
        cmdl.addArgument("ba r");
        CommandLineTest.assertEquals((String)"[test, foo, \"ba r\"]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "\"ba r\""}, cmdl.toStrings());
    }

    public void testAddArgumentWithQuote() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("foo");
        cmdl.addArgument("ba\"r");
        CommandLineTest.assertEquals((String)"[test, foo, 'ba\"r']", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "'ba\"r'"}, cmdl.toStrings());
    }

    public void testAddArgumentWithQuotesAround() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("'foo'");
        cmdl.addArgument("\"bar\"");
        cmdl.addArgument("\"fe z\"");
        CommandLineTest.assertEquals((String)"[test, foo, bar, \"fe z\"]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "bar", "\"fe z\""}, cmdl.toStrings());
    }

    public void testAddArgumentWithSingleQuote() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("foo");
        cmdl.addArgument("ba'r");
        CommandLineTest.assertEquals((String)"[test, foo, \"ba'r\"]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "\"ba'r\""}, cmdl.toStrings());
    }

    public void testAddArgumentWithBothQuotes() {
        CommandLine cmdl = new CommandLine("test");
        try {
            cmdl.addArgument("b\"a'r");
            CommandLineTest.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddArguments() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments("foo bar");
        CommandLineTest.assertEquals((String)"[test, foo, bar]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "bar"}, cmdl.toStrings());
    }

    public void testAddArgumentsWithQuotes() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments("'foo' \"bar\"");
        CommandLineTest.assertEquals((String)"[test, foo, bar]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "bar"}, cmdl.toStrings());
    }

    public void testAddArgumentsWithQuotesAndSpaces() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments("'fo o' \"ba r\"");
        CommandLineTest.assertEquals((String)"[test, \"fo o\", \"ba r\"]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "\"fo o\"", "\"ba r\""}, cmdl.toStrings());
    }

    public void testAddArgumentsArray() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments(new String[]{"foo", "bar"});
        CommandLineTest.assertEquals((String)"[test, foo, bar]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "bar"}, cmdl.toStrings());
    }

    public void testAddArgumentsArrayNull() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments((String[])null);
        CommandLineTest.assertEquals((String)"[test]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test"}, cmdl.toStrings());
    }

    public void testAddTwoArguments() {
        CommandLine userAddCL1 = new CommandLine("useradd");
        userAddCL1.addArgument("-g");
        userAddCL1.addArgument("tomcat");
        userAddCL1.addArgument("foo");
        CommandLine userAddCL2 = new CommandLine("useradd");
        userAddCL2.addArgument("-g").addArgument("tomcat");
        userAddCL2.addArgument("foo");
        CommandLineTest.assertEquals((String)userAddCL1.toString(), (String)userAddCL2.toString());
    }

    public void testParseCommandLine() {
        CommandLine cmdl = CommandLine.parse((String)"test foo bar");
        CommandLineTest.assertEquals((String)"[test, foo, bar]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "bar"}, cmdl.toStrings());
    }

    public void testParseCommandLineWithQuotes() {
        CommandLine cmdl = CommandLine.parse((String)"test \"foo\" 'ba r'");
        CommandLineTest.assertEquals((String)"[test, foo, \"ba r\"]", (String)cmdl.toString());
        this.assertEquals(new String[]{"test", "foo", "\"ba r\""}, cmdl.toStrings());
    }

    public void testParseCommandLineWithUnevenQuotes() {
        try {
            CommandLine.parse((String)"test \"foo bar");
            CommandLineTest.fail((String)"IllegalArgumentException must be thrown due to uneven quotes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseCommandLineWithNull() {
        try {
            CommandLine.parse(null);
            CommandLineTest.fail((String)"IllegalArgumentException must be thrown due to incorrect command line");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseCommandLineWithOnlyWhitespace() {
        try {
            CommandLine.parse((String)"  ");
            CommandLineTest.fail((String)"IllegalArgumentException must be thrown due to incorrect command line");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseComplexCommandLine1() {
        HashMap<String, String> substitutionMap = new HashMap<String, String>();
        substitutionMap.put("in", "source.jpg");
        substitutionMap.put("out", "target.jpg");
        CommandLine cmdl = CommandLine.parse((String)"cmd /C convert ${in} -resize \"'500x> '\" ${out}", substitutionMap);
        CommandLineTest.assertEquals((String)"[cmd, /C, convert, source.jpg, -resize, \"500x> \", target.jpg]", (String)cmdl.toString());
    }

    public void testParseComplexCommandLine2() {
        String commandline = "./script/jrake cruise:publish_installers INSTALLER_VERSION=unstable_2_1 INSTALLER_PATH=\"/var/lib/ cruise-agent/installers\" INSTALLER_DOWNLOAD_SERVER='something' WITHOUT_HELP_DOC=true";
        CommandLine cmdl = CommandLine.parse((String)"./script/jrake cruise:publish_installers INSTALLER_VERSION=unstable_2_1 INSTALLER_PATH=\"/var/lib/ cruise-agent/installers\" INSTALLER_DOWNLOAD_SERVER='something' WITHOUT_HELP_DOC=true");
        String[] args = cmdl.getArguments();
        CommandLineTest.assertEquals((String)args[0], (String)"cruise:publish_installers");
        CommandLineTest.assertEquals((String)args[1], (String)"INSTALLER_VERSION=unstable_2_1");
        CommandLineTest.assertEquals((String)args[4], (String)"WITHOUT_HELP_DOC=true");
    }

    public void testParseRealLifeCommandLine_1() {
        String commandline = "cmd.exe /C \"c:\\was51\\Web Sphere\\AppServer\\bin\\versionInfo.bat\"";
        CommandLine cmdl = CommandLine.parse((String)"cmd.exe /C \"c:\\was51\\Web Sphere\\AppServer\\bin\\versionInfo.bat\"");
        String[] args = cmdl.getArguments();
        CommandLineTest.assertEquals((String)"/C", (String)args[0]);
        CommandLineTest.assertEquals((String)"\"c:\\was51\\Web Sphere\\AppServer\\bin\\versionInfo.bat\"", (String)args[1]);
    }

    public void testComplexAddArgument() {
        CommandLine cmdl = new CommandLine("runMemorySud.cmd");
        cmdl.addArgument("10", false);
        cmdl.addArgument("30", false);
        cmdl.addArgument("-XX:+UseParallelGC", false);
        cmdl.addArgument("\"-XX:ParallelGCThreads=2\"", false);
        this.assertEquals(new String[]{"runMemorySud.cmd", "10", "30", "-XX:+UseParallelGC", "\"-XX:ParallelGCThreads=2\""}, cmdl.toStrings());
    }

    public void testComplexAddArguments1() {
        CommandLine cmdl = new CommandLine("runMemorySud.cmd");
        cmdl.addArguments(new String[]{"10", "30", "-XX:+UseParallelGC", "\"-XX:ParallelGCThreads=2\""}, false);
        this.assertEquals(new String[]{"runMemorySud.cmd", "10", "30", "-XX:+UseParallelGC", "\"-XX:ParallelGCThreads=2\""}, cmdl.toStrings());
    }

    public void testComplexAddArguments2() {
        CommandLine cmdl = new CommandLine("runMemorySud.cmd");
        cmdl.addArguments("10 30 -XX:+UseParallelGC '\"-XX:ParallelGCThreads=2\"'", false);
        this.assertEquals(new String[]{"runMemorySud.cmd", "10", "30", "-XX:+UseParallelGC", "\"-XX:ParallelGCThreads=2\""}, cmdl.toStrings());
    }

    public void testCommandLineParsingWithExpansion1() {
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("JAVA_HOME", "/usr/local/java");
        substitutionMap.put("appMainClass", "foo.bar.Main");
        substitutionMap.put("file1", new File("./pom.xml"));
        substitutionMap.put("file2", new File(".\\temp\\READ ME.txt"));
        HashMap<String, String> incompleteMap = new HashMap<String, String>();
        incompleteMap.put("JAVA_HOME", "/usr/local/java");
        CommandLine cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass}");
        CommandLineTest.assertTrue((cmdl.getExecutable().indexOf("${JAVA_HOME}") == 0 ? 1 : 0) != 0);
        this.assertEquals(new String[]{"${appMainClass}"}, cmdl.getArguments());
        cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass}", new HashMap());
        CommandLineTest.assertTrue((cmdl.getExecutable().indexOf("${JAVA_HOME}") == 0 ? 1 : 0) != 0);
        this.assertEquals(new String[]{"${appMainClass}"}, cmdl.getArguments());
        cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass}", substitutionMap);
        CommandLineTest.assertTrue((cmdl.getExecutable().indexOf("${JAVA_HOME}") < 0 ? 1 : 0) != 0);
        CommandLineTest.assertTrue((cmdl.getExecutable().indexOf("local") > 0 ? 1 : 0) != 0);
        this.assertEquals(new String[]{"foo.bar.Main"}, cmdl.getArguments());
        cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass}", incompleteMap);
        CommandLineTest.assertTrue((cmdl.getExecutable().indexOf("${JAVA_HOME}") < 0 ? 1 : 0) != 0);
        CommandLineTest.assertTrue((cmdl.getExecutable().indexOf("local") > 0 ? 1 : 0) != 0);
        this.assertEquals(new String[]{"${appMainClass}"}, cmdl.getArguments());
        cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass} ${file1} ${file2}", substitutionMap);
        CommandLineTest.assertTrue((cmdl.getExecutable().indexOf("${file}") < 0 ? 1 : 0) != 0);
    }

    public void testCommandLineParsingWithExpansion2() {
        HashMap<String, String> substitutionMap = new HashMap<String, String>();
        substitutionMap.put("JAVA_HOME", "C:\\Programme\\jdk1.5.0_12");
        substitutionMap.put("appMainClass", "foo.bar.Main");
        CommandLine cmdl = new CommandLine("${JAVA_HOME}\\bin\\java");
        cmdl.addArgument("-class");
        cmdl.addArgument("${appMainClass}");
        cmdl.addArgument("${file}");
        substitutionMap.put("file", "C:\\Document And Settings\\documents\\432431.pdf");
        cmdl.setSubstitutionMap(substitutionMap);
        String[] result = cmdl.toStrings();
        CommandLineTest.assertEquals((String)StringUtils.fixFileSeparatorChar((String)"C:\\Programme\\jdk1.5.0_12\\bin\\java"), (String)result[0]);
        CommandLineTest.assertEquals((String)"-class", (String)result[1]);
        CommandLineTest.assertEquals((String)"foo.bar.Main", (String)result[2]);
        CommandLineTest.assertEquals((String)"\"C:\\Document And Settings\\documents\\432431.pdf\"", (String)result[3]);
        String executable = cmdl.getExecutable();
        String[] arguments = cmdl.getArguments();
        CommandLineTest.assertEquals((String)StringUtils.fixFileSeparatorChar((String)"C:\\Programme\\jdk1.5.0_12\\bin\\java"), (String)executable);
        CommandLineTest.assertEquals((String)"-class", (String)arguments[0]);
        CommandLineTest.assertEquals((String)"foo.bar.Main", (String)arguments[1]);
        CommandLineTest.assertEquals((String)"\"C:\\Document And Settings\\documents\\432431.pdf\"", (String)arguments[2]);
        substitutionMap.put("file", "C:\\Document And Settings\\documents\\432432.pdf");
        result = cmdl.toStrings();
        CommandLineTest.assertEquals((String)StringUtils.fixFileSeparatorChar((String)"C:\\Programme\\jdk1.5.0_12\\bin\\java"), (String)result[0]);
        CommandLineTest.assertEquals((String)"-class", (String)result[1]);
        CommandLineTest.assertEquals((String)"foo.bar.Main", (String)result[2]);
        CommandLineTest.assertEquals((String)"\"C:\\Document And Settings\\documents\\432432.pdf\"", (String)result[3]);
    }

    public void testCommandLineParsingWithExpansion3() {
        CommandLine cmdl = CommandLine.parse((String)"AcroRd32.exe");
        cmdl.addArgument("/p");
        cmdl.addArgument("/h");
        cmdl.addArgument("${file}", false);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file", "C:\\Document And Settings\\documents\\432432.pdf");
        cmdl.setSubstitutionMap(params);
        String[] result = cmdl.toStrings();
        CommandLineTest.assertEquals((String)"AcroRd32.exe", (String)result[0]);
        CommandLineTest.assertEquals((String)"/p", (String)result[1]);
        CommandLineTest.assertEquals((String)"/h", (String)result[2]);
        CommandLineTest.assertEquals((String)"C:\\Document And Settings\\documents\\432432.pdf", (String)result[3]);
    }

    public void testToString() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        CommandLine cmdl = CommandLine.parse((String)"AcroRd32.exe", params);
        CommandLineTest.assertEquals((String)"[AcroRd32.exe]", (String)cmdl.toString());
        params.put("file", "C:\\Document And Settings\\documents\\432432.pdf");
        cmdl = CommandLine.parse((String)"AcroRd32.exe /p /h '${file}'", params);
        CommandLineTest.assertEquals((String)"[AcroRd32.exe, /p, /h, \"C:\\Document And Settings\\documents\\432432.pdf\"]", (String)cmdl.toString());
        params.put("file", "C:\\documents\\432432.pdf");
        cmdl = CommandLine.parse((String)"AcroRd32.exe /p /h '${file}'", params);
        CommandLineTest.assertEquals((String)"[AcroRd32.exe, /p, /h, C:\\documents\\432432.pdf]", (String)cmdl.toString());
    }

    public void testToStringTroubleshooting() throws Exception {
        System.out.println("testToStringTroubleshooting");
        CommandLine cmd1 = new CommandLine("sh").addArgument("-c").addArgument("echo 1", false);
        CommandLine cmd2 = new CommandLine("sh").addArgument("-c").addArgument("echo").addArgument("1");
        System.out.println("cmd1: " + cmd1.toString());
        System.out.println("cmd2: " + cmd2.toString());
        CommandLineTest.assertTrue((String)"toString() is useful for troubleshooting", (!cmd1.toString().equals(cmd2.toString()) ? 1 : 0) != 0);
    }

    public void _testExec36_1() throws Exception {
        String line = "./script/jrake cruise:publish_installers INSTALLER_VERSION=unstable_2_1 INSTALLER_PATH=\"/var/lib/cruise-agent/installers\" INSTALLER_DOWNLOAD_SERVER='something'WITHOUT_HELP_DOC=true";
        CommandLine cmdl = CommandLine.parse((String)"./script/jrake cruise:publish_installers INSTALLER_VERSION=unstable_2_1 INSTALLER_PATH=\"/var/lib/cruise-agent/installers\" INSTALLER_DOWNLOAD_SERVER='something'WITHOUT_HELP_DOC=true");
        String[] args = cmdl.toStrings();
        CommandLineTest.assertEquals((String)"./script/jrake", (String)args[0]);
        CommandLineTest.assertEquals((String)"cruise:publish_installers", (String)args[1]);
        CommandLineTest.assertEquals((String)"INSTALLER_VERSION=unstable_2_1", (String)args[2]);
        CommandLineTest.assertEquals((String)"INSTALLER_PATH=\"/var/lib/cruise-agent/installers\"", (String)args[3]);
        CommandLineTest.assertEquals((String)"INSTALLER_DOWNLOAD_SERVER='something'", (String)args[4]);
        CommandLineTest.assertEquals((String)"WITHOUT_HELP_DOC=true", (String)args[5]);
    }

    public void _testExec36_2() {
        String line = "dotnetfx.exe /q:a /c:\"install.exe /l \"\"c:\\Documents and Settings\\myusername\\Local Settings\\Temp\\netfx.log\"\" /q\"";
        CommandLine cmdl = CommandLine.parse((String)"dotnetfx.exe /q:a /c:\"install.exe /l \"\"c:\\Documents and Settings\\myusername\\Local Settings\\Temp\\netfx.log\"\" /q\"");
        String[] args = cmdl.toStrings();
        CommandLineTest.assertEquals((String)"dotnetfx.exe", (String)args[0]);
        CommandLineTest.assertEquals((String)"/q:a", (String)args[1]);
        CommandLineTest.assertEquals((String)"/c:\"install.exe /l \"\"c:\\Documents and Settings\\myusername\\Local Settings\\Temp\\netfx.log\"\" /q\"", (String)args[2]);
    }

    public void _testExec36_3() {
        String commandline = "C:\\CVS_DB\\WeightsEngine /f WeightsEngine.mak CFG=\"WeightsEngine - Win32Release\"";
        CommandLine cmdl = CommandLine.parse((String)"C:\\CVS_DB\\WeightsEngine /f WeightsEngine.mak CFG=\"WeightsEngine - Win32Release\"");
        String[] args = cmdl.getArguments();
        CommandLineTest.assertEquals((String)"/f", (String)args[0]);
        CommandLineTest.assertEquals((String)"WeightsEngine.mak", (String)args[1]);
        CommandLineTest.assertEquals((String)"CFG=\"WeightsEngine - Win32Release\"", (String)args[2]);
    }

    public void testCopyConstructor() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bar", "bar");
        CommandLine other = new CommandLine("test");
        other.addArgument("foo");
        other.setSubstitutionMap(map);
        CommandLine cmdl = new CommandLine(other);
        CommandLineTest.assertEquals((String)other.getExecutable(), (String)cmdl.getExecutable());
        this.assertEquals(other.getArguments(), cmdl.getArguments());
        CommandLineTest.assertEquals((boolean)other.isFile(), (boolean)cmdl.isFile());
        CommandLineTest.assertEquals((Object)other.getSubstitutionMap(), (Object)cmdl.getSubstitutionMap());
    }
}

