/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.exec.TestUtil;
import org.apache.commons.exec.environment.EnvironmentUtils;

public class DefaultExecutorTest
extends TestCase {
    private static final int WAITFOR_TIMEOUT = 15000;
    private final Executor exec = new DefaultExecutor();
    private final File testDir = new File("src/test/scripts");
    private final File foreverOutputFile = new File("./target/forever.txt");
    private ByteArrayOutputStream baos;
    private final File testScript = TestUtil.resolveScriptForOS(this.testDir + "/test");
    private final File errorTestScript = TestUtil.resolveScriptForOS(this.testDir + "/error");
    private final File foreverTestScript = TestUtil.resolveScriptForOS(this.testDir + "/forever");
    private final File nonExistingTestScript = TestUtil.resolveScriptForOS(this.testDir + "/grmpffffff");
    private final File redirectScript = TestUtil.resolveScriptForOS(this.testDir + "/redirect");
    private final File pingScript = TestUtil.resolveScriptForOS(this.testDir + "/ping");
    private final File printArgsScript = TestUtil.resolveScriptForOS(this.testDir + "/printargs");
    private final File stdinSript = TestUtil.resolveScriptForOS(this.testDir + "/stdin");
    private final File environmentSript = TestUtil.resolveScriptForOS(this.testDir + "/environment");
    private static final int SUCCESS_STATUS;
    private static final int ERROR_STATUS;

    protected void setUp() throws Exception {
        this.foreverOutputFile.getParentFile().mkdirs();
        if (this.foreverOutputFile.exists()) {
            this.foreverOutputFile.delete();
        }
        this.baos = new ByteArrayOutputStream();
        this.exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)this.baos, (OutputStream)this.baos));
    }

    protected void tearDown() throws Exception {
        this.baos.close();
        this.foreverOutputFile.delete();
    }

    public void testExecute() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        int exitValue = this.exec.execute(cl);
        DefaultExecutorTest.assertEquals((String)"FOO..", (String)this.baos.toString().trim());
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
        DefaultExecutorTest.assertEquals((Object)new File("."), (Object)this.exec.getWorkingDirectory());
    }

    public void testExecuteWithWorkingDirectory() throws Exception {
        File workingDir = new File("./target");
        CommandLine cl = new CommandLine(this.testScript);
        this.exec.setWorkingDirectory(workingDir);
        int exitValue = this.exec.execute(cl);
        DefaultExecutorTest.assertEquals((String)"FOO..", (String)this.baos.toString().trim());
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
        DefaultExecutorTest.assertEquals((Object)this.exec.getWorkingDirectory(), (Object)workingDir);
    }

    public void testExecuteWithInvalidWorkingDirectory() throws Exception {
        File workingDir = new File("/foo/bar");
        CommandLine cl = new CommandLine(this.testScript);
        this.exec.setWorkingDirectory(workingDir);
        try {
            this.exec.execute(cl);
            DefaultExecutorTest.fail((String)"Expected exception due to invalid working directory");
        }
        catch (IOException e) {
            return;
        }
    }

    public void testExecuteWithError() throws Exception {
        CommandLine cl = new CommandLine(this.errorTestScript);
        try {
            this.exec.execute(cl);
            DefaultExecutorTest.fail((String)"Must throw ExecuteException");
        }
        catch (ExecuteException e) {
            DefaultExecutorTest.assertTrue((boolean)this.exec.isFailure(e.getExitValue()));
        }
    }

    public void testExecuteWithArg() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        cl.addArgument("BAR");
        int exitValue = this.exec.execute(cl);
        DefaultExecutorTest.assertEquals((String)"FOO..BAR", (String)this.baos.toString().trim());
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    public void testExecuteWithSingleEnvironmentVariable() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("TEST_ENV_VAR", "XYZ");
        CommandLine cl = new CommandLine(this.testScript);
        int exitValue = this.exec.execute(cl, env);
        DefaultExecutorTest.assertEquals((String)"FOO.XYZ.", (String)this.baos.toString().trim());
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    public void testExecuteAsync() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor(2000L);
        DefaultExecutorTest.assertTrue((boolean)resultHandler.hasResult());
        DefaultExecutorTest.assertNull((Object)((Object)resultHandler.getException()));
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(resultHandler.getExitValue()));
        DefaultExecutorTest.assertEquals((String)"FOO..", (String)this.baos.toString().trim());
    }

    public void testExecuteAsyncWithError() throws Exception {
        CommandLine cl = new CommandLine(this.errorTestScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor(2000L);
        DefaultExecutorTest.assertTrue((boolean)resultHandler.hasResult());
        DefaultExecutorTest.assertTrue((boolean)this.exec.isFailure(resultHandler.getExitValue()));
        DefaultExecutorTest.assertNotNull((Object)((Object)resultHandler.getException()));
        DefaultExecutorTest.assertEquals((String)"FOO..", (String)this.baos.toString().trim());
    }

    public void testExecuteAsyncWithTimelyUserTermination() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Integer.MAX_VALUE);
        this.exec.setWatchdog(watchdog);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(2000L);
        DefaultExecutorTest.assertTrue((String)"Watchdog should watch the process", (boolean)watchdog.isWatching());
        watchdog.destroyProcess();
        handler.waitFor(15000L);
        DefaultExecutorTest.assertTrue((String)"Watchdog should have killed the process", (boolean)watchdog.killedProcess());
        DefaultExecutorTest.assertFalse((String)"Watchdog is no longer watching the process", (boolean)watchdog.isWatching());
        DefaultExecutorTest.assertTrue((String)"ResultHandler received a result", (boolean)handler.hasResult());
        DefaultExecutorTest.assertNotNull((String)"ResultHandler received an exception as result", (Object)((Object)handler.getException()));
    }

    public void testExecuteAsyncWithTooLateUserTermination() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(3000L);
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(6000L);
        watchdog.destroyProcess();
        handler.waitFor(15000L);
        DefaultExecutorTest.assertTrue((String)"Watchdog should have killed the process already", (boolean)watchdog.killedProcess());
        DefaultExecutorTest.assertFalse((String)"Watchdog is no longer watching the process", (boolean)watchdog.isWatching());
        DefaultExecutorTest.assertTrue((String)"ResultHandler received a result", (boolean)handler.hasResult());
        DefaultExecutorTest.assertNotNull((String)"ResultHandler received an exception as result", (Object)((Object)handler.getException()));
    }

    public void testExecuteWatchdogSync() throws Exception {
        if (OS.isFamilyOpenVms()) {
            System.out.println("The test 'testExecuteWatchdogSync' currently hangs on the following OS : " + System.getProperty("os.name"));
            return;
        }
        long timeout = 10000L;
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File("."));
        ExecuteWatchdog watchdog = new ExecuteWatchdog(10000L);
        executor.setWatchdog(watchdog);
        try {
            executor.execute(cl);
        }
        catch (ExecuteException e) {
            Thread.sleep(10000L);
            int nrOfInvocations = this.getOccurrences(this.readFile(this.foreverOutputFile), '.');
            DefaultExecutorTest.assertTrue((boolean)executor.getWatchdog().killedProcess());
            DefaultExecutorTest.assertTrue((String)("killing the subprocess did not work : " + nrOfInvocations), (nrOfInvocations > 5 && nrOfInvocations <= 11 ? 1 : 0) != 0);
            return;
        }
        catch (Throwable t) {
            DefaultExecutorTest.fail((String)t.getMessage());
        }
        DefaultExecutorTest.assertTrue((String)"Killed process should be true", (boolean)executor.getWatchdog().killedProcess());
        DefaultExecutorTest.fail((String)"Process did not create ExecuteException when killed");
    }

    public void testExecuteWatchdogAsync() throws Exception {
        long timeout = 10000L;
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File("."));
        executor.setWatchdog(new ExecuteWatchdog(10000L));
        executor.execute(cl, (ExecuteResultHandler)handler);
        handler.waitFor(15000L);
        DefaultExecutorTest.assertTrue((String)"Killed process should be true", (boolean)executor.getWatchdog().killedProcess());
        DefaultExecutorTest.assertTrue((String)"ResultHandler received a result", (boolean)handler.hasResult());
        DefaultExecutorTest.assertNotNull((String)"ResultHandler received an exception as result", (Object)((Object)handler.getException()));
        int nrOfInvocations = this.getOccurrences(this.readFile(this.foreverOutputFile), '.');
        DefaultExecutorTest.assertTrue((String)("Killing the process did not work : " + nrOfInvocations), (nrOfInvocations > 5 && nrOfInvocations <= 11 ? 1 : 0) != 0);
    }

    public void testExecuteWatchdogVeryLongTimeout() throws Exception {
        long timeout = Long.MAX_VALUE;
        CommandLine cl = new CommandLine(this.testScript);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File("."));
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Long.MAX_VALUE);
        executor.setWatchdog(watchdog);
        try {
            executor.execute(cl);
        }
        catch (ExecuteException e) {
            DefaultExecutorTest.assertFalse((String)"Process should exit normally, not be killed by watchdog", (boolean)watchdog.killedProcess());
            throw e;
        }
    }

    public void testExecuteNonExistingApplication() throws Exception {
        CommandLine cl = new CommandLine(this.nonExistingTestScript);
        DefaultExecutor executor = new DefaultExecutor();
        try {
            executor.execute(cl);
        }
        catch (IOException e) {
            return;
        }
        DefaultExecutorTest.fail((String)"Got no exception when executing an non-existing application");
    }

    public void testExecuteAsyncWithNonExistingApplication() throws Exception {
        CommandLine cl = new CommandLine(this.nonExistingTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(2000L);
        DefaultExecutorTest.assertNotNull((Object)((Object)handler.getException()));
        DefaultExecutorTest.assertTrue((boolean)this.exec.isFailure(handler.getExitValue()));
    }

    public void testExecuteWithCustomExitValue1() throws Exception {
        this.exec.setExitValue(ERROR_STATUS);
        CommandLine cl = new CommandLine(this.errorTestScript);
        this.exec.execute(cl);
    }

    public void testExecuteWithCustomExitValue2() throws Exception {
        CommandLine cl = new CommandLine(this.errorTestScript);
        this.exec.setExitValue(SUCCESS_STATUS);
        try {
            this.exec.execute(cl);
            DefaultExecutorTest.fail((String)"Must throw ExecuteException");
        }
        catch (ExecuteException e) {
            DefaultExecutorTest.assertTrue((boolean)this.exec.isFailure(e.getExitValue()));
            return;
        }
    }

    public void testExecuteWithProcessDestroyer() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        ShutdownHookProcessDestroyer processDestroyer = new ShutdownHookProcessDestroyer();
        this.exec.setProcessDestroyer((ProcessDestroyer)processDestroyer);
        DefaultExecutorTest.assertTrue((processDestroyer.size() == 0 ? 1 : 0) != 0);
        DefaultExecutorTest.assertTrue((!processDestroyer.isAddedAsShutdownHook() ? 1 : 0) != 0);
        int exitValue = this.exec.execute(cl);
        DefaultExecutorTest.assertEquals((String)"FOO..", (String)this.baos.toString().trim());
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
        DefaultExecutorTest.assertTrue((processDestroyer.size() == 0 ? 1 : 0) != 0);
        DefaultExecutorTest.assertTrue((!processDestroyer.isAddedAsShutdownHook() ? 1 : 0) != 0);
    }

    public void testExecuteAsyncWithProcessDestroyer() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        ShutdownHookProcessDestroyer processDestroyer = new ShutdownHookProcessDestroyer();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Integer.MAX_VALUE);
        DefaultExecutorTest.assertTrue((this.exec.getProcessDestroyer() == null ? 1 : 0) != 0);
        DefaultExecutorTest.assertTrue((processDestroyer.size() == 0 ? 1 : 0) != 0);
        DefaultExecutorTest.assertTrue((!processDestroyer.isAddedAsShutdownHook() ? 1 : 0) != 0);
        this.exec.setWatchdog(watchdog);
        this.exec.setProcessDestroyer((ProcessDestroyer)processDestroyer);
        this.exec.execute(cl, (ExecuteResultHandler)handler);
        Thread.sleep(2000L);
        DefaultExecutorTest.assertNotNull((String)"Process destroyer should exist", (Object)this.exec.getProcessDestroyer());
        DefaultExecutorTest.assertEquals((String)"Process destroyer size should be 1", (int)1, (int)processDestroyer.size());
        DefaultExecutorTest.assertTrue((String)"Process destroyer should exist as shutdown hook", (boolean)processDestroyer.isAddedAsShutdownHook());
        watchdog.destroyProcess();
        DefaultExecutorTest.assertTrue((boolean)watchdog.killedProcess());
        handler.waitFor(15000L);
        DefaultExecutorTest.assertTrue((String)"ResultHandler received a result", (boolean)handler.hasResult());
        DefaultExecutorTest.assertNotNull((Object)((Object)handler.getException()));
        DefaultExecutorTest.assertEquals((String)"Processor Destroyer size should be 0", (int)0, (int)processDestroyer.size());
        DefaultExecutorTest.assertFalse((String)"Process destroyer should not exist as shutdown hook", (boolean)processDestroyer.isAddedAsShutdownHook());
    }

    public void testExecuteWithFancyArg() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        cl.addArgument("test $;`(0)[1]{2}");
        int exitValue = this.exec.execute(cl);
        DefaultExecutorTest.assertTrue((this.baos.toString().trim().indexOf("test $;`(0)[1]{2}") > 0 ? 1 : 0) != 0);
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    public void testExecuteWithRedirectedStreams() throws Exception {
        if (!OS.isFamilyUnix()) {
            if (OS.isFamilyWindows()) {
                System.err.println("The code samples to do that in windows look like a joke ... :-( .., no way I'm doing that");
                System.err.println("The test 'testExecuteWithRedirectedStreams' does not support the following OS : " + System.getProperty("os.name"));
                return;
            }
            System.err.println("The test 'testExecuteWithRedirectedStreams' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        FileInputStream fis = new FileInputStream("./NOTICE.txt");
        CommandLine cl = new CommandLine(this.redirectScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)this.baos, (OutputStream)this.baos, (InputStream)fis);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File("."));
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        fis.close();
        String result = this.baos.toString().trim();
        DefaultExecutorTest.assertTrue((String)result, (result.indexOf("Finished reading from stdin") > 0 ? 1 : 0) != 0);
        DefaultExecutorTest.assertFalse((String)("exitValue=" + exitValue), (boolean)this.exec.isFailure(exitValue));
    }

    public void testExecuteWithStdOutErr() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    public void testExecuteWithNullOutErr() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(null, null);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    public void testExecuteWithRedirectOutErr() throws Exception {
        File outfile = File.createTempFile("EXEC", ".test");
        outfile.deleteOnExit();
        CommandLine cl = new CommandLine(this.testScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)new FileOutputStream(outfile));
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
        DefaultExecutorTest.assertTrue((boolean)outfile.exists());
    }

    public void testExecuteWithComplexArguments() throws Exception {
        CommandLine cl = new CommandLine(this.printArgsScript);
        cl.addArgument("gdal_translate");
        cl.addArgument("HDF5:\"/home/kk/grass/data/4404.he5\"://HDFEOS/GRIDS/OMI_Column_Amount_O3/Data_Fields/ColumnAmountO3/home/kk/4.tif", false);
        DefaultExecutor executor = new DefaultExecutor();
        int exitValue = executor.execute(cl);
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    public void testStdInHandling() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream("Foo".getBytes());
        CommandLine cl = new CommandLine(this.stdinSript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)this.baos, (OutputStream)System.err, (InputStream)bais);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        executor.execute(cl, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor(15000L);
        DefaultExecutorTest.assertTrue((String)"ResultHandler received a result", (boolean)resultHandler.hasResult());
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(resultHandler.getExitValue()));
        String result = this.baos.toString();
        DefaultExecutorTest.assertTrue((String)("Result '" + result + "' should contain 'Hello Foo!'"), (result.indexOf("Hello Foo!") >= 0 ? 1 : 0) != 0);
    }

    public void testEnvironmentVariables() throws Exception {
        this.exec.execute(new CommandLine(this.environmentSript));
        String environment = this.baos.toString().trim();
        DefaultExecutorTest.assertTrue((String)"Found no environment variables", (environment.length() > 0 ? 1 : 0) != 0);
        DefaultExecutorTest.assertFalse((environment.indexOf("NEW_VAR") >= 0 ? 1 : 0) != 0);
    }

    public void testAddEnvironmentVariables() throws Exception {
        HashMap<String, String> myEnvVars = new HashMap<String, String>();
        myEnvVars.putAll(EnvironmentUtils.getProcEnvironment());
        myEnvVars.put("NEW_VAR", "NEW_VAL");
        this.exec.execute(new CommandLine(this.environmentSript), myEnvVars);
        String environment = this.baos.toString().trim();
        DefaultExecutorTest.assertTrue((String)("Expecting NEW_VAR in " + environment), (environment.indexOf("NEW_VAR") >= 0 ? 1 : 0) != 0);
        DefaultExecutorTest.assertTrue((String)("Expecting NEW_VAL in " + environment), (environment.indexOf("NEW_VAL") >= 0 ? 1 : 0) != 0);
    }

    public void testAddEnvironmentVariableEmbeddedQuote() throws Exception {
        HashMap<String, String> myEnvVars = new HashMap<String, String>();
        myEnvVars.putAll(EnvironmentUtils.getProcEnvironment());
        String name = "NEW_VAR";
        String value = "NEW_\"_VAL";
        myEnvVars.put("NEW_VAR", "NEW_\"_VAL");
        this.exec.execute(new CommandLine(this.environmentSript), myEnvVars);
        String environment = this.baos.toString().trim();
        DefaultExecutorTest.assertTrue((String)("Expecting NEW_VAR in " + environment), (environment.indexOf("NEW_VAR") >= 0 ? 1 : 0) != 0);
        DefaultExecutorTest.assertTrue((String)("Expecting NEW_\"_VAL in " + environment), (environment.indexOf("NEW_\"_VAL") >= 0 ? 1 : 0) != 0);
    }

    public void testExec33() throws Exception {
        CommandLine cl = new CommandLine(this.testScript);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        int exitValue = executor.execute(cl);
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    public void testExec34_1() throws Exception {
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument("10");
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Integer.MAX_VALUE);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cmdLine, (ExecuteResultHandler)handler);
        DefaultExecutorTest.assertTrue((boolean)watchdog.isWatching());
        watchdog.destroyProcess();
        DefaultExecutorTest.assertTrue((String)"Watchdog should have killed the process", (boolean)watchdog.killedProcess());
        DefaultExecutorTest.assertFalse((String)"Watchdog is no longer watching the process", (boolean)watchdog.isWatching());
    }

    public void testExec34_2() throws Exception {
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument("10");
        ExecuteWatchdog watchdog = new ExecuteWatchdog(5000L);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cmdLine, (ExecuteResultHandler)handler);
        handler.waitFor();
        DefaultExecutorTest.assertTrue((String)"Process has exited", (boolean)handler.hasResult());
        DefaultExecutorTest.assertNotNull((String)"Process was aborted", (Object)((Object)handler.getException()));
        DefaultExecutorTest.assertTrue((String)"Watchdog should have killed the process", (boolean)watchdog.killedProcess());
        DefaultExecutorTest.assertFalse((String)"Watchdog is no longer watching the process", (boolean)watchdog.isWatching());
    }

    public void testExec36_1() throws Exception {
        if (!OS.isFamilyUnix()) {
            System.err.println("The test 'testExec36_1' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        String expected = "./script/jrake\ncruise:publish_installers\nINSTALLER_VERSION=unstable_2_1\nINSTALLER_PATH=\"/var/lib/ cruise-agent/installers\"\nINSTALLER_DOWNLOAD_SERVER='something'\nWITHOUT_HELP_DOC=true";
        CommandLine cmdl = new CommandLine(this.printArgsScript);
        cmdl.addArgument("./script/jrake", false);
        cmdl.addArgument("cruise:publish_installers", false);
        cmdl.addArgument("INSTALLER_VERSION=unstable_2_1", false);
        cmdl.addArgument("INSTALLER_PATH=\"/var/lib/ cruise-agent/installers\"", false);
        cmdl.addArgument("INSTALLER_DOWNLOAD_SERVER='something'", false);
        cmdl.addArgument("WITHOUT_HELP_DOC=true", false);
        int exitValue = this.exec.execute(cmdl);
        String result = this.baos.toString().trim();
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
        DefaultExecutorTest.assertEquals((String)"./script/jrake\ncruise:publish_installers\nINSTALLER_VERSION=unstable_2_1\nINSTALLER_PATH=\"/var/lib/ cruise-agent/installers\"\nINSTALLER_DOWNLOAD_SERVER='something'\nWITHOUT_HELP_DOC=true", (String)result);
    }

    public void testExec36_2() throws Exception {
        String expected;
        if (OS.isFamilyWindows()) {
            expected = "dotnetfx.exe\n/q:a\n/c:\"install.exe /l \"\"\\Documents and Settings\\myusername\\Local Settings\\Temp\\netfx.log\"\" /q\"";
        } else if (OS.isFamilyUnix()) {
            expected = "dotnetfx.exe\n/q:a\n/c:\"install.exe /l \"\"/Documents and Settings/myusername/Local Settings/Temp/netfx.log\"\" /q\"";
        } else {
            System.err.println("The test 'testExec36_3' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        File file = new File("/Documents and Settings/myusername/Local Settings/Temp/netfx.log");
        HashMap<String, File> map = new HashMap<String, File>();
        map.put("FILE", file);
        CommandLine cmdl = new CommandLine(this.printArgsScript);
        cmdl.setSubstitutionMap(map);
        cmdl.addArgument("dotnetfx.exe", false);
        cmdl.addArgument("/q:a", false);
        cmdl.addArgument("/c:\"install.exe /l \"\"${FILE}\"\" /q\"", false);
        int exitValue = this.exec.execute(cmdl);
        String result = this.baos.toString().trim();
        DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
        if (OS.isFamilyUnix()) {
            DefaultExecutorTest.assertEquals((String)expected, (String)result);
        }
    }

    public void testExec41WithStreams() throws Exception {
        CommandLine cmdLine;
        if (OS.isFamilyWindows()) {
            cmdLine = CommandLine.parse((String)"ping.exe -n 10 -w 1000 127.0.0.1");
        } else if ("HP-UX".equals(System.getProperty("os.name"))) {
            cmdLine = CommandLine.parse((String)"ping 127.0.0.1 -n 10");
        } else if (OS.isFamilyUnix()) {
            cmdLine = CommandLine.parse((String)"ping -c 10 127.0.0.1");
        } else {
            System.err.println("The test 'testExec41WithStreams' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(2000L);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err);
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        long startTime = System.currentTimeMillis();
        try {
            executor.execute(cmdLine);
        }
        catch (ExecuteException e) {
            // empty catch block
        }
        long duration = System.currentTimeMillis() - startTime;
        System.out.println("Process completed in " + duration + " millis; below is its output");
        if (watchdog.killedProcess()) {
            System.out.println("Process timed out and was killed by watchdog.");
        }
        DefaultExecutorTest.assertTrue((String)"The process was killed by the watchdog", (boolean)watchdog.killedProcess());
        DefaultExecutorTest.assertTrue((String)"Skipping the Thread.join() did not work", (duration < 9000L ? 1 : 0) != 0);
    }

    public void testExec41WithoutStreams() throws Exception {
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument("10");
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(2000L);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(null, null, null);
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        long startTime = System.currentTimeMillis();
        try {
            executor.execute(cmdLine);
        }
        catch (ExecuteException e) {
            System.out.println((Object)e);
        }
        long duration = System.currentTimeMillis() - startTime;
        System.out.println("Process completed in " + duration + " millis; below is its output");
        if (watchdog.killedProcess()) {
            System.out.println("Process timed out and was killed.");
        }
        DefaultExecutorTest.assertTrue((String)"The process was killed by the watchdog", (boolean)watchdog.killedProcess());
        DefaultExecutorTest.assertTrue((String)("Skipping the Thread.join() did not work, duration=" + duration), (duration < 9000L ? 1 : 0) != 0);
    }

    public void testExec44() throws Exception {
        CommandLine cl = new CommandLine(this.foreverTestScript);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(-1L);
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cl, (ExecuteResultHandler)resultHandler);
        Thread.sleep(5000L);
        DefaultExecutorTest.assertTrue((String)"The watchdog is watching the process", (boolean)watchdog.isWatching());
        watchdog.destroyProcess();
        DefaultExecutorTest.assertTrue((String)"The watchdog has killed the process", (boolean)watchdog.killedProcess());
        DefaultExecutorTest.assertFalse((String)"The watchdog is no longer watching any process", (boolean)watchdog.isWatching());
    }

    public void testExec49_1() throws Exception {
        if (OS.isFamilyUnix()) {
            int x;
            CommandLine cl = CommandLine.parse((String)"/bin/ls");
            cl.addArgument("/opt");
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PumpStreamHandler psh = new PumpStreamHandler((OutputStream)pipedOutputStream);
            this.exec.setStreamHandler((ExecuteStreamHandler)psh);
            System.out.println("Preparing to execute process - commandLine=" + cl.toString());
            DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
            this.exec.execute(cl, (ExecuteResultHandler)handler);
            System.out.println("Process spun off successfully - process=" + cl.getExecutable());
            PipedInputStream pis = new PipedInputStream(pipedOutputStream);
            while ((x = pis.read()) >= 0) {
            }
            pis.close();
            handler.waitFor();
        }
    }

    public void testExec49_2() throws Exception {
        if (OS.isFamilyUnix()) {
            int x;
            CommandLine cl = CommandLine.parse((String)"/bin/ls");
            cl.addArgument("/opt");
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PumpStreamHandler psh = new PumpStreamHandler((OutputStream)pipedOutputStream, (OutputStream)new ByteArrayOutputStream());
            this.exec.setStreamHandler((ExecuteStreamHandler)psh);
            System.out.println("Preparing to execute process - commandLine=" + cl.toString());
            DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
            this.exec.execute(cl, (ExecuteResultHandler)handler);
            System.out.println("Process spun off successfully - process=" + cl.getExecutable());
            PipedInputStream pis = new PipedInputStream(pipedOutputStream);
            while ((x = pis.read()) >= 0) {
            }
            pis.close();
            handler.waitFor();
        }
    }

    public void testExec_57() throws IOException {
        if (!OS.isFamilyUnix()) {
            System.err.println("The test 'testSyncInvocationOfBackgroundProcess' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        CommandLine cmdLine = new CommandLine("sh").addArgument("-c").addArgument(this.testDir + "/invoker.sh", false);
        DefaultExecutor executor = new DefaultExecutor();
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err);
        pumpStreamHandler.setStopTimeout(2000L);
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        long startTime = System.currentTimeMillis();
        System.out.println("Executing " + cmdLine);
        try {
            executor.execute(cmdLine);
        }
        catch (ExecuteException e) {
            long duration = System.currentTimeMillis() - startTime;
            System.out.println("Process completed in " + duration + " millis; above is its output");
            return;
        }
        DefaultExecutorTest.fail((String)"Expecting an ExecuteException");
    }

    public void testExec_60() throws Exception {
        boolean start = false;
        boolean seconds = true;
        boolean offsetMultiplier = true;
        int maxRetries = 180;
        int processTerminatedCounter = 0;
        int watchdogKilledProcessCounter = 0;
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument(Integer.toString(2));
        long startTime = System.currentTimeMillis();
        for (int offset = 0; offset <= 180; ++offset) {
            ExecuteWatchdog watchdog = new ExecuteWatchdog((long)(1000 + offset * 1));
            this.exec.setWatchdog(watchdog);
            try {
                this.exec.execute(cmdLine);
                if (++processTerminatedCounter <= 5) continue;
                break;
            }
            catch (ExecuteException ex) {
                DefaultExecutorTest.assertTrue((String)"Watchdog killed the process", (boolean)watchdog.killedProcess());
                ++watchdogKilledProcessCounter;
            }
        }
        long avg = (System.currentTimeMillis() - startTime) / (long)(watchdogKilledProcessCounter + processTerminatedCounter);
        System.out.println("Processes terminated: " + processTerminatedCounter + " killed: " + watchdogKilledProcessCounter + " Multiplier: " + 1 + " MaxRetries: " + 180 + " Elapsed (avg ms): " + avg);
        DefaultExecutorTest.assertTrue((String)"Not a single process terminated on its own", (processTerminatedCounter > 0 ? 1 : 0) != 0);
        DefaultExecutorTest.assertTrue((String)"Not a single process was killed by the watch dog", (watchdogKilledProcessCounter > 0 ? 1 : 0) != 0);
    }

    public void _testExecuteStability() throws Exception {
        HashMap<String, Integer> env;
        int i;
        for (i = 0; i < 100; ++i) {
            env = new HashMap<String, Integer>();
            env.put("TEST_ENV_VAR", new Integer(i));
            CommandLine cl = new CommandLine(this.testScript);
            int exitValue = this.exec.execute(cl, env);
            DefaultExecutorTest.assertFalse((boolean)this.exec.isFailure(exitValue));
            DefaultExecutorTest.assertEquals((String)("FOO." + i + "."), (String)this.baos.toString().trim());
            this.baos.reset();
        }
        for (i = 0; i < 100; ++i) {
            env = new HashMap();
            env.put("TEST_ENV_VAR", new Integer(i));
            DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
            CommandLine cl = new CommandLine(this.foreverTestScript);
            ExecuteWatchdog watchdog = new ExecuteWatchdog(500L);
            this.exec.setWatchdog(watchdog);
            this.exec.execute(cl, env, (ExecuteResultHandler)resultHandler);
            resultHandler.waitFor(15000L);
            DefaultExecutorTest.assertTrue((String)"ResultHandler received a result", (boolean)resultHandler.hasResult());
            DefaultExecutorTest.assertNotNull((Object)((Object)resultHandler.getException()));
            this.baos.reset();
        }
    }

    private String readFile(File file) throws Exception {
        String text;
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((text = reader.readLine()) != null) {
            contents.append(text).append(System.getProperty("line.separator"));
        }
        reader.close();
        return contents.toString();
    }

    private int getOccurrences(String data, char c) {
        int result = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != c) continue;
            ++result;
        }
        return result;
    }

    static {
        int[] statuses = TestUtil.getTestScriptCodesForOS();
        SUCCESS_STATUS = statuses[0];
        ERROR_STATUS = statuses[1];
        System.setProperty("org.apache.commons.exec.lenient", "false");
        System.setProperty("org.apache.commons.exec.debug", "true");
    }
}

