/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.TestUtil;

public class LogOutputStreamTest
extends TestCase {
    private final Executor exec = new DefaultExecutor();
    private final File testDir = new File("src/test/scripts");
    private OutputStream systemOut;
    private final File environmentScript = TestUtil.resolveScriptForOS(this.testDir + "/environment");

    protected void setUp() throws Exception {
        this.systemOut = new SystemLogOutputStream(1);
        this.exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(this.systemOut, this.systemOut));
    }

    protected void tearDown() throws Exception {
        this.systemOut.close();
    }

    public void testStdout() throws Exception {
        CommandLine cl = new CommandLine(this.environmentScript);
        int exitValue = this.exec.execute(cl);
        LogOutputStreamTest.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    static {
        System.setProperty("org.apache.commons.exec.lenient", "false");
        System.setProperty("org.apache.commons.exec.debug", "true");
    }

    private class SystemLogOutputStream
    extends LogOutputStream {
        private SystemLogOutputStream(int level) {
            super(level);
        }

        protected void processLine(String line, int level) {
            System.out.println(line);
        }
    }
}

