/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.exec.util.MapUtils;

public class MapUtilTest
extends TestCase {
    public void testCopyMap() throws Exception {
        HashMap<String, String> procEnvironment = new HashMap<String, String>();
        procEnvironment.put("JAVA_HOME", "/usr/opt/java");
        Map result = MapUtils.copy(procEnvironment);
        MapUtilTest.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        MapUtilTest.assertTrue((procEnvironment.size() == 1 ? 1 : 0) != 0);
        MapUtilTest.assertEquals((Object)"/usr/opt/java", result.get("JAVA_HOME"));
        result.remove("JAVA_HOME");
        MapUtilTest.assertTrue((result.size() == 0 ? 1 : 0) != 0);
        MapUtilTest.assertTrue((procEnvironment.size() == 1 ? 1 : 0) != 0);
    }

    public void testMergeMap() throws Exception {
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        HashMap<String, String> applicationEnvironment = new HashMap<String, String>();
        applicationEnvironment.put("appMainClass", "foo.bar.Main");
        Map result = MapUtils.merge((Map)procEnvironment, applicationEnvironment);
        MapUtilTest.assertTrue((procEnvironment.size() + applicationEnvironment.size() == result.size() ? 1 : 0) != 0);
        MapUtilTest.assertEquals((Object)"foo.bar.Main", result.get("appMainClass"));
    }

    public void testPrefixMap() throws Exception {
        HashMap<String, String> procEnvironment = new HashMap<String, String>();
        procEnvironment.put("JAVA_HOME", "/usr/opt/java");
        Map result = MapUtils.prefix(procEnvironment, (String)"env");
        MapUtilTest.assertTrue((procEnvironment.size() == result.size() ? 1 : 0) != 0);
        MapUtilTest.assertEquals((Object)"/usr/opt/java", result.get("env.JAVA_HOME"));
    }
}

