/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.exec.util.StringUtils;

public class StringUtilTest
extends TestCase {
    public void testNoStringSubstitution() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        vars.put("bar", "BAR");
        StringUtilTest.assertEquals((String)"This is a FOO & BAR test", (String)StringUtils.stringSubstitution((String)"This is a FOO & BAR test", vars, (boolean)true).toString());
    }

    public void testDefaultStringSubstitution() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        vars.put("bar", "BAR");
        StringUtilTest.assertEquals((String)"This is a FOO & BAR test", (String)StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)true).toString());
        StringUtilTest.assertEquals((String)"This is a FOO & BAR test", (String)StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)false).toString());
    }

    public void testIncompleteSubstitution() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        StringUtilTest.assertEquals((String)"This is a FOO & ${bar} test", (String)StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)true).toString());
        try {
            StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)false).toString();
            StringUtilTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testErroneousTemplate() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        StringUtilTest.assertEquals((String)"This is a FOO & ${}} test", (String)StringUtils.stringSubstitution((String)"This is a ${foo} & ${}} test", vars, (boolean)true).toString());
    }
}

