/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class Exec41Test {
    private final File testDir = new File("src/test/scripts");
    private final File pingScript = TestUtil.resolveScriptForOS(this.testDir + "/ping");

    @Test
    public void testExec41WithStreams() throws Exception {
        CommandLine cmdLine;
        if (OS.isFamilyWindows()) {
            cmdLine = CommandLine.parse((String)"ping.exe -n 10 -w 1000 127.0.0.1");
        } else if ("HP-UX".equals(System.getProperty("os.name"))) {
            cmdLine = CommandLine.parse((String)"ping 127.0.0.1 -n 10");
        } else if (OS.isFamilyUnix()) {
            cmdLine = CommandLine.parse((String)"ping -c 10 127.0.0.1");
        } else {
            System.err.println("The test 'testExec41WithStreams' does not support the following OS : " + System.getProperty("os.name"));
            return;
        }
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(2000L);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err);
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        long startTime = System.currentTimeMillis();
        try {
            executor.execute(cmdLine);
        }
        catch (ExecuteException e) {
            // empty catch block
        }
        long duration = System.currentTimeMillis() - startTime;
        System.out.println("Process completed in " + duration + " millis; below is its output");
        if (watchdog.killedProcess()) {
            System.out.println("Process timed out and was killed by watchdog.");
        }
        Assert.assertTrue((String)"The process was killed by the watchdog", (boolean)watchdog.killedProcess());
        Assert.assertTrue((String)"Skipping the Thread.join() did not work", (duration < 9000L ? 1 : 0) != 0);
    }

    @Test
    public void testExec41WithoutStreams() throws Exception {
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument("10");
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(2000L);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(null, null, null);
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        long startTime = System.currentTimeMillis();
        try {
            executor.execute(cmdLine);
        }
        catch (ExecuteException e) {
            System.out.println((Object)e);
        }
        long duration = System.currentTimeMillis() - startTime;
        System.out.println("Process completed in " + duration + " millis; below is its output");
        if (watchdog.killedProcess()) {
            System.out.println("Process timed out and was killed.");
        }
        Assert.assertTrue((String)"The process was killed by the watchdog", (boolean)watchdog.killedProcess());
        Assert.assertTrue((String)("Skipping the Thread.join() did not work, duration=" + duration), (duration < 9000L ? 1 : 0) != 0);
    }
}

