/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommandLineTest {
    @Test
    public void testAddArgument() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("foo");
        cmdl.addArgument("bar");
        Assertions.assertEquals((Object)"[test, foo, bar]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "bar"}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddArguments() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments("foo bar");
        Assertions.assertEquals((Object)"[test, foo, bar]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "bar"}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddArgumentsArray() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments(new String[]{"foo", "bar"});
        Assertions.assertEquals((Object)"[test, foo, bar]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "bar"}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddArgumentsArrayNull() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments((String[])null);
        Assertions.assertEquals((Object)"[test]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test"}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddArgumentsWithQuotes() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments("'foo' \"bar\"");
        Assertions.assertEquals((Object)"[test, foo, bar]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "bar"}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddArgumentsWithQuotesAndSpaces() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArguments("'fo o' \"ba r\"");
        Assertions.assertEquals((Object)"[test, \"fo o\", \"ba r\"]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "\"fo o\"", "\"ba r\""}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddArgumentWithBothQuotes() {
        CommandLine cmdl = new CommandLine("test");
        Assertions.assertThrows(IllegalArgumentException.class, () -> cmdl.addArgument("b\"a'r"));
    }

    @Test
    public void testAddArgumentWithQuote() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("foo");
        cmdl.addArgument("ba\"r");
        Assertions.assertEquals((Object)"[test, foo, 'ba\"r']", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "'ba\"r'"}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddArgumentWithQuotesAround() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("'foo'");
        cmdl.addArgument("\"bar\"");
        cmdl.addArgument("\"fe z\"");
        Assertions.assertEquals((Object)"[test, foo, bar, \"fe z\"]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "bar", "\"fe z\""}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddArgumentWithSingleQuote() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("foo");
        cmdl.addArgument("ba'r");
        Assertions.assertEquals((Object)"[test, foo, \"ba'r\"]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "\"ba'r\""}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddArgumentWithSpace() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument("foo");
        cmdl.addArgument("ba r");
        Assertions.assertEquals((Object)"[test, foo, \"ba r\"]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "\"ba r\""}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddNullArgument() {
        CommandLine cmdl = new CommandLine("test");
        cmdl.addArgument(null);
        Assertions.assertEquals((Object)"[test]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test"}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testAddTwoArguments() {
        CommandLine userAddCL1 = new CommandLine("useradd");
        userAddCL1.addArgument("-g");
        userAddCL1.addArgument("tomcat");
        userAddCL1.addArgument("foo");
        CommandLine userAddCL2 = new CommandLine("useradd");
        userAddCL2.addArgument("-g").addArgument("tomcat");
        userAddCL2.addArgument("foo");
        Assertions.assertEquals((Object)userAddCL1.toString(), (Object)userAddCL2.toString());
    }

    @Test
    public void testCommandLineParsingWithExpansion1() {
        HashMap<String, Object> substitutionMap = new HashMap<String, Object>();
        substitutionMap.put("JAVA_HOME", "/usr/local/java");
        substitutionMap.put("appMainClass", "foo.bar.Main");
        substitutionMap.put("file1", new File("./pom.xml"));
        substitutionMap.put("file2", new File(".\\temp\\READ ME.txt"));
        HashMap<String, String> incompleteMap = new HashMap<String, String>();
        incompleteMap.put("JAVA_HOME", "/usr/local/java");
        CommandLine cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass}");
        Assertions.assertTrue((cmdl.getExecutable().indexOf("${JAVA_HOME}") == 0 ? 1 : 0) != 0);
        Assertions.assertArrayEquals((Object[])new String[]{"${appMainClass}"}, (Object[])cmdl.getArguments());
        cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass}", new HashMap());
        Assertions.assertTrue((cmdl.getExecutable().indexOf("${JAVA_HOME}") == 0 ? 1 : 0) != 0);
        Assertions.assertArrayEquals((Object[])new String[]{"${appMainClass}"}, (Object[])cmdl.getArguments());
        cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass}", substitutionMap);
        Assertions.assertTrue((cmdl.getExecutable().indexOf("${JAVA_HOME}") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((cmdl.getExecutable().indexOf("local") > 0 ? 1 : 0) != 0);
        Assertions.assertArrayEquals((Object[])new String[]{"foo.bar.Main"}, (Object[])cmdl.getArguments());
        cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass}", incompleteMap);
        Assertions.assertTrue((cmdl.getExecutable().indexOf("${JAVA_HOME}") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((cmdl.getExecutable().indexOf("local") > 0 ? 1 : 0) != 0);
        Assertions.assertArrayEquals((Object[])new String[]{"${appMainClass}"}, (Object[])cmdl.getArguments());
        cmdl = CommandLine.parse((String)"${JAVA_HOME}/bin/java ${appMainClass} ${file1} ${file2}", substitutionMap);
        Assertions.assertTrue((cmdl.getExecutable().indexOf("${file}") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCommandLineParsingWithExpansion2() {
        HashMap<String, String> substitutionMap = new HashMap<String, String>();
        substitutionMap.put("JAVA_HOME", "C:\\Programme\\jdk1.5.0_12");
        substitutionMap.put("appMainClass", "foo.bar.Main");
        CommandLine cmdl = new CommandLine("${JAVA_HOME}\\bin\\java");
        cmdl.addArgument("-class");
        cmdl.addArgument("${appMainClass}");
        cmdl.addArgument("${file}");
        substitutionMap.put("file", "C:\\Document And Settings\\documents\\432431.pdf");
        cmdl.setSubstitutionMap(substitutionMap);
        String[] result = cmdl.toStrings();
        Assertions.assertEquals((Object)StringUtils.fixFileSeparatorChar((String)"C:\\Programme\\jdk1.5.0_12\\bin\\java"), (Object)result[0]);
        Assertions.assertEquals((Object)"-class", (Object)result[1]);
        Assertions.assertEquals((Object)"foo.bar.Main", (Object)result[2]);
        Assertions.assertEquals((Object)"\"C:\\Document And Settings\\documents\\432431.pdf\"", (Object)result[3]);
        String executable = cmdl.getExecutable();
        String[] arguments = cmdl.getArguments();
        Assertions.assertEquals((Object)StringUtils.fixFileSeparatorChar((String)"C:\\Programme\\jdk1.5.0_12\\bin\\java"), (Object)executable);
        Assertions.assertEquals((Object)"-class", (Object)arguments[0]);
        Assertions.assertEquals((Object)"foo.bar.Main", (Object)arguments[1]);
        Assertions.assertEquals((Object)"\"C:\\Document And Settings\\documents\\432431.pdf\"", (Object)arguments[2]);
        substitutionMap.put("file", "C:\\Document And Settings\\documents\\432432.pdf");
        result = cmdl.toStrings();
        Assertions.assertEquals((Object)StringUtils.fixFileSeparatorChar((String)"C:\\Programme\\jdk1.5.0_12\\bin\\java"), (Object)result[0]);
        Assertions.assertEquals((Object)"-class", (Object)result[1]);
        Assertions.assertEquals((Object)"foo.bar.Main", (Object)result[2]);
        Assertions.assertEquals((Object)"\"C:\\Document And Settings\\documents\\432432.pdf\"", (Object)result[3]);
    }

    @Test
    public void testCommandLineParsingWithExpansion3() {
        CommandLine cmdl = CommandLine.parse((String)"AcroRd32.exe");
        cmdl.addArgument("/p");
        cmdl.addArgument("/h");
        cmdl.addArgument("${file}", false);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file", "C:\\Document And Settings\\documents\\432432.pdf");
        cmdl.setSubstitutionMap(params);
        String[] result = cmdl.toStrings();
        Assertions.assertEquals((Object)"AcroRd32.exe", (Object)result[0]);
        Assertions.assertEquals((Object)"/p", (Object)result[1]);
        Assertions.assertEquals((Object)"/h", (Object)result[2]);
        Assertions.assertEquals((Object)"C:\\Document And Settings\\documents\\432432.pdf", (Object)result[3]);
    }

    @Test
    public void testComplexAddArgument() {
        CommandLine cmdl = new CommandLine("runMemorySud.cmd");
        cmdl.addArgument("10", false);
        cmdl.addArgument("30", false);
        cmdl.addArgument("-XX:+UseParallelGC", false);
        cmdl.addArgument("\"-XX:ParallelGCThreads=2\"", false);
        Assertions.assertArrayEquals((Object[])new String[]{"runMemorySud.cmd", "10", "30", "-XX:+UseParallelGC", "\"-XX:ParallelGCThreads=2\""}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testComplexAddArguments1() {
        CommandLine cmdl = new CommandLine("runMemorySud.cmd");
        cmdl.addArguments(new String[]{"10", "30", "-XX:+UseParallelGC", "\"-XX:ParallelGCThreads=2\""}, false);
        Assertions.assertArrayEquals((Object[])new String[]{"runMemorySud.cmd", "10", "30", "-XX:+UseParallelGC", "\"-XX:ParallelGCThreads=2\""}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testComplexAddArguments2() {
        CommandLine cmdl = new CommandLine("runMemorySud.cmd");
        cmdl.addArguments("10 30 -XX:+UseParallelGC '\"-XX:ParallelGCThreads=2\"'", false);
        Assertions.assertArrayEquals((Object[])new String[]{"runMemorySud.cmd", "10", "30", "-XX:+UseParallelGC", "\"-XX:ParallelGCThreads=2\""}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testCopyConstructor() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bar", "bar");
        CommandLine other = new CommandLine("test");
        other.addArgument("foo");
        other.setSubstitutionMap(map);
        CommandLine cmdl = new CommandLine(other);
        Assertions.assertEquals((Object)other.getExecutable(), (Object)cmdl.getExecutable());
        Assertions.assertArrayEquals((Object[])other.getArguments(), (Object[])cmdl.getArguments());
        Assertions.assertEquals((Object)other.isFile(), (Object)cmdl.isFile());
        Assertions.assertEquals((Object)other.getSubstitutionMap(), (Object)cmdl.getSubstitutionMap());
    }

    @Test
    public void testExecutable() {
        CommandLine cmdl = new CommandLine("test");
        Assertions.assertEquals((Object)"[test]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test"}, (Object[])cmdl.toStrings());
        Assertions.assertEquals((Object)"test", (Object)cmdl.getExecutable());
        Assertions.assertTrue((cmdl.getArguments().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExecutableWhitespaceString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CommandLine("   "));
    }

    @Test
    public void testExecutableZeroLengthString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CommandLine(""));
    }

    @Test
    public void testNullExecutable() {
        Assertions.assertThrows(NullPointerException.class, () -> new CommandLine((String)null));
    }

    @Test
    public void testParseCommandLine() {
        CommandLine cmdl = CommandLine.parse((String)"test foo bar");
        Assertions.assertEquals((Object)"[test, foo, bar]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "bar"}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testParseCommandLineWithNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandLine.parse(null));
    }

    @Test
    public void testParseCommandLineWithOnlyWhitespace() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandLine.parse((String)"  "));
    }

    @Test
    public void testParseCommandLineWithQuotes() {
        CommandLine cmdl = CommandLine.parse((String)"test \"foo\" 'ba r'");
        Assertions.assertEquals((Object)"[test, foo, \"ba r\"]", (Object)cmdl.toString());
        Assertions.assertArrayEquals((Object[])new String[]{"test", "foo", "\"ba r\""}, (Object[])cmdl.toStrings());
    }

    @Test
    public void testParseCommandLineWithUnevenQuotes() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandLine.parse((String)"test \"foo bar"), (String)"IllegalArgumentException must be thrown due to uneven quotes");
    }

    @Test
    public void testParseComplexCommandLine1() {
        HashMap<String, String> substitutionMap = new HashMap<String, String>();
        substitutionMap.put("in", "source.jpg");
        substitutionMap.put("out", "target.jpg");
        CommandLine cmdl = CommandLine.parse((String)"cmd /C convert ${in} -resize \"'500x> '\" ${out}", substitutionMap);
        Assertions.assertEquals((Object)"[cmd, /C, convert, source.jpg, -resize, \"500x> \", target.jpg]", (Object)cmdl.toString());
    }

    @Test
    public void testParseComplexCommandLine2() {
        String commandline = "./script/jrake cruise:publish_installers INSTALLER_VERSION=unstable_2_1 INSTALLER_PATH=\"/var/lib/ cruise-agent/installers\" INSTALLER_DOWNLOAD_SERVER='something' WITHOUT_HELP_DOC=true";
        CommandLine cmdl = CommandLine.parse((String)"./script/jrake cruise:publish_installers INSTALLER_VERSION=unstable_2_1 INSTALLER_PATH=\"/var/lib/ cruise-agent/installers\" INSTALLER_DOWNLOAD_SERVER='something' WITHOUT_HELP_DOC=true");
        String[] args = cmdl.getArguments();
        Assertions.assertEquals((Object)args[0], (Object)"cruise:publish_installers");
        Assertions.assertEquals((Object)args[1], (Object)"INSTALLER_VERSION=unstable_2_1");
        Assertions.assertEquals((Object)args[4], (Object)"WITHOUT_HELP_DOC=true");
    }

    @Test
    public void testParseRealLifeCommandLine_1() {
        String commandline = "cmd.exe /C \"c:\\was51\\Web Sphere\\AppServer\\bin\\versionInfo.bat\"";
        CommandLine cmdl = CommandLine.parse((String)"cmd.exe /C \"c:\\was51\\Web Sphere\\AppServer\\bin\\versionInfo.bat\"");
        String[] args = cmdl.getArguments();
        Assertions.assertEquals((Object)"/C", (Object)args[0]);
        Assertions.assertEquals((Object)"\"c:\\was51\\Web Sphere\\AppServer\\bin\\versionInfo.bat\"", (Object)args[1]);
    }

    @Test
    public void testToString() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        CommandLine cmdl = CommandLine.parse((String)"AcroRd32.exe", params);
        Assertions.assertEquals((Object)"[AcroRd32.exe]", (Object)cmdl.toString());
        params.put("file", "C:\\Document And Settings\\documents\\432432.pdf");
        cmdl = CommandLine.parse((String)"AcroRd32.exe /p /h '${file}'", params);
        Assertions.assertEquals((Object)"[AcroRd32.exe, /p, /h, \"C:\\Document And Settings\\documents\\432432.pdf\"]", (Object)cmdl.toString());
        params.put("file", "C:\\documents\\432432.pdf");
        cmdl = CommandLine.parse((String)"AcroRd32.exe /p /h '${file}'", params);
        Assertions.assertEquals((Object)"[AcroRd32.exe, /p, /h, C:\\documents\\432432.pdf]", (Object)cmdl.toString());
    }

    @Test
    public void testToStringTroubleshooting() throws Exception {
        System.out.println("testToStringTroubleshooting");
        CommandLine cmd1 = new CommandLine("sh").addArgument("-c").addArgument("echo 1", false);
        CommandLine cmd2 = new CommandLine("sh").addArgument("-c").addArgument("echo").addArgument("1");
        System.out.println("cmd1: " + cmd1.toString());
        System.out.println("cmd2: " + cmd2.toString());
        Assertions.assertTrue((!cmd1.toString().equals(cmd2.toString()) ? 1 : 0) != 0, (String)"toString() is useful for troubleshooting");
    }
}

