/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import org.apache.commons.exec.OS;
import org.junit.jupiter.api.Assertions;

public final class TestUtil {
    public static int[] getTestScriptCodesForOS() {
        if (OS.isFamilyWindows()) {
            return new int[]{0, 1};
        }
        if (OS.isFamilyUnix()) {
            return new int[]{0, 1};
        }
        if (OS.isFamilyOpenVms()) {
            return new int[]{1, 2};
        }
        Assertions.fail((String)"Test not supported for this OS");
        return null;
    }

    public static File resolveScriptForOS(String script) {
        if (OS.isFamilyWindows()) {
            return new File(script + ".bat");
        }
        if (OS.isFamilyUnix()) {
            return new File(script + ".sh");
        }
        if (OS.isFamilyOpenVms()) {
            return new File(script + ".dcl");
        }
        Assertions.fail((String)"Test not supported for this OS");
        return null;
    }

    private TestUtil() {
    }
}

