/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MockHttpServletRequest
implements HttpServletRequest {
    private final InputStream m_requestData;
    private long length;
    private String m_strContentType;
    private int readLimit = -1;
    private final Map<String, String> m_headers = new HashMap<String, String>();

    public MockHttpServletRequest(byte[] requestData, String strContentType) {
        this(new ByteArrayInputStream(requestData), requestData.length, strContentType);
    }

    public MockHttpServletRequest(InputStream requestData, long requestLength, String strContentType) {
        this.m_requestData = requestData;
        this.length = requestLength;
        this.m_strContentType = strContentType;
        this.m_headers.put("Content-type", strContentType);
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String arg0) {
        return 0L;
    }

    public String getHeader(String headerName) {
        return this.m_headers.get(headerName);
    }

    public Enumeration<String> getHeaders(String arg0) {
        return null;
    }

    public Enumeration<String> getHeaderNames() {
        return null;
    }

    public int getIntHeader(String arg0) {
        return 0;
    }

    public String getMethod() {
        return null;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String arg0) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return null;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession(boolean arg0) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String arg0) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        int iLength = 0;
        if (null == this.m_requestData) {
            iLength = -1;
        } else {
            if (this.length > Integer.MAX_VALUE) {
                throw new RuntimeException("Value '" + this.length + "' is too large to be converted to int");
            }
            iLength = (int)this.length;
        }
        return iLength;
    }

    public void setContentLength(long length) {
        this.length = length;
    }

    public String getContentType() {
        return this.m_strContentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        MyServletInputStream sis = new MyServletInputStream(this.m_requestData, this.readLimit);
        return sis;
    }

    public void setReadLimit(int readLimit) {
        this.readLimit = readLimit;
    }

    public String getParameter(String arg0) {
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String arg0) {
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return null;
    }

    public String getProtocol() {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public int getLocalPort() {
        return 0;
    }

    public int getRemotePort() {
        return 0;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String arg0, Object arg1) {
    }

    public void removeAttribute(String arg0) {
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    @Deprecated
    public String getRealPath(String arg0) {
        return null;
    }

    private static class MyServletInputStream
    extends ServletInputStream {
        private final InputStream in;
        private final int readLimit;

        public MyServletInputStream(InputStream pStream, int readLimit) {
            this.in = pStream;
            this.readLimit = readLimit;
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.readLimit > 0) {
                return this.in.read(b, off, Math.min(this.readLimit, len));
            }
            return this.in.read(b, off, len);
        }
    }
}

