/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUploadTestCase {
    protected static final String CONTENT_TYPE = "multipart/form-data; boundary=---1234";

    protected List<FileItem> parseUpload(byte[] bytes) throws FileUploadException {
        return this.parseUpload(bytes, CONTENT_TYPE);
    }

    protected List<FileItem> parseUpload(byte[] bytes, String contentType) throws FileUploadException {
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        MockHttpServletRequest request = new MockHttpServletRequest(bytes, contentType);
        List fileItems = upload.parseRequest((HttpServletRequest)request);
        return fileItems;
    }

    protected List<FileItem> parseUpload(String content) throws UnsupportedEncodingException, FileUploadException {
        byte[] bytes = content.getBytes("US-ASCII");
        return this.parseUpload(bytes, CONTENT_TYPE);
    }
}

