/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.util.Map;
import org.apache.commons.fileupload.ParameterParser;
import org.junit.Assert;
import org.junit.Test;

public class ParameterParserTest {
    @Test
    public void testParsing() {
        String s = "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=\"stuff";
        ParameterParser parser = new ParameterParser();
        Map params = parser.parse(s, ';');
        Assert.assertEquals(null, params.get("test"));
        Assert.assertEquals((Object)"stuff", params.get("test1"));
        Assert.assertEquals((Object)"stuff; stuff", params.get("test2"));
        Assert.assertEquals((Object)"\"stuff", params.get("test3"));
        params = parser.parse(s, new char[]{',', ';'});
        Assert.assertEquals(null, params.get("test"));
        Assert.assertEquals((Object)"stuff", params.get("test1"));
        Assert.assertEquals((Object)"stuff; stuff", params.get("test2"));
        Assert.assertEquals((Object)"\"stuff", params.get("test3"));
        s = "  test  , test1=stuff   ,  , test2=, test3, ";
        params = parser.parse(s, ',');
        Assert.assertEquals(null, params.get("test"));
        Assert.assertEquals((Object)"stuff", params.get("test1"));
        Assert.assertEquals(null, params.get("test2"));
        Assert.assertEquals(null, params.get("test3"));
        s = "  test";
        params = parser.parse(s, ';');
        Assert.assertEquals(null, params.get("test"));
        s = "  ";
        params = parser.parse(s, ';');
        Assert.assertEquals((long)0L, (long)params.size());
        s = " = stuff ";
        params = parser.parse(s, ';');
        Assert.assertEquals((long)0L, (long)params.size());
    }

    @Test
    public void testContentTypeParsing() {
        String s = "text/plain; Charset=UTF-8";
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(s, ';');
        Assert.assertEquals((Object)"UTF-8", params.get("charset"));
    }

    @Test
    public void testParsingEscapedChars() {
        String s = "param = \"stuff\\\"; more stuff\"";
        ParameterParser parser = new ParameterParser();
        Map params = parser.parse(s, ';');
        Assert.assertEquals((long)1L, (long)params.size());
        Assert.assertEquals((Object)"stuff\\\"; more stuff", params.get("param"));
        s = "param = \"stuff\\\\\"; anotherparam";
        params = parser.parse(s, ';');
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"stuff\\\\", params.get("param"));
        Assert.assertNull(params.get("anotherparam"));
    }

    @Test
    public void testFileUpload139() {
        ParameterParser parser = new ParameterParser();
        String s = "Content-type: multipart/form-data , boundary=AaB03x";
        Map params = parser.parse(s, new char[]{',', ';'});
        Assert.assertEquals((Object)"AaB03x", params.get("boundary"));
        s = "Content-type: multipart/form-data, boundary=AaB03x";
        params = parser.parse(s, new char[]{';', ','});
        Assert.assertEquals((Object)"AaB03x", params.get("boundary"));
        s = "Content-type: multipart/mixed, boundary=BbC04y";
        params = parser.parse(s, new char[]{',', ';'});
        Assert.assertEquals((Object)"BbC04y", params.get("boundary"));
    }

    @Test
    public void fileUpload199() {
        ParameterParser parser = new ParameterParser();
        String s = "Content-Disposition: form-data; name=\"file\"; filename=\"=?ISO-8859-1?B?SWYgeW91IGNhbiByZWFkIHRoaXMgeW8=?= =?ISO-8859-2?B?dSB1bmRlcnN0YW5kIHRoZSBleGFtcGxlLg==?=\"\r\n";
        Map params = parser.parse(s, new char[]{',', ';'});
        Assert.assertEquals((Object)"If you can read this you understand the example.", params.get("filename"));
    }
}

