/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.FileUploadTestCase;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.junit.Assert;
import org.junit.Test;

public class ProgressListenerTest
extends FileUploadTestCase {
    @Test
    public void testProgressListener() throws Exception {
        int NUM_ITEMS = 512;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < 512; ++i) {
            String header = "-----1234\r\nContent-Disposition: form-data; name=\"field" + (i + 1) + "\"\r\n\r\n";
            baos.write(header.getBytes("US-ASCII"));
            for (int j = 0; j < 16384 + i; ++j) {
                baos.write((byte)j);
            }
            baos.write("\r\n".getBytes("US-ASCII"));
        }
        baos.write("-----1234--\r\n".getBytes("US-ASCII"));
        byte[] contents = baos.toByteArray();
        MockHttpServletRequest request = new MockHttpServletRequest(contents, "multipart/form-data; boundary=---1234");
        this.runTest(512, contents.length, request);
        request = new MockHttpServletRequest(contents, "multipart/form-data; boundary=---1234"){

            public int getContentLength() {
                return -1;
            }
        };
        this.runTest(512, contents.length, request);
    }

    private void runTest(int NUM_ITEMS, long pContentLength, MockHttpServletRequest request) throws FileUploadException, IOException {
        ServletFileUpload upload = new ServletFileUpload();
        ProgressListenerImpl listener = new ProgressListenerImpl(pContentLength, NUM_ITEMS);
        upload.setProgressListener((ProgressListener)listener);
        FileItemIterator iter = upload.getItemIterator((HttpServletRequest)request);
        for (int i = 0; i < NUM_ITEMS; ++i) {
            FileItemStream stream = iter.next();
            InputStream istream = stream.openStream();
            for (int j = 0; j < 16384 + i; ++j) {
                byte b1 = (byte)j;
                byte b2 = (byte)istream.read();
                if (b1 == b2) continue;
                Assert.fail((String)("Expected " + b1 + ", got " + b2));
            }
            Assert.assertEquals((long)-1L, (long)istream.read());
        }
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        listener.checkFinished();
    }

    private class ProgressListenerImpl
    implements ProgressListener {
        private final long expectedContentLength;
        private final int expectedItems;
        private Long bytesRead;
        private Integer items;

        ProgressListenerImpl(long pContentLength, int pItems) {
            this.expectedContentLength = pContentLength;
            this.expectedItems = pItems;
        }

        public void update(long pBytesRead, long pContentLength, int pItems) {
            Assert.assertTrue((pBytesRead >= 0L && pBytesRead <= this.expectedContentLength ? 1 : 0) != 0);
            Assert.assertTrue((pContentLength == -1L || pContentLength == this.expectedContentLength ? 1 : 0) != 0);
            Assert.assertTrue((pItems >= 0 && pItems <= this.expectedItems ? 1 : 0) != 0);
            Assert.assertTrue((this.bytesRead == null || pBytesRead >= this.bytesRead ? 1 : 0) != 0);
            this.bytesRead = new Long(pBytesRead);
            Assert.assertTrue((this.items == null || pItems >= this.items ? 1 : 0) != 0);
            this.items = new Integer(pItems);
        }

        void checkFinished() {
            Assert.assertEquals((long)this.expectedContentLength, (long)this.bytesRead);
            Assert.assertEquals((long)this.expectedItems, (long)this.items.intValue());
        }
    }
}

