/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.FileUploadTestCase;
import org.apache.commons.fileupload.HttpServletRequestFactory;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.junit.Assert;
import org.junit.Test;

public class ServletFileUploadTest
extends FileUploadTestCase {
    @Test
    public void testWithInvalidRequest() {
        DiskFileUpload fu = null;
        fu = new DiskFileUpload();
        HttpServletRequest req = HttpServletRequestFactory.createInvalidHttpServletRequest();
        try {
            fu.parseRequest(req);
            Assert.fail((String)"testWithInvalidRequest: expected exception was not thrown");
        }
        catch (FileUploadException fileUploadException) {
            // empty catch block
        }
    }

    @Test
    public void testWithNullContentType() {
        DiskFileUpload fu = new DiskFileUpload();
        HttpServletRequest req = HttpServletRequestFactory.createHttpServletRequestWithNullContentType();
        try {
            fu.parseRequest(req);
            Assert.fail((String)"testWithNullContentType: expected exception was not thrown");
        }
        catch (FileUploadBase.InvalidContentTypeException invalidContentTypeException) {
        }
        catch (FileUploadException unexpected) {
            Assert.fail((String)"testWithNullContentType: unexpected exception was thrown");
        }
    }

    @Test
    public void testFileUpload() throws IOException, FileUploadException {
        List<FileItem> fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assert.assertEquals((long)4L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        Assert.assertEquals((Object)"file", (Object)file.getFieldName());
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((Object)"This is the content of the file\n", (Object)file.getString());
        Assert.assertEquals((Object)"text/whatever", (Object)file.getContentType());
        Assert.assertEquals((Object)"foo.tab", (Object)file.getName());
        FileItem field = fileItems.get(1);
        Assert.assertEquals((Object)"field", (Object)field.getFieldName());
        Assert.assertTrue((boolean)field.isFormField());
        Assert.assertEquals((Object)"fieldValue", (Object)field.getString());
        FileItem multi0 = fileItems.get(2);
        Assert.assertEquals((Object)"multi", (Object)multi0.getFieldName());
        Assert.assertTrue((boolean)multi0.isFormField());
        Assert.assertEquals((Object)"value1", (Object)multi0.getString());
        FileItem multi1 = fileItems.get(3);
        Assert.assertEquals((Object)"multi", (Object)multi1.getFieldName());
        Assert.assertTrue((boolean)multi1.isFormField());
        Assert.assertEquals((Object)"value2", (Object)multi1.getString());
    }

    @Test
    public void testFilenameCaseSensitivity() throws IOException, FileUploadException {
        List<FileItem> fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"FiLe\"; filename=\"FOO.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n");
        Assert.assertEquals((long)1L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        Assert.assertEquals((Object)"FiLe", (Object)file.getFieldName());
        Assert.assertEquals((Object)"FOO.tab", (Object)file.getName());
    }

    @Test
    public void testEmptyFile() throws UnsupportedEncodingException, FileUploadException {
        List<FileItem> fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"\"\r\n\r\n\r\n-----1234--\r\n");
        Assert.assertEquals((long)1L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((Object)"", (Object)file.getString());
        Assert.assertEquals((Object)"", (Object)file.getName());
    }

    @Test
    public void testIE5MacBug() throws UnsupportedEncodingException, FileUploadException {
        List<FileItem> fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"field1\"\r\n\r\nfieldValue\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.x\"\r\n\r\n42\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.y\"\r\n\r\n21\r\n-----1234\r\nContent-Disposition: form-data; name=\"field2\"\r\n\r\nfieldValue2\r\n-----1234--\r\n");
        Assert.assertEquals((long)4L, (long)fileItems.size());
        FileItem field1 = fileItems.get(0);
        Assert.assertEquals((Object)"field1", (Object)field1.getFieldName());
        Assert.assertTrue((boolean)field1.isFormField());
        Assert.assertEquals((Object)"fieldValue", (Object)field1.getString());
        FileItem submitX = fileItems.get(1);
        Assert.assertEquals((Object)"submitName.x", (Object)submitX.getFieldName());
        Assert.assertTrue((boolean)submitX.isFormField());
        Assert.assertEquals((Object)"42", (Object)submitX.getString());
        FileItem submitY = fileItems.get(2);
        Assert.assertEquals((Object)"submitName.y", (Object)submitY.getFieldName());
        Assert.assertTrue((boolean)submitY.isFormField());
        Assert.assertEquals((Object)"21", (Object)submitY.getString());
        FileItem field2 = fileItems.get(3);
        Assert.assertEquals((Object)"field2", (Object)field2.getFieldName());
        Assert.assertTrue((boolean)field2.isFormField());
        Assert.assertEquals((Object)"fieldValue2", (Object)field2.getString());
    }

    @Test
    public void testFILEUPLOAD62() throws Exception {
        String contentType = "multipart/form-data; boundary=AaB03x";
        String request = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--";
        List<FileItem> fileItems = this.parseUpload("--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--".getBytes("US-ASCII"), "multipart/form-data; boundary=AaB03x");
        Assert.assertEquals((long)3L, (long)fileItems.size());
        FileItem item0 = fileItems.get(0);
        Assert.assertEquals((Object)"field1", (Object)item0.getFieldName());
        Assert.assertNull((Object)item0.getName());
        Assert.assertEquals((Object)"Joe Blow", (Object)new String(item0.get()));
        FileItem item1 = fileItems.get(1);
        Assert.assertEquals((Object)"pics", (Object)item1.getFieldName());
        Assert.assertEquals((Object)"file1.txt", (Object)item1.getName());
        Assert.assertEquals((Object)"... contents of file1.txt ...", (Object)new String(item1.get()));
        FileItem item2 = fileItems.get(2);
        Assert.assertEquals((Object)"pics", (Object)item2.getFieldName());
        Assert.assertEquals((Object)"file2.gif", (Object)item2.getName());
        Assert.assertEquals((Object)"...contents of file2.gif...", (Object)new String(item2.get()));
    }

    @Test
    public void testFoldedHeaders() throws IOException, FileUploadException {
        List<FileItem> fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; \r\n\tname=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data;\r\n     name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assert.assertEquals((long)4L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        Assert.assertEquals((Object)"file", (Object)file.getFieldName());
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((Object)"This is the content of the file\n", (Object)file.getString());
        Assert.assertEquals((Object)"text/whatever", (Object)file.getContentType());
        Assert.assertEquals((Object)"foo.tab", (Object)file.getName());
        FileItem field = fileItems.get(1);
        Assert.assertEquals((Object)"field", (Object)field.getFieldName());
        Assert.assertTrue((boolean)field.isFormField());
        Assert.assertEquals((Object)"fieldValue", (Object)field.getString());
        FileItem multi0 = fileItems.get(2);
        Assert.assertEquals((Object)"multi", (Object)multi0.getFieldName());
        Assert.assertTrue((boolean)multi0.isFormField());
        Assert.assertEquals((Object)"value1", (Object)multi0.getString());
        FileItem multi1 = fileItems.get(3);
        Assert.assertEquals((Object)"multi", (Object)multi1.getFieldName());
        Assert.assertTrue((boolean)multi1.isFormField());
        Assert.assertEquals((Object)"value2", (Object)multi1.getString());
    }

    @Test
    public void testFileUpload130() throws Exception {
        String[] headerNames = new String[]{"SomeHeader", "OtherHeader", "YetAnotherHeader", "WhatAHeader"};
        String[] headerValues = new String[]{"present", "Is there", "Here", "Is That"};
        List<FileItem> fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n" + headerNames[0] + ": " + headerValues[0] + "\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; \r\n\tname=\"field\"\r\n" + headerNames[1] + ": " + headerValues[1] + "\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data;\r\n     name=\"multi\"\r\n" + headerNames[2] + ": " + headerValues[2] + "\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n" + headerNames[3] + ": " + headerValues[3] + "\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assert.assertEquals((long)4L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        this.assertHeaders(headerNames, headerValues, file, 0);
        FileItem field = fileItems.get(1);
        this.assertHeaders(headerNames, headerValues, field, 1);
        FileItem multi0 = fileItems.get(2);
        this.assertHeaders(headerNames, headerValues, multi0, 2);
        FileItem multi1 = fileItems.get(3);
        this.assertHeaders(headerNames, headerValues, multi1, 3);
    }

    @Test
    public void parseParameterMap() throws Exception {
        String text = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n";
        byte[] bytes = text.getBytes("US-ASCII");
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        MockHttpServletRequest request = new MockHttpServletRequest(bytes, "multipart/form-data; boundary=---1234");
        Map mappedParameters = upload.parseParameterMap((HttpServletRequest)request);
        Assert.assertTrue((boolean)mappedParameters.containsKey("file"));
        Assert.assertEquals((long)1L, (long)((List)mappedParameters.get("file")).size());
        Assert.assertTrue((boolean)mappedParameters.containsKey("field"));
        Assert.assertEquals((long)1L, (long)((List)mappedParameters.get("field")).size());
        Assert.assertTrue((boolean)mappedParameters.containsKey("multi"));
        Assert.assertEquals((long)2L, (long)((List)mappedParameters.get("multi")).size());
    }

    private void assertHeaders(String[] pHeaderNames, String[] pHeaderValues, FileItem pItem, int pIndex) {
        for (int i = 0; i < pHeaderNames.length; ++i) {
            String value = pItem.getHeaders().getHeader(pHeaderNames[i]);
            if (i == pIndex) {
                Assert.assertEquals((Object)pHeaderValues[i], (Object)value);
                continue;
            }
            Assert.assertNull((Object)value);
        }
    }
}

