/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.junit.Assert;
import org.junit.Test;

public class DiskFileItemSerializeTest {
    private static final String ERRMSG_DISKFILEITEM_DESERIALIZED = "Property org.apache.commons.fileupload.disk.DiskFileItem.serializable is not true, rejecting to deserialize a DiskFileItem.";
    private static final String textContentType = "text/plain";
    private static final int threshold = 16;

    public void testInMemoryObject(byte[] testFieldValueBytes, File repository) {
        FileItem item = this.createFileItem(testFieldValueBytes, repository);
        Assert.assertTrue((String)"Initial: in memory", (boolean)item.isInMemory());
        Assert.assertEquals((String)"Initial: size", (long)item.getSize(), (long)testFieldValueBytes.length);
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        FileItem newItem = (FileItem)this.serializeDeserialize(item);
        Assert.assertTrue((String)"Check in memory", (boolean)newItem.isInMemory());
        this.compareBytes("Check", testFieldValueBytes, newItem.get());
        this.compareFileItems(item, newItem);
    }

    private void testInMemoryObject(byte[] testFieldValueBytes) {
        this.testInMemoryObject(testFieldValueBytes, null);
    }

    @Test
    public void testBelowThreshold() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(15);
        this.testInMemoryObject(testFieldValueBytes);
    }

    @Test
    public void testThreshold() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        this.testInMemoryObject(testFieldValueBytes);
    }

    @Test
    public void testAboveThreshold() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(17);
        FileItem item = this.createFileItem(testFieldValueBytes);
        Assert.assertFalse((String)"Initial: in memory", (boolean)item.isInMemory());
        Assert.assertEquals((String)"Initial: size", (long)item.getSize(), (long)testFieldValueBytes.length);
        this.compareBytes("Initial", item.get(), testFieldValueBytes);
        FileItem newItem = (FileItem)this.serializeDeserialize(item);
        Assert.assertFalse((String)"Check in memory", (boolean)newItem.isInMemory());
        this.compareBytes("Check", testFieldValueBytes, newItem.get());
        this.compareFileItems(item, newItem);
    }

    @Test
    public void testValidRepository() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        File repository = new File(System.getProperty("java.io.tmpdir"));
        this.testInMemoryObject(testFieldValueBytes, repository);
    }

    @Test(expected=IOException.class)
    public void testInvalidRepository() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        File repository = new File(System.getProperty("java.io.tmpdir") + "file");
        FileItem item = this.createFileItem(testFieldValueBytes, repository);
        this.deserialize(this.serialize(item));
    }

    @Test
    public void testInvalidRepositoryWithNullChar() throws Exception {
        byte[] testFieldValueBytes = this.createContentBytes(16);
        File repository = new File(System.getProperty("java.io.tmpdir") + "\u0000");
        FileItem item = this.createFileItem(testFieldValueBytes, repository);
        try {
            this.deserialize(this.serialize(item));
            Assert.fail((String)"Expected Exception");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)ERRMSG_DISKFILEITEM_DESERIALIZED, (Object)e.getMessage());
        }
        System.setProperty(DiskFileItem.SERIALIZABLE_PROPERTY, "true");
    }

    private void compareFileItems(FileItem origItem, FileItem newItem) {
        Assert.assertTrue((String)"Compare: is in Memory", (origItem.isInMemory() == newItem.isInMemory() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Compare: is Form Field", (origItem.isFormField() == newItem.isFormField() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Compare: Field Name", (Object)origItem.getFieldName(), (Object)newItem.getFieldName());
        Assert.assertEquals((String)"Compare: Content Type", (Object)origItem.getContentType(), (Object)newItem.getContentType());
        Assert.assertEquals((String)"Compare: File Name", (Object)origItem.getName(), (Object)newItem.getName());
    }

    private void compareBytes(String text, byte[] origBytes, byte[] newBytes) {
        Assert.assertNotNull((String)"origBytes must not be null", (Object)origBytes);
        Assert.assertNotNull((String)"newBytes must not be null", (Object)newBytes);
        Assert.assertEquals((String)(text + " byte[] length"), (long)origBytes.length, (long)newBytes.length);
        for (int i = 0; i < origBytes.length; ++i) {
            Assert.assertEquals((String)(text + " byte[" + i + "]"), (long)origBytes[i], (long)newBytes[i]);
        }
    }

    private byte[] createContentBytes(int size) {
        StringBuilder buffer = new StringBuilder(size);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            buffer.append(count + "");
            count = (byte)(count + 1);
            if (count <= 9) continue;
            count = 0;
        }
        return buffer.toString().getBytes();
    }

    private FileItem createFileItem(byte[] contentBytes, File repository) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, repository);
        String textFieldName = "textField";
        FileItem item = factory.createItem(textFieldName, textContentType, true, "My File Name");
        try {
            OutputStream os = item.getOutputStream();
            os.write(contentBytes);
            os.close();
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException" + e));
        }
        return item;
    }

    private FileItem createFileItem(byte[] contentBytes) {
        return this.createFileItem(contentBytes, null);
    }

    private ByteArrayOutputStream serialize(Object target) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(target);
        oos.flush();
        oos.close();
        return baos;
    }

    private Object deserialize(ByteArrayOutputStream baos) throws Exception {
        Object result = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        result = ois.readObject();
        bais.close();
        return result;
    }

    private Object serializeDeserialize(Object target) {
        ByteArrayOutputStream baos = null;
        try {
            baos = this.serialize(target);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception during serialization: " + e));
        }
        Object result = null;
        try {
            result = this.deserialize(baos);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception during deserialization: " + e));
        }
        return result;
    }
}

