/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.InvalidFileNameException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingTest
extends TestCase {
    public void testFileUpload() throws IOException, FileUploadException {
        byte[] request = this.newRequest();
        List<FileItem> fileItems = this.parseUpload(request);
        Iterator<FileItem> fileIter = fileItems.iterator();
        int add = 16;
        int num = 0;
        for (int i = 0; i < 16384; i += add) {
            if (++add == 32) {
                add = 16;
            }
            FileItem item = fileIter.next();
            StreamingTest.assertEquals((String)("field" + num++), (String)item.getFieldName());
            byte[] bytes = item.get();
            StreamingTest.assertEquals((int)i, (int)bytes.length);
            for (int j = 0; j < i; ++j) {
                StreamingTest.assertEquals((byte)((byte)j), (byte)bytes[j]);
            }
        }
        StreamingTest.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    public void testFileUploadException() throws IOException, FileUploadException {
        byte[] request = this.newRequest();
        byte[] invalidRequest = new byte[request.length - 11];
        System.arraycopy(request, 0, invalidRequest, 0, request.length - 11);
        try {
            this.parseUpload(invalidRequest);
            StreamingTest.fail((String)"Expected EndOfStreamException");
        }
        catch (FileUploadBase.IOFileUploadException e) {
            StreamingTest.assertTrue((boolean)(e.getCause() instanceof MultipartStream.MalformedStreamException));
        }
    }

    public void testIOException() throws IOException {
        byte[] request = this.newRequest();
        FilterInputStream stream = new FilterInputStream(new ByteArrayInputStream(request)){
            private int num;

            public int read() throws IOException {
                if (++this.num > 123) {
                    throw new IOException("123");
                }
                return super.read();
            }

            public int read(byte[] pB, int pOff, int pLen) throws IOException {
                for (int i = 0; i < pLen; ++i) {
                    int res = this.read();
                    if (res == -1) {
                        return i == 0 ? -1 : i;
                    }
                    pB[pOff + i] = (byte)res;
                }
                return pLen;
            }
        };
        try {
            this.parseUpload(stream, request.length);
            StreamingTest.fail((String)"Expected IOException");
        }
        catch (FileUploadException e) {
            StreamingTest.assertTrue((boolean)(e.getCause() instanceof IOException));
            StreamingTest.assertEquals((String)"123", (String)e.getCause().getMessage());
        }
    }

    public void testFILEUPLOAD135() throws IOException, FileUploadException {
        byte[] request = this.newShortRequest();
        final ByteArrayInputStream bais = new ByteArrayInputStream(request);
        List<FileItem> fileItems = this.parseUpload(new InputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return bais.read(b, off, Math.min(len, 3));
            }
        }, request.length);
        Iterator<FileItem> fileIter = fileItems.iterator();
        StreamingTest.assertTrue((boolean)fileIter.hasNext());
        FileItem item = fileIter.next();
        StreamingTest.assertEquals((String)"field", (String)item.getFieldName());
        byte[] bytes = item.get();
        StreamingTest.assertEquals((int)3, (int)bytes.length);
        StreamingTest.assertEquals((byte)49, (byte)bytes[0]);
        StreamingTest.assertEquals((byte)50, (byte)bytes[1]);
        StreamingTest.assertEquals((byte)51, (byte)bytes[2]);
        StreamingTest.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    private List<FileItem> parseUpload(byte[] bytes) throws FileUploadException {
        return this.parseUpload(new ByteArrayInputStream(bytes), bytes.length);
    }

    private FileItemIterator parseUpload(int pLength, InputStream pStream) throws FileUploadException, IOException {
        String contentType = "multipart/form-data; boundary=---1234";
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory());
        MockHttpServletRequest request = new MockHttpServletRequest(pStream, pLength, contentType);
        return upload.getItemIterator((RequestContext)new ServletRequestContext((HttpServletRequest)request));
    }

    private List<FileItem> parseUpload(InputStream pStream, int pLength) throws FileUploadException {
        String contentType = "multipart/form-data; boundary=---1234";
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory());
        MockHttpServletRequest request = new MockHttpServletRequest(pStream, pLength, contentType);
        List fileItems = upload.parseRequest((RequestContext)new ServletRequestContext((HttpServletRequest)request));
        return fileItems;
    }

    private String getHeader(String pField) {
        return "-----1234\r\nContent-Disposition: form-data; name=\"" + pField + "\"\r\n\r\n";
    }

    private String getFooter() {
        return "-----1234--\r\n";
    }

    private byte[] newShortRequest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "US-ASCII");
        osw.write(this.getHeader("field"));
        osw.write("123");
        osw.write("\r\n");
        osw.write(this.getFooter());
        osw.close();
        return baos.toByteArray();
    }

    private byte[] newRequest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "US-ASCII");
        int add = 16;
        int num = 0;
        for (int i = 0; i < 16384; i += add) {
            if (++add == 32) {
                add = 16;
            }
            osw.write(this.getHeader("field" + num++));
            osw.flush();
            for (int j = 0; j < i; ++j) {
                baos.write((byte)j);
            }
            osw.write("\r\n");
        }
        osw.write(this.getFooter());
        osw.close();
        return baos.toByteArray();
    }

    public void testInvalidFileNameException() throws Exception {
        String fileName = "foo.exe\u0000.png";
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.exe\u0000.png\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n";
        byte[] reqBytes = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.exe\u0000.png\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n".getBytes("US-ASCII");
        FileItemIterator fileItemIter = this.parseUpload(reqBytes.length, new ByteArrayInputStream(reqBytes));
        FileItemStream fileItemStream = fileItemIter.next();
        try {
            fileItemStream.getName();
            StreamingTest.fail((String)"Expected exception");
        }
        catch (InvalidFileNameException e) {
            StreamingTest.assertEquals((String)"foo.exe\u0000.png", (String)e.getName());
            StreamingTest.assertTrue((e.getMessage().indexOf("foo.exe\u0000.png") == -1 ? 1 : 0) != 0);
            StreamingTest.assertTrue((e.getMessage().indexOf("foo.exe\\0.png") != -1 ? 1 : 0) != 0);
        }
        List<FileItem> fileItems = this.parseUpload(reqBytes);
        FileItem fileItem = fileItems.get(0);
        try {
            fileItem.getName();
            StreamingTest.fail((String)"Expected exception");
        }
        catch (InvalidFileNameException e) {
            StreamingTest.assertEquals((String)"foo.exe\u0000.png", (String)e.getName());
            StreamingTest.assertTrue((e.getMessage().indexOf("foo.exe\u0000.png") == -1 ? 1 : 0) != 0);
            StreamingTest.assertTrue((e.getMessage().indexOf("foo.exe\\0.png") != -1 ? 1 : 0) != 0);
        }
    }
}

