/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.portlet;

import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.MockPortletActionRequest;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PortletFileUploadTest {
    private PortletFileUpload upload;

    @Before
    public void setUp() {
        this.upload = new PortletFileUpload((FileItemFactory)new DiskFileItemFactory());
    }

    @Test
    public void parseParameterMap() throws Exception {
        String text = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n";
        byte[] bytes = text.getBytes("US-ASCII");
        MockPortletActionRequest request = new MockPortletActionRequest(bytes, "multipart/form-data; boundary=---1234");
        Map mappedParameters = this.upload.parseParameterMap((ActionRequest)request);
        Assert.assertTrue((boolean)mappedParameters.containsKey("file"));
        Assert.assertEquals((long)1L, (long)((List)mappedParameters.get("file")).size());
        Assert.assertTrue((boolean)mappedParameters.containsKey("field"));
        Assert.assertEquals((long)1L, (long)((List)mappedParameters.get("field")).size());
        Assert.assertTrue((boolean)mappedParameters.containsKey("multi"));
        Assert.assertEquals((long)2L, (long)((List)mappedParameters.get("multi")).size());
    }
}

