/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.util.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.util.mime.Base64Decoder;
import org.junit.Assert;
import org.junit.Test;

public final class Base64DecoderTestCase {
    private static final String US_ASCII_CHARSET = "US-ASCII";

    @Test
    public void rfc4648Section10Decode() throws Exception {
        Base64DecoderTestCase.assertEncoded("", "");
        Base64DecoderTestCase.assertEncoded("f", "Zg==");
        Base64DecoderTestCase.assertEncoded("fo", "Zm8=");
        Base64DecoderTestCase.assertEncoded("foo", "Zm9v");
        Base64DecoderTestCase.assertEncoded("foob", "Zm9vYg==");
        Base64DecoderTestCase.assertEncoded("fooba", "Zm9vYmE=");
        Base64DecoderTestCase.assertEncoded("foobar", "Zm9vYmFy");
    }

    @Test
    public void decodeWithInnerPad() throws Exception {
        Base64DecoderTestCase.assertEncoded("Hello WorldHello World", "SGVsbG8gV29ybGQ=SGVsbG8gV29ybGQ=");
    }

    @Test
    public void nonBase64Bytes() throws Exception {
        Base64DecoderTestCase.assertEncoded("Hello World", "S?G!V%sbG 8g\rV\t\n29ybGQ*=");
    }

    @Test(expected=IOException.class)
    public void truncatedString() throws Exception {
        byte[] x = new byte[]{110};
        Base64Decoder.decode((byte[])x, (OutputStream)new ByteArrayOutputStream());
    }

    @Test
    public void decodeTrailingJunk() throws Exception {
        Base64DecoderTestCase.assertEncoded("foobar", "Zm9vYmFy!!!");
    }

    @Test
    public void decodeTrailing1() throws Exception {
        Base64DecoderTestCase.assertIOException("truncated", "Zm9vYmFy1");
    }

    @Test
    public void decodeTrailing2() throws Exception {
        Base64DecoderTestCase.assertIOException("truncated", "Zm9vYmFy12");
    }

    @Test
    public void decodeTrailing3() throws Exception {
        Base64DecoderTestCase.assertIOException("truncated", "Zm9vYmFy123");
    }

    @Test
    public void badPadding() throws Exception {
        Base64DecoderTestCase.assertIOException("incorrect padding, 4th byte", "Zg=a");
    }

    @Test
    public void badPaddingLeading1() throws Exception {
        Base64DecoderTestCase.assertIOException("incorrect padding, first two bytes cannot be padding", "=A==");
    }

    @Test
    public void badPaddingLeading2() throws Exception {
        Base64DecoderTestCase.assertIOException("incorrect padding, first two bytes cannot be padding", "====");
    }

    @Test
    public void badLength() throws Exception {
        Base64DecoderTestCase.assertIOException("truncated", "Zm8==");
    }

    @Test
    public void nonASCIIcharacter() throws Exception {
        Base64DecoderTestCase.assertEncoded("f", "Zg=\u00c0=");
        Base64DecoderTestCase.assertEncoded("f", "Zg=\u0100=");
    }

    private static void assertEncoded(String clearText, String encoded) throws Exception {
        byte[] expected = clearText.getBytes(US_ASCII_CHARSET);
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        byte[] encodedData = encoded.getBytes(US_ASCII_CHARSET);
        Base64Decoder.decode((byte[])encodedData, (OutputStream)out);
        byte[] actual = out.toByteArray();
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    private static void assertIOException(String messageText, String encoded) throws UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        byte[] encodedData = encoded.getBytes(US_ASCII_CHARSET);
        try {
            Base64Decoder.decode((byte[])encodedData, (OutputStream)out);
            Assert.fail((String)"Expected IOException");
        }
        catch (IOException e) {
            String em = e.getMessage();
            Assert.assertTrue((String)("Expected to find " + messageText + " in '" + em + "'"), (boolean)em.contains(messageText));
        }
    }
}

