/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.HttpServletRequestFactory;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DiskFileUploadTest {
    private DiskFileUpload upload;

    @Before
    public void setUp() {
        this.upload = new DiskFileUpload();
    }

    @Test
    public void testWithInvalidRequest() {
        HttpServletRequest req = HttpServletRequestFactory.createInvalidHttpServletRequest();
        try {
            this.upload.parseRequest(req);
            Assert.fail((String)"testWithInvalidRequest: expected exception was not thrown");
        }
        catch (FileUploadException fileUploadException) {
            // empty catch block
        }
    }

    @Test
    public void testWithNullContentType() {
        HttpServletRequest req = HttpServletRequestFactory.createHttpServletRequestWithNullContentType();
        try {
            this.upload.parseRequest(req);
            Assert.fail((String)"testWithNullContentType: expected exception was not thrown");
        }
        catch (FileUploadBase.InvalidContentTypeException invalidContentTypeException) {
        }
        catch (FileUploadException unexpected) {
            Assert.fail((String)"testWithNullContentType: unexpected exception was thrown");
        }
    }

    @Test
    public void testMoveFile() throws Exception {
        DiskFileUpload myUpload = new DiskFileUpload();
        myUpload.setSizeThreshold(0);
        String content = "-----1234\r\nContent-Disposition: form-data; name=\"file\";filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        byte[] contentBytes = "-----1234\r\nContent-Disposition: form-data; name=\"file\";filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII");
        MockHttpServletRequest request = new MockHttpServletRequest(contentBytes, "multipart/form-data; boundary=---1234");
        List items = myUpload.parseRequest((HttpServletRequest)request);
        Assert.assertNotNull((Object)items);
        Assert.assertFalse((boolean)items.isEmpty());
        DiskFileItem dfi = (DiskFileItem)items.get(0);
        File out = File.createTempFile("install", ".tmp");
        dfi.write(out);
    }
}

