/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload2.core.RFC2231Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class RFC2231UtilityTestCase {
    private static void assertEncoded(String expected, String encoded) throws Exception {
        Assertions.assertEquals((Object)expected, (Object)RFC2231Utils.decodeText((String)encoded));
    }

    @Test
    public void decodeInvalidEncoding() throws Exception {
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> RFC2231Utils.decodeText((String)"abc'en'hello"));
    }

    @Test
    public void decodeIso88591() throws Exception {
        RFC2231UtilityTestCase.assertEncoded("\u00a3 rate", "iso-8859-1'en'%A3%20rate");
    }

    @Test
    public void decodeUtf8() throws Exception {
        RFC2231UtilityTestCase.assertEncoded("\u00a3 and \u20ac rates", "UTF-8''%c2%a3%20and%20%e2%82%ac%20rates");
    }

    @Test
    public void noNeedToDecode() throws Exception {
        RFC2231UtilityTestCase.assertEncoded("abc", "abc");
    }

    @Test
    public void testHasEncodedValue() {
        String nameWithAsteriskAtEnd = "paramname*";
        Assertions.assertTrue((boolean)RFC2231Utils.hasEncodedValue((String)"paramname*"));
        String nameWithAsteriskNotAtEnd = "param*name";
        Assertions.assertFalse((boolean)RFC2231Utils.hasEncodedValue((String)"param*name"));
        String nameWithoutAsterisk = "paramname";
        Assertions.assertFalse((boolean)RFC2231Utils.hasEncodedValue((String)"paramname"));
    }

    @Test
    public void testStripDelimiter() {
        String nameWithAsteriskAtEnd = "paramname*";
        Assertions.assertEquals((Object)"paramname", (Object)RFC2231Utils.stripDelimiter((String)"paramname*"));
        String nameWithAsteriskNotAtEnd = "param*name";
        Assertions.assertEquals((Object)"param*name", (Object)RFC2231Utils.stripDelimiter((String)"param*name"));
        String nameWithTwoAsterisks = "param*name*";
        Assertions.assertEquals((Object)"param*name", (Object)RFC2231Utils.stripDelimiter((String)"param*name*"));
        String nameWithoutAsterisk = "paramname";
        Assertions.assertEquals((Object)"paramname", (Object)RFC2231Utils.stripDelimiter((String)"paramname"));
    }
}

