/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.javax;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.AbstractFileUploadTest;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.fileupload2.javax.JavaxMockHttpServletRequest;
import org.apache.commons.fileupload2.javax.JavaxServletDiskFileUpload;
import org.apache.commons.fileupload2.javax.JavaxServletFileUpload;
import org.apache.commons.fileupload2.javax.JavaxServletRequestContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaxServletFileUploadDiskTest
extends AbstractFileUploadTest<JavaxServletDiskFileUpload, HttpServletRequest, DiskFileItem, DiskFileItemFactory> {
    public JavaxServletFileUploadDiskTest() {
        super((AbstractFileUpload)new JavaxServletDiskFileUpload());
    }

    public List<DiskFileItem> parseUpload(JavaxServletDiskFileUpload upload, byte[] bytes, String contentType) throws FileUploadException {
        JavaxMockHttpServletRequest request = new JavaxMockHttpServletRequest(bytes, contentType);
        return upload.parseRequest((RequestContext)new JavaxServletRequestContext((HttpServletRequest)request));
    }

    @Test
    public void testFileUpload() throws IOException, FileUploadException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int add = 16;
        int num = 0;
        for (int i = 0; i < 16384; i += add) {
            if (++add == 32) {
                add = 16;
            }
            String header = "-----1234\r\nContent-Disposition: form-data; name=\"field" + num++ + "\"\r\n\r\n";
            baos.write(header.getBytes(StandardCharsets.US_ASCII));
            for (int j = 0; j < i; ++j) {
                baos.write((byte)j);
            }
            baos.write("\r\n".getBytes(StandardCharsets.US_ASCII));
        }
        baos.write("-----1234--\r\n".getBytes(StandardCharsets.US_ASCII));
        List fileItems = this.parseUpload((AbstractFileUpload)new JavaxServletDiskFileUpload(), baos.toByteArray());
        Iterator fileIter = fileItems.iterator();
        add = 16;
        num = 0;
        for (int i = 0; i < 16384; i += add) {
            if (++add == 32) {
                add = 16;
            }
            DiskFileItem item = (DiskFileItem)fileIter.next();
            Assertions.assertEquals((Object)("field" + num++), (Object)item.getFieldName());
            byte[] bytes = item.get();
            Assertions.assertEquals((int)i, (int)bytes.length);
            for (int j = 0; j < i; ++j) {
                Assertions.assertEquals((byte)((byte)j), (byte)bytes[j]);
            }
        }
        Assertions.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testParseImpliedUtf8() throws Exception {
        String text = "-----1234\r\nContent-Disposition: form-data; name=\"utf8Html\"\r\n\r\nTh\u00eds \u00eds the co\u00f1te\u00f1t of the f\u00edle\n\r\n-----1234--\r\n";
        byte[] bytes = "-----1234\r\nContent-Disposition: form-data; name=\"utf8Html\"\r\n\r\nTh\u00eds \u00eds the co\u00f1te\u00f1t of the f\u00edle\n\r\n-----1234--\r\n".getBytes(StandardCharsets.UTF_8);
        JavaxMockHttpServletRequest request = new JavaxMockHttpServletRequest(bytes, "multipart/form-data; boundary=---1234");
        DiskFileItemFactory fileItemFactory = ((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setCharset(StandardCharsets.UTF_8)).get();
        JavaxServletFileUpload upload = new JavaxServletFileUpload((FileItemFactory)fileItemFactory);
        List fileItems = upload.parseRequest((HttpServletRequest)request);
        DiskFileItem fileItem = (DiskFileItem)fileItems.get(0);
        Assertions.assertTrue((boolean)fileItem.getString().contains("co\u00f1te\u00f1t"), (String)fileItem.getString());
    }

    @Test
    public void testParseParameterMap() throws Exception {
        String text = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n";
        byte[] bytes = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n".getBytes(StandardCharsets.US_ASCII);
        JavaxMockHttpServletRequest request = new JavaxMockHttpServletRequest(bytes, "multipart/form-data; boundary=---1234");
        JavaxServletFileUpload upload = new JavaxServletFileUpload((FileItemFactory)DiskFileItemFactory.builder().get());
        Map mappedParameters = upload.parseParameterMap((HttpServletRequest)request);
        Assertions.assertTrue((boolean)mappedParameters.containsKey("file"));
        Assertions.assertEquals((int)1, (int)((List)mappedParameters.get("file")).size());
        Assertions.assertTrue((boolean)mappedParameters.containsKey("field"));
        Assertions.assertEquals((int)1, (int)((List)mappedParameters.get("field")).size());
        Assertions.assertTrue((boolean)mappedParameters.containsKey("multi"));
        Assertions.assertEquals((int)2, (int)((List)mappedParameters.get("multi")).size());
    }
}

