/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.core.ProgressListener;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.output.NullOutputStream;

public final class MultipartInput {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    public static final int HEADER_PART_SIZE_MAX = 10240;
    static final int DEFAULT_BUFSIZE = 4096;
    static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private final InputStream input;
    private int boundaryLength;
    private final int keepRegion;
    private final byte[] boundary;
    private final int[] boundaryTable;
    private final int bufSize;
    private final byte[] buffer;
    private int head;
    private int tail;
    private Charset headerCharset;
    private final ProgressNotifier notifier;

    static boolean arrayEquals(byte[] a, byte[] b, int count) {
        for (int i = 0; i < count; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    private MultipartInput(InputStream input, byte[] boundary, int bufferSize, ProgressNotifier notifier) {
        if (boundary == null) {
            throw new IllegalArgumentException("boundary may not be null");
        }
        this.boundaryLength = boundary.length + BOUNDARY_PREFIX.length;
        if (bufferSize < this.boundaryLength + 1) {
            throw new IllegalArgumentException("The buffer size specified for the MultipartInput is too small");
        }
        this.input = input;
        this.bufSize = Math.max(bufferSize, this.boundaryLength * 2);
        this.buffer = new byte[this.bufSize];
        this.notifier = notifier;
        this.boundary = new byte[this.boundaryLength];
        this.boundaryTable = new int[this.boundaryLength + 1];
        this.keepRegion = this.boundary.length;
        System.arraycopy(BOUNDARY_PREFIX, 0, this.boundary, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(boundary, 0, this.boundary, BOUNDARY_PREFIX.length, boundary.length);
        this.computeBoundaryTable();
        this.head = 0;
        this.tail = 0;
    }

    private void computeBoundaryTable() {
        int position = 2;
        int candidate = 0;
        this.boundaryTable[0] = -1;
        this.boundaryTable[1] = 0;
        while (position <= this.boundaryLength) {
            if (this.boundary[position - 1] == this.boundary[candidate]) {
                this.boundaryTable[position] = candidate + 1;
                ++candidate;
                ++position;
                continue;
            }
            if (candidate > 0) {
                candidate = this.boundaryTable[candidate];
                continue;
            }
            this.boundaryTable[position] = 0;
            ++position;
        }
    }

    public long discardBodyData() throws MalformedStreamException, IOException {
        return this.readBodyData((OutputStream)NullOutputStream.INSTANCE);
    }

    protected int findByte(byte value, int pos) {
        for (int i = pos; i < this.tail; ++i) {
            if (this.buffer[i] != value) continue;
            return i;
        }
        return -1;
    }

    protected int findSeparator() {
        int tablePos = 0;
        for (int bufferPos = this.head; bufferPos < this.tail; ++bufferPos) {
            while (tablePos >= 0 && this.buffer[bufferPos] != this.boundary[tablePos]) {
                tablePos = this.boundaryTable[tablePos];
            }
            if (++tablePos != this.boundaryLength) continue;
            return bufferPos - this.boundaryLength;
        }
        return -1;
    }

    public Charset getHeaderCharset() {
        return this.headerCharset;
    }

    public ItemInputStream newInputStream() {
        return new ItemInputStream();
    }

    public long readBodyData(OutputStream output) throws MalformedStreamException, IOException {
        try (ItemInputStream inputStream = this.newInputStream();){
            long l = IOUtils.copyLarge((InputStream)inputStream, (OutputStream)output);
            return l;
        }
    }

    public boolean readBoundary() throws FileUploadSizeException, MalformedStreamException {
        boolean nextChunk;
        block6: {
            byte[] marker = new byte[2];
            this.head += this.boundaryLength;
            try {
                marker[0] = this.readByte();
                if (marker[0] == 10) {
                    return true;
                }
                marker[1] = this.readByte();
                if (MultipartInput.arrayEquals(marker, STREAM_TERMINATOR, 2)) {
                    nextChunk = false;
                    break block6;
                }
                if (MultipartInput.arrayEquals(marker, FIELD_SEPARATOR, 2)) {
                    nextChunk = true;
                    break block6;
                }
                throw new MalformedStreamException("Unexpected characters follow a boundary");
            }
            catch (FileUploadSizeException e) {
                throw e;
            }
            catch (IOException e) {
                throw new MalformedStreamException("Stream ended unexpectedly", e);
            }
        }
        return nextChunk;
    }

    public byte readByte() throws IOException {
        if (this.head == this.tail) {
            this.head = 0;
            this.tail = this.input.read(this.buffer, this.head, this.bufSize);
            if (this.tail == -1) {
                throw new IOException("No more data is available");
            }
            if (this.notifier != null) {
                this.notifier.noteBytesRead(this.tail);
            }
        }
        return this.buffer[this.head++];
    }

    public String readHeaders() throws FileUploadSizeException, MalformedStreamException {
        int i = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int size = 0;
        while (i < HEADER_SEPARATOR.length) {
            byte b;
            try {
                b = this.readByte();
            }
            catch (FileUploadSizeException e) {
                throw e;
            }
            catch (IOException e) {
                throw new MalformedStreamException("Stream ended unexpectedly", e);
            }
            if (++size > 10240) {
                throw new MalformedStreamException(String.format("Header section has more than %s bytes (maybe it is not properly terminated)", 10240));
            }
            i = b == HEADER_SEPARATOR[i] ? ++i : 0;
            baos.write(b);
        }
        try {
            return baos.toString(Charsets.toCharset((Charset)this.headerCharset, (Charset)Charset.defaultCharset()).name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setBoundary(byte[] boundary) throws FileUploadBoundaryException {
        if (boundary.length != this.boundaryLength - BOUNDARY_PREFIX.length) {
            throw new FileUploadBoundaryException("The length of a boundary token cannot be changed");
        }
        System.arraycopy(boundary, 0, this.boundary, BOUNDARY_PREFIX.length, boundary.length);
        this.computeBoundaryTable();
    }

    public void setHeaderCharset(Charset headerCharset) {
        this.headerCharset = headerCharset;
    }

    public boolean skipPreamble() throws IOException {
        System.arraycopy(this.boundary, 2, this.boundary, 0, this.boundary.length - 2);
        this.boundaryLength = this.boundary.length - 2;
        this.computeBoundaryTable();
        try {
            this.discardBodyData();
            boolean bl = this.readBoundary();
            return bl;
        }
        catch (MalformedStreamException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            System.arraycopy(this.boundary, 0, this.boundary, 2, this.boundary.length - 2);
            this.boundaryLength = this.boundary.length;
            this.boundary[0] = 13;
            this.boundary[1] = 10;
            this.computeBoundaryTable();
        }
    }

    public static class Builder
    extends AbstractStreamBuilder<MultipartInput, Builder> {
        private byte[] boundary;
        private ProgressNotifier progressNotifier;

        public Builder() {
            this.setBufferSizeDefault(4096);
        }

        public MultipartInput get() throws IOException {
            return new MultipartInput(this.getInputStream(), this.boundary, this.getBufferSize(), this.progressNotifier);
        }

        public Builder setBoundary(byte[] boundary) {
            this.boundary = boundary;
            return this;
        }

        public Builder setProgressNotifier(ProgressNotifier progressNotifier) {
            this.progressNotifier = progressNotifier;
            return this;
        }
    }

    public static class ProgressNotifier {
        private final ProgressListener progressListener;
        private final long contentLength;
        private long bytesRead;
        private int items;

        public ProgressNotifier(ProgressListener progressListener, long contentLength) {
            this.progressListener = progressListener != null ? progressListener : ProgressListener.NOP;
            this.contentLength = contentLength;
        }

        void noteBytesRead(int byteCount) {
            this.bytesRead += (long)byteCount;
            this.notifyListener();
        }

        public void noteItem() {
            ++this.items;
            this.notifyListener();
        }

        private void notifyListener() {
            this.progressListener.update(this.bytesRead, this.contentLength, this.items);
        }
    }

    public class ItemInputStream
    extends InputStream {
        private static final int BYTE_POSITIVE_OFFSET = 256;
        private long total;
        private int pad;
        private int pos;
        private boolean closed;

        ItemInputStream() {
            this.findSeparator();
        }

        @Override
        public int available() throws IOException {
            if (this.pos == -1) {
                return MultipartInput.this.tail - MultipartInput.this.head - this.pad;
            }
            return this.pos - MultipartInput.this.head;
        }

        private void checkOpen() throws FileItemInput.ItemSkippedException {
            if (this.closed) {
                throw new FileItemInput.ItemSkippedException("checkOpen()");
            }
        }

        @Override
        public void close() throws IOException {
            this.close(false);
        }

        public void close(boolean closeUnderlying) throws IOException {
            if (this.closed) {
                return;
            }
            if (closeUnderlying) {
                this.closed = true;
                MultipartInput.this.input.close();
            } else {
                int avail;
                while ((avail = this.available()) != 0 || (avail = this.makeAvailable()) != 0) {
                    if (this.skip(avail) == (long)avail) continue;
                }
            }
            this.closed = true;
        }

        private void findSeparator() {
            this.pos = MultipartInput.this.findSeparator();
            if (this.pos == -1) {
                this.pad = MultipartInput.this.tail - MultipartInput.this.head > MultipartInput.this.keepRegion ? MultipartInput.this.keepRegion : MultipartInput.this.tail - MultipartInput.this.head;
            }
        }

        public long getBytesRead() {
            return this.total;
        }

        public boolean isClosed() {
            return this.closed;
        }

        private int makeAvailable() throws IOException {
            int av;
            if (this.pos != -1) {
                return 0;
            }
            this.total += (long)(MultipartInput.this.tail - MultipartInput.this.head - this.pad);
            System.arraycopy(MultipartInput.this.buffer, MultipartInput.this.tail - this.pad, MultipartInput.this.buffer, 0, this.pad);
            MultipartInput.this.head = 0;
            MultipartInput.this.tail = this.pad;
            do {
                int bytesRead;
                if ((bytesRead = MultipartInput.this.input.read(MultipartInput.this.buffer, MultipartInput.this.tail, MultipartInput.this.bufSize - MultipartInput.this.tail)) == -1) {
                    String msg = "Stream ended unexpectedly";
                    throw new MalformedStreamException("Stream ended unexpectedly");
                }
                if (MultipartInput.this.notifier != null) {
                    MultipartInput.this.notifier.noteBytesRead(bytesRead);
                }
                MultipartInput.this.tail += bytesRead;
                this.findSeparator();
            } while ((av = this.available()) <= 0 && this.pos == -1);
            return av;
        }

        @Override
        public int read() throws IOException {
            byte b;
            this.checkOpen();
            if (this.available() == 0 && this.makeAvailable() == 0) {
                return -1;
            }
            ++this.total;
            if ((b = MultipartInput.this.buffer[MultipartInput.this.head++]) >= 0) {
                return b;
            }
            return b + 256;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.checkOpen();
            if (len == 0) {
                return 0;
            }
            int res = this.available();
            if (res == 0 && (res = this.makeAvailable()) == 0) {
                return -1;
            }
            res = Math.min(res, len);
            System.arraycopy(MultipartInput.this.buffer, MultipartInput.this.head, b, off, res);
            MultipartInput.this.head += res;
            this.total += (long)res;
            return res;
        }

        @Override
        public long skip(long bytes) throws IOException {
            this.checkOpen();
            int available = this.available();
            if (available == 0 && (available = this.makeAvailable()) == 0) {
                return 0L;
            }
            int res = Math.toIntExact(Math.min((long)available, bytes));
            MultipartInput.this.head += res;
            return res;
        }
    }

    public static class MalformedStreamException
    extends FileUploadException {
        private static final long serialVersionUID = 2L;

        public MalformedStreamException(String message) {
            super(message);
        }

        public MalformedStreamException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class FileUploadBoundaryException
    extends FileUploadException {
        private static final long serialVersionUID = 2L;

        public FileUploadBoundaryException(String message) {
            super(message);
        }
    }
}

