/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.fileupload2.core.MultipartInput;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultipartStreamTest {
    private static final String BOUNDARY_TEXT = "myboundary";

    @Test
    public void testSmallBuffer() {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        boolean iBufSize = true;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((MultipartInput.Builder)((MultipartInput.Builder)MultipartInput.builder().setInputStream(input)).setBoundary(boundary).setBufferSize(1)).setProgressNotifier(new MultipartInput.ProgressNotifier(null, (long)contents.length)).get());
    }

    @Test
    public void testThreeParamConstructor() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        int iBufSize = boundary.length + MultipartInput.BOUNDARY_PREFIX.length + 1;
        MultipartInput ms = ((MultipartInput.Builder)((MultipartInput.Builder)MultipartInput.builder().setInputStream((InputStream)input)).setBoundary(boundary).setBufferSize(iBufSize)).setProgressNotifier(new MultipartInput.ProgressNotifier(null, (long)contents.length)).get();
        Assertions.assertNotNull((Object)ms);
    }

    @Test
    public void testTwoParamConstructor() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        MultipartInput ms = ((MultipartInput.Builder)MultipartInput.builder().setInputStream((InputStream)input)).setBoundary(boundary).setProgressNotifier(new MultipartInput.ProgressNotifier(null, (long)contents.length)).get();
        Assertions.assertNotNull((Object)ms);
    }
}

