/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AgeFileFilterTest {
    @Test
    public void testJavadocExampleUsingIo() {
        String[] files;
        File dir = new File(".");
        long cutoffMillis = System.currentTimeMillis();
        for (String string : files = dir.list((FilenameFilter)new AgeFileFilter(cutoffMillis))) {
        }
        Assertions.assertTrue((files.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJavadocExampleUsingNio() throws IOException {
        Path dir = Paths.get("", new String[0]);
        long cutoffMillis = System.currentTimeMillis();
        AccumulatorPathVisitor visitor = AccumulatorPathVisitor.withLongCounters((PathFilter)new AgeFileFilter(cutoffMillis), (PathFilter)TrueFileFilter.INSTANCE);
        Files.walkFileTree(dir, Collections.emptySet(), 1, (FileVisitor<? super Path>)visitor);
        visitor.getPathCounters().reset();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)visitor);
        Assertions.assertTrue((visitor.getPathCounters().getFileCounter().get() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((visitor.getPathCounters().getDirectoryCounter().get() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((visitor.getPathCounters().getByteCounter().get() > 0L ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)visitor.getDirList().isEmpty());
        Assertions.assertFalse((boolean)visitor.getFileList().isEmpty());
        Assertions.assertNotEquals((Object)Counters.noopPathCounters(), (Object)visitor.getPathCounters());
        visitor.getPathCounters().reset();
        CounterAssertions.assertZeroCounters(visitor.getPathCounters());
    }

    @Test
    public void testNoCounting() throws IOException {
        Path dir = Paths.get("", new String[0]);
        long cutoffMillis = System.currentTimeMillis();
        AccumulatorPathVisitor visitor = new AccumulatorPathVisitor(Counters.noopPathCounters(), (PathFilter)new AgeFileFilter(cutoffMillis), (PathFilter)TrueFileFilter.INSTANCE);
        Files.walkFileTree(dir, Collections.emptySet(), 1, (FileVisitor<? super Path>)visitor);
        CounterAssertions.assertZeroCounters(visitor.getPathCounters());
        Assertions.assertFalse((boolean)visitor.getDirList().isEmpty());
        Assertions.assertFalse((boolean)visitor.getFileList().isEmpty());
    }
}

