/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.TaggedInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaggedInputStreamTest {
    @Test
    public void testEmptyStream() throws IOException {
        TaggedInputStream stream = new TaggedInputStream((InputStream)ClosedInputStream.CLOSED_INPUT_STREAM);
        Assertions.assertEquals((int)0, (int)stream.available());
        Assertions.assertEquals((int)-1, (int)stream.read());
        Assertions.assertEquals((int)-1, (int)stream.read(new byte[1]));
        Assertions.assertEquals((int)-1, (int)stream.read(new byte[1], 0, 1));
        stream.close();
    }

    @Test
    public void testNormalStream() throws IOException {
        TaggedInputStream stream = new TaggedInputStream((InputStream)new ByteArrayInputStream(new byte[]{97, 98, 99}));
        Assertions.assertEquals((int)3, (int)stream.available());
        Assertions.assertEquals((int)97, (int)stream.read());
        byte[] buffer = new byte[1];
        Assertions.assertEquals((int)1, (int)stream.read(buffer));
        Assertions.assertEquals((int)98, (int)buffer[0]);
        Assertions.assertEquals((int)1, (int)stream.read(buffer, 0, 1));
        Assertions.assertEquals((int)99, (int)buffer[0]);
        Assertions.assertEquals((int)-1, (int)stream.read());
        stream.close();
    }

    @Test
    public void testBrokenStream() {
        IOException exception = new IOException("test exception");
        TaggedInputStream stream = new TaggedInputStream((InputStream)new BrokenInputStream(exception));
        try {
            stream.available();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)stream.isCauseOf((Throwable)e));
            try {
                stream.throwIfCauseOf((Throwable)e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.read();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)stream.isCauseOf((Throwable)e));
            try {
                stream.throwIfCauseOf((Throwable)e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.close();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)stream.isCauseOf((Throwable)e));
            try {
                stream.throwIfCauseOf((Throwable)e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        TaggedInputStream stream = new TaggedInputStream((InputStream)ClosedInputStream.CLOSED_INPUT_STREAM);
        Assertions.assertFalse((boolean)stream.isCauseOf((Throwable)exception));
        Assertions.assertFalse((boolean)stream.isCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID())));
        stream.throwIfCauseOf((Throwable)exception);
        stream.throwIfCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID()));
        stream.close();
    }
}

