/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThresholdingOutputStreamTest {
    @Test
    public void testSetByteCount() throws Exception {
        final AtomicBoolean reached = new AtomicBoolean(false);
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(3){
            {
                super(x0);
                this.setByteCount(2L);
            }

            protected OutputStream getStream() throws IOException {
                return new ByteArrayOutputStream(4);
            }

            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(97);
            Assertions.assertTrue((boolean)reached.get());
        }
    }

    @Test
    public void testThresholdIOConsumer() throws Exception {
        AtomicBoolean reached = new AtomicBoolean();
        reached.set(false);
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(1, null, os -> new ByteArrayOutputStream(4));){
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
        }
        reached.set(false);
        tos = new ThresholdingOutputStream(1, os -> reached.set(true), null);
        var3_3 = null;
        try {
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(97);
            Assertions.assertTrue((boolean)reached.get());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tos != null) {
                if (var3_3 != null) {
                    try {
                        tos.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tos.close();
                }
            }
        }
        reached.set(false);
        tos = new ThresholdingOutputStream(1, os -> reached.set(true), os -> new ByteArrayOutputStream(4));
        var3_3 = null;
        try {
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(97);
            Assertions.assertTrue((boolean)reached.get());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tos != null) {
                if (var3_3 != null) {
                    try {
                        tos.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tos.close();
                }
            }
        }
    }

    @Test
    public void testThresholdIOConsumerIOException() throws Exception {
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(1, os -> {
            throw new IOException("Threshold reached.");
        }, os -> new ByteArrayOutputStream(4));){
            tos.write(97);
            Assertions.assertThrows(IOException.class, () -> tos.write(97));
        }
    }

    @Test
    public void testThresholdIOConsumerUncheckedException() throws Exception {
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(1, os -> {
            throw new IllegalStateException("Threshold reached.");
        }, os -> new ByteArrayOutputStream(4));){
            tos.write(97);
            Assertions.assertThrows(IllegalStateException.class, () -> tos.write(97));
        }
    }
}

