/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.CopyDirectoryVisitor;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TestArguments;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CopyDirectoryVisitorTest
extends TestArguments {
    private Path targetDir;

    @AfterEach
    public void afterEach() throws IOException {
        PathUtils.deleteDirectory((Path)this.targetDir);
    }

    @BeforeEach
    public void beforeEach() throws IOException {
        this.targetDir = Files.createTempDirectory(this.getClass().getCanonicalName() + "-target", new FileAttribute[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCopyDirectoryEmptyFolder(Counters.PathCounters pathCounters) throws IOException {
        Path sourceDir = Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]);
        try {
            CounterAssertions.assertCounts(1L, 0L, 0L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)new CopyDirectoryVisitor(pathCounters, sourceDir, this.targetDir, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING}), (Path)sourceDir));
        }
        finally {
            Files.deleteIfExists(sourceDir);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCopyDirectoryFolders1FileSize0(Counters.PathCounters pathCounters) throws IOException {
        Path sourceDir = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]);
        CounterAssertions.assertCounts(1L, 1L, 0L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)new CopyDirectoryVisitor(pathCounters, sourceDir, this.targetDir, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING}), (Path)sourceDir));
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCopyDirectoryFolders1FileSize1(Counters.PathCounters pathCounters) throws IOException {
        Path sourceDir = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]);
        CounterAssertions.assertCounts(1L, 1L, 1L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)new CopyDirectoryVisitor(pathCounters, sourceDir, this.targetDir, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING}), (Path)sourceDir));
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCopyDirectoryFolders2FileSize2(Counters.PathCounters pathCounters) throws IOException {
        Path sourceDir = Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]);
        CounterAssertions.assertCounts(3L, 2L, 2L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)new CopyDirectoryVisitor(pathCounters, sourceDir, this.targetDir, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING}), (Path)sourceDir));
    }
}

