/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.input.InfiniteCircularInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InfiniteCircularInputStreamTest {
    private void assertStreamOutput(byte[] toCycle, byte[] expected) throws IOException {
        byte[] actual = new byte[expected.length];
        try (InfiniteCircularInputStream infStream = new InfiniteCircularInputStream(toCycle);){
            int actualReadBytes = infStream.read(actual);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
            Assertions.assertEquals((int)expected.length, (int)actualReadBytes);
        }
    }

    private InputStream createInputStream(byte[] repeatContent) {
        return new InfiniteCircularInputStream(repeatContent);
    }

    @Test
    public void testContainsEofInputSize0() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createInputStream(new byte[]{-1}));
    }

    @Test
    public void testCount0InputSize0() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createInputStream(new byte[0]));
    }

    @Test
    public void testCount0InputSize1() throws IOException {
        InputStream in = this.createInputStream(new byte[]{1});
        Throwable throwable = null;
        if (in != null) {
            if (throwable != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                in.close();
            }
        }
    }

    @Test
    public void testCount1InputSize1() throws IOException {
        try (InputStream in = this.createInputStream(new byte[]{1});){
            Assertions.assertEquals((int)1, (int)in.read());
            Assertions.assertEquals((int)1, (int)in.read());
        }
    }

    @Test
    public void testCycleBytes() throws IOException {
        byte[] input = new byte[]{1, 2};
        byte[] expected = new byte[]{1, 2, 1, 2, 1};
        this.assertStreamOutput(input, expected);
    }

    @Test
    public void testNullInputSize0() {
        Assertions.assertThrows(NullPointerException.class, () -> this.createInputStream(null));
    }

    @Test
    public void testWholeRangeOfBytes() throws IOException {
        int size = 256;
        byte[] contentToCycle = new byte[256];
        int value = -128;
        for (int i = 0; i < contentToCycle.length; ++i) {
            contentToCycle[i] = value == -1 ? 0 : value;
            value = (byte)(value + 1);
        }
        byte[] expectedOutput = Arrays.copyOf(contentToCycle, 256);
        this.assertStreamOutput(contentToCycle, expectedOutput);
    }
}

