/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.io.serialization.AbstractCloseableListTest;
import org.apache.commons.io.serialization.MoreComplexObject;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MoreComplexObjectTest
extends AbstractCloseableListTest {
    private InputStream inputStream;
    private MoreComplexObject original;

    @BeforeEach
    public void setupMoreComplexObject() throws IOException {
        this.original = new MoreComplexObject();
        ByteArrayOutputStream bos = this.closeAfterEachTest(new ByteArrayOutputStream());
        ObjectOutputStream oos = this.closeAfterEachTest(new ObjectOutputStream(bos));
        oos.writeObject(this.original);
        this.inputStream = this.closeAfterEachTest(new ByteArrayInputStream(bos.toByteArray()));
    }

    private void assertSerialization(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        MoreComplexObject copy = (MoreComplexObject)ois.readObject();
        Assertions.assertEquals((Object)this.original.toString(), (Object)copy.toString(), (String)"Expecting same data after deserializing");
    }

    @Test
    public void trustJavaLang() throws IOException, ClassNotFoundException {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.inputStream).accept(new Class[]{MoreComplexObject.class, ArrayList.class, Random.class}).accept(new String[]{"java.lang.*", "[Ljava.lang.*"})));
    }

    @Test
    public void trustJavaIncludingArrays() throws IOException, ClassNotFoundException {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.inputStream).accept(new Class[]{MoreComplexObject.class}).accept(new String[]{"java.*", "[Ljava.*"})));
    }

    @Test
    public void useBlacklist() throws IOException, ClassNotFoundException {
        String[] blacklist = new String[]{"org.apache.commons.collections.functors.InvokerTransformer", "org.codehaus.groovy.runtime.ConvertedClosure", "org.codehaus.groovy.runtime.MethodClosure", "org.springframework.beans.factory.ObjectFactory"};
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.inputStream).accept(new String[]{"*"}).reject(blacklist)));
    }
}

