/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class ByteOrderMarkTestCase
extends FileBasedTestCase {
    private static final ByteOrderMark TEST_BOM_1 = new ByteOrderMark("test1", new int[]{1});
    private static final ByteOrderMark TEST_BOM_2 = new ByteOrderMark("test2", new int[]{1, 2});
    private static final ByteOrderMark TEST_BOM_3 = new ByteOrderMark("test3", new int[]{1, 2, 3});

    public ByteOrderMarkTestCase(String name) {
        super(name);
    }

    public void testCharsetName() {
        ByteOrderMarkTestCase.assertEquals((String)"test1 name", (String)"test1", (String)TEST_BOM_1.getCharsetName());
        ByteOrderMarkTestCase.assertEquals((String)"test2 name", (String)"test2", (String)TEST_BOM_2.getCharsetName());
        ByteOrderMarkTestCase.assertEquals((String)"test3 name", (String)"test3", (String)TEST_BOM_3.getCharsetName());
    }

    public void testConstantCharsetNames() {
        ByteOrderMarkTestCase.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_16BE.getCharsetName()));
        ByteOrderMarkTestCase.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_16LE.getCharsetName()));
        ByteOrderMarkTestCase.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_8.getCharsetName()));
    }

    public void testLength() {
        ByteOrderMarkTestCase.assertEquals((String)"test1 length", (int)1, (int)TEST_BOM_1.length());
        ByteOrderMarkTestCase.assertEquals((String)"test2 length", (int)2, (int)TEST_BOM_2.length());
        ByteOrderMarkTestCase.assertEquals((String)"test3 length", (int)3, (int)TEST_BOM_3.length());
    }

    public void testGet() {
        ByteOrderMarkTestCase.assertEquals((String)"test1 get(0)", (int)1, (int)TEST_BOM_1.get(0));
        ByteOrderMarkTestCase.assertEquals((String)"test2 get(0)", (int)1, (int)TEST_BOM_2.get(0));
        ByteOrderMarkTestCase.assertEquals((String)"test2 get(1)", (int)2, (int)TEST_BOM_2.get(1));
        ByteOrderMarkTestCase.assertEquals((String)"test3 get(0)", (int)1, (int)TEST_BOM_3.get(0));
        ByteOrderMarkTestCase.assertEquals((String)"test3 get(1)", (int)2, (int)TEST_BOM_3.get(1));
        ByteOrderMarkTestCase.assertEquals((String)"test3 get(2)", (int)3, (int)TEST_BOM_3.get(2));
    }

    public void testGetBytes() {
        ByteOrderMarkTestCase.assertTrue((String)"test1 bytes", (boolean)Arrays.equals(TEST_BOM_1.getBytes(), new byte[]{1}));
        ByteOrderMarkTestCase.assertTrue((String)"test1 bytes", (boolean)Arrays.equals(TEST_BOM_2.getBytes(), new byte[]{1, 2}));
        ByteOrderMarkTestCase.assertTrue((String)"test1 bytes", (boolean)Arrays.equals(TEST_BOM_3.getBytes(), new byte[]{1, 2, 3}));
    }

    public void testEquals() {
        ByteOrderMarkTestCase.assertTrue((String)"test1 equals", (boolean)TEST_BOM_1.equals((Object)TEST_BOM_1));
        ByteOrderMarkTestCase.assertTrue((String)"test2 equals", (boolean)TEST_BOM_2.equals((Object)TEST_BOM_2));
        ByteOrderMarkTestCase.assertTrue((String)"test3 equals", (boolean)TEST_BOM_3.equals((Object)TEST_BOM_3));
        ByteOrderMarkTestCase.assertFalse((String)"Object not equal", (boolean)TEST_BOM_1.equals(new Object()));
        ByteOrderMarkTestCase.assertFalse((String)"test1-1 not equal", (boolean)TEST_BOM_1.equals((Object)new ByteOrderMark("1a", new int[]{2})));
        ByteOrderMarkTestCase.assertFalse((String)"test1-2 not test2", (boolean)TEST_BOM_1.equals((Object)new ByteOrderMark("1b", new int[]{1, 2})));
        ByteOrderMarkTestCase.assertFalse((String)"test2 not equal", (boolean)TEST_BOM_2.equals((Object)new ByteOrderMark("2", new int[]{1, 1})));
        ByteOrderMarkTestCase.assertFalse((String)"test3 not equal", (boolean)TEST_BOM_3.equals((Object)new ByteOrderMark("3", new int[]{1, 2, 4})));
    }

    public void testHashCode() {
        int bomClassHash = ByteOrderMark.class.hashCode();
        ByteOrderMarkTestCase.assertEquals((String)"hash test1 ", (int)(bomClassHash + 1), (int)TEST_BOM_1.hashCode());
        ByteOrderMarkTestCase.assertEquals((String)"hash test2 ", (int)(bomClassHash + 3), (int)TEST_BOM_2.hashCode());
        ByteOrderMarkTestCase.assertEquals((String)"hash test3 ", (int)(bomClassHash + 6), (int)TEST_BOM_3.hashCode());
    }

    public void testErrors() {
        try {
            new ByteOrderMark(null, new int[]{1, 2, 3});
            ByteOrderMarkTestCase.fail((String)"null charset name, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new ByteOrderMark("", new int[]{1, 2, 3});
            ByteOrderMarkTestCase.fail((String)"no charset name, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new ByteOrderMark("a", (int[])null);
            ByteOrderMarkTestCase.fail((String)"null bytes, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new ByteOrderMark("b", new int[0]);
            ByteOrderMarkTestCase.fail((String)"empty bytes, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToString() {
        ByteOrderMarkTestCase.assertEquals((String)"test1 ", (String)"ByteOrderMark[test1: 0x1]", (String)TEST_BOM_1.toString());
        ByteOrderMarkTestCase.assertEquals((String)"test2 ", (String)"ByteOrderMark[test2: 0x1,0x2]", (String)TEST_BOM_2.toString());
        ByteOrderMarkTestCase.assertEquals((String)"test3 ", (String)"ByteOrderMark[test3: 0x1,0x2,0x3]", (String)TEST_BOM_3.toString());
    }
}

