/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryWalkerTestCase
extends TestCase {
    private static final File current = new File(".");
    private static final File javaDir = new File("src/main/java");
    private static final File orgDir = new File(javaDir, "org");
    private static final File apacheDir = new File(orgDir, "apache");
    private static final File commonsDir = new File(apacheDir, "commons");
    private static final File ioDir = new File(commonsDir, "io");
    private static final File outputDir = new File(ioDir, "output");
    private static final File[] dirs = new File[]{orgDir, apacheDir, commonsDir, ioDir, outputDir};
    private static final File filenameUtils = new File(ioDir, "FilenameUtils.java");
    private static final File ioUtils = new File(ioDir, "IOUtils.java");
    private static final File proxyWriter = new File(outputDir, "ProxyWriter.java");
    private static final File nullStream = new File(outputDir, "NullOutputStream.java");
    private static final File[] ioFiles = new File[]{filenameUtils, ioUtils};
    private static final File[] outputFiles = new File[]{proxyWriter, nullStream};
    private static final IOFileFilter dirsFilter = DirectoryWalkerTestCase.createNameFilter(dirs);
    private static final IOFileFilter iofilesFilter = DirectoryWalkerTestCase.createNameFilter(ioFiles);
    private static final IOFileFilter outputFilesFilter = DirectoryWalkerTestCase.createNameFilter(outputFiles);
    private static final IOFileFilter ioDirAndFilesFilter = new OrFileFilter(dirsFilter, iofilesFilter);
    private static final IOFileFilter dirsAndFilesFilter = new OrFileFilter(ioDirAndFilesFilter, outputFilesFilter);
    private static final IOFileFilter NOT_SVN = FileFilterUtils.makeSVNAware(null);

    public DirectoryWalkerTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFilter() {
        List<File> results = new TestFileFinder((FileFilter)dirsAndFilesFilter, -1).find(javaDir);
        DirectoryWalkerTestCase.assertEquals((String)"Result Size", (int)(1 + dirs.length + ioFiles.length + outputFiles.length), (int)results.size());
        DirectoryWalkerTestCase.assertTrue((String)"Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("Dir", dirs, results);
        this.checkContainsFiles("IO File", ioFiles, results);
        this.checkContainsFiles("Output File", outputFiles, results);
    }

    public void testFilterAndLimitA() {
        List<File> results = new TestFileFinder((FileFilter)NOT_SVN, 0).find(javaDir);
        DirectoryWalkerTestCase.assertEquals((String)"[A] Result Size", (int)1, (int)results.size());
        DirectoryWalkerTestCase.assertTrue((String)"[A] Start Dir", (boolean)results.contains(javaDir));
    }

    public void testFilterAndLimitB() {
        List<File> results = new TestFileFinder((FileFilter)NOT_SVN, 1).find(javaDir);
        DirectoryWalkerTestCase.assertEquals((String)"[B] Result Size", (int)2, (int)results.size());
        DirectoryWalkerTestCase.assertTrue((String)"[B] Start Dir", (boolean)results.contains(javaDir));
        DirectoryWalkerTestCase.assertTrue((String)"[B] Org Dir", (boolean)results.contains(orgDir));
    }

    public void testFilterAndLimitC() {
        List<File> results = new TestFileFinder((FileFilter)NOT_SVN, 3).find(javaDir);
        DirectoryWalkerTestCase.assertEquals((String)"[C] Result Size", (int)4, (int)results.size());
        DirectoryWalkerTestCase.assertTrue((String)"[C] Start Dir", (boolean)results.contains(javaDir));
        DirectoryWalkerTestCase.assertTrue((String)"[C] Org Dir", (boolean)results.contains(orgDir));
        DirectoryWalkerTestCase.assertTrue((String)"[C] Apache Dir", (boolean)results.contains(apacheDir));
        DirectoryWalkerTestCase.assertTrue((String)"[C] Commons Dir", (boolean)results.contains(commonsDir));
    }

    public void testFilterAndLimitD() {
        List<File> results = new TestFileFinder((FileFilter)dirsAndFilesFilter, 5).find(javaDir);
        DirectoryWalkerTestCase.assertEquals((String)"[D] Result Size", (int)(1 + dirs.length + ioFiles.length), (int)results.size());
        DirectoryWalkerTestCase.assertTrue((String)"[D] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[D] Dir", dirs, results);
        this.checkContainsFiles("[D] File", ioFiles, results);
    }

    public void testFilterDirAndFile1() {
        List<File> results = new TestFileFinder(dirsFilter, iofilesFilter, -1).find(javaDir);
        DirectoryWalkerTestCase.assertEquals((String)"[DirAndFile1] Result Size", (int)(1 + dirs.length + ioFiles.length), (int)results.size());
        DirectoryWalkerTestCase.assertTrue((String)"[DirAndFile1] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile1] Dir", dirs, results);
        this.checkContainsFiles("[DirAndFile1] File", ioFiles, results);
    }

    public void testFilterDirAndFile2() {
        List<File> results = new TestFileFinder(null, null, -1).find(javaDir);
        DirectoryWalkerTestCase.assertTrue((String)"[DirAndFile2] Result Size", (results.size() > 1 + dirs.length + ioFiles.length ? 1 : 0) != 0);
        DirectoryWalkerTestCase.assertTrue((String)"[DirAndFile2] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile2] Dir", dirs, results);
        this.checkContainsFiles("[DirAndFile2] File", ioFiles, results);
    }

    public void testFilterDirAndFile3() {
        List<File> results = new TestFileFinder(dirsFilter, null, -1).find(javaDir);
        List<File> resultDirs = this.directoriesOnly(results);
        DirectoryWalkerTestCase.assertEquals((String)"[DirAndFile3] Result Size", (int)(1 + dirs.length), (int)resultDirs.size());
        DirectoryWalkerTestCase.assertTrue((String)"[DirAndFile3] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile3] Dir", dirs, resultDirs);
    }

    public void testFilterDirAndFile4() {
        List<File> results = new TestFileFinder(null, iofilesFilter, -1).find(javaDir);
        List<File> resultFiles = this.filesOnly(results);
        DirectoryWalkerTestCase.assertEquals((String)"[DirAndFile4] Result Size", (int)ioFiles.length, (int)resultFiles.size());
        DirectoryWalkerTestCase.assertTrue((String)"[DirAndFile4] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile4] File", ioFiles, resultFiles);
    }

    public void testLimitToCurrent() {
        List<File> results = new TestFileFinder(null, 0).find(current);
        DirectoryWalkerTestCase.assertEquals((String)"Result Size", (int)1, (int)results.size());
        DirectoryWalkerTestCase.assertTrue((String)"Current Dir", (boolean)results.contains(new File(".")));
    }

    public void testMissingStartDirectory() {
        File invalidDir = new File("invalid-dir");
        List<File> results = new TestFileFinder(null, -1).find(invalidDir);
        DirectoryWalkerTestCase.assertEquals((String)"Result Size", (int)1, (int)results.size());
        DirectoryWalkerTestCase.assertTrue((String)"Current Dir", (boolean)results.contains(invalidDir));
        try {
            new TestFileFinder(null, -1).find(null);
            DirectoryWalkerTestCase.fail((String)"Null start directory didn't throw Exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHandleStartDirectoryFalse() {
        List<File> results = new TestFalseFileFinder(null, -1).find(current);
        DirectoryWalkerTestCase.assertEquals((String)"Result Size", (int)0, (int)results.size());
    }

    private void checkContainsFiles(String prefix, File[] files, Collection<File> results) {
        for (int i = 0; i < files.length; ++i) {
            DirectoryWalkerTestCase.assertTrue((String)(prefix + "[" + i + "] " + files[i]), (boolean)results.contains(files[i]));
        }
    }

    private void checkContainsString(String prefix, File[] files, Collection<String> results) {
        for (int i = 0; i < files.length; ++i) {
            DirectoryWalkerTestCase.assertTrue((String)(prefix + "[" + i + "] " + files[i]), (boolean)results.contains(files[i].toString()));
        }
    }

    private List<File> directoriesOnly(Collection<File> results) {
        ArrayList<File> list = new ArrayList<File>(results.size());
        for (File file : results) {
            if (!file.isDirectory()) continue;
            list.add(file);
        }
        return list;
    }

    private List<File> filesOnly(Collection<File> results) {
        ArrayList<File> list = new ArrayList<File>(results.size());
        for (File file : results) {
            if (!file.isFile()) continue;
            list.add(file);
        }
        return list;
    }

    private static IOFileFilter createNameFilter(File[] files) {
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = files[i].getName();
        }
        return new NameFileFilter(names);
    }

    public void testCancel() {
        String cancelName = null;
        try {
            cancelName = "DirectoryWalker.java";
            new TestCancelWalker(cancelName, false).find(javaDir);
            DirectoryWalkerTestCase.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            DirectoryWalkerTestCase.assertEquals((String)("File:  " + cancelName), (String)cancelName, (String)cancel.getFile().getName());
            DirectoryWalkerTestCase.assertEquals((String)("Depth: " + cancelName), (int)5, (int)cancel.getDepth());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCase.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            cancelName = "commons";
            new TestCancelWalker(cancelName, false).find(javaDir);
            DirectoryWalkerTestCase.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            DirectoryWalkerTestCase.assertEquals((String)("File:  " + cancelName), (String)cancelName, (String)cancel.getFile().getName());
            DirectoryWalkerTestCase.assertEquals((String)("Depth: " + cancelName), (int)3, (int)cancel.getDepth());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCase.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            List<File> results = new TestCancelWalker(cancelName, true).find(javaDir);
            File lastFile = results.get(results.size() - 1);
            DirectoryWalkerTestCase.assertEquals((String)("Suppress:  " + cancelName), (String)cancelName, (String)lastFile.getName());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCase.fail((String)("Suppress threw " + ex));
        }
    }

    public void testMultiThreadCancel() {
        String cancelName = "DirectoryWalker.java";
        TestMultiThreadCancelWalker walker = new TestMultiThreadCancelWalker(cancelName, false);
        try {
            walker.find(javaDir);
            DirectoryWalkerTestCase.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            File last = walker.results.get(walker.results.size() - 1);
            DirectoryWalkerTestCase.assertEquals((String)cancelName, (String)last.getName());
            DirectoryWalkerTestCase.assertEquals((String)("Depth: " + cancelName), (int)5, (int)cancel.getDepth());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCase.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            cancelName = "commons";
            walker = new TestMultiThreadCancelWalker(cancelName, false);
            walker.find(javaDir);
            DirectoryWalkerTestCase.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            DirectoryWalkerTestCase.assertEquals((String)("File:  " + cancelName), (String)cancelName, (String)cancel.getFile().getName());
            DirectoryWalkerTestCase.assertEquals((String)("Depth: " + cancelName), (int)3, (int)cancel.getDepth());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCase.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            walker = new TestMultiThreadCancelWalker(cancelName, true);
            List<File> results = walker.find(javaDir);
            File lastFile = results.get(results.size() - 1);
            DirectoryWalkerTestCase.assertEquals((String)("Suppress:  " + cancelName), (String)cancelName, (String)lastFile.getName());
        }
        catch (IOException ex) {
            DirectoryWalkerTestCase.fail((String)("Suppress threw " + ex));
        }
    }

    public void testFilterString() {
        List<String> results = new TestFileFinderString((FileFilter)dirsAndFilesFilter, -1).find(javaDir);
        DirectoryWalkerTestCase.assertEquals((String)"Result Size", (int)(outputFiles.length + ioFiles.length), (int)results.size());
        this.checkContainsString("IO File", ioFiles, results);
        this.checkContainsString("Output File", outputFiles, results);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestFileFinderString
    extends DirectoryWalker<String> {
        protected TestFileFinderString(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected List<String> find(File startDirectory) {
            ArrayList<String> results = new ArrayList<String>();
            try {
                this.walk(startDirectory, results);
            }
            catch (IOException ex) {
                Assert.fail((String)ex.toString());
            }
            return results;
        }

        protected void handleFile(File file, int depth, Collection<String> results) {
            results.add(file.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestMultiThreadCancelWalker
    extends DirectoryWalker<File> {
        private String cancelFileName;
        private boolean suppressCancel;
        private boolean cancelled;
        public List<File> results;

        TestMultiThreadCancelWalker(String cancelFileName, boolean suppressCancel) {
            this.cancelFileName = cancelFileName;
            this.suppressCancel = suppressCancel;
        }

        protected List<File> find(File startDirectory) throws IOException {
            this.results = new ArrayList<File>();
            this.walk(startDirectory, this.results);
            return this.results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection<File> results) throws IOException {
            results.add(directory);
            Assert.assertFalse((boolean)this.cancelled);
            if (this.cancelFileName.equals(directory.getName())) {
                this.cancelled = true;
            }
        }

        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            results.add(file);
            Assert.assertFalse((boolean)this.cancelled);
            if (this.cancelFileName.equals(file.getName())) {
                this.cancelled = true;
            }
        }

        protected boolean handleIsCancelled(File file, int depth, Collection<File> results) throws IOException {
            return this.cancelled;
        }

        protected void handleCancelled(File startDirectory, Collection<File> results, DirectoryWalker.CancelException cancel) throws IOException {
            if (!this.suppressCancel) {
                super.handleCancelled(startDirectory, results, cancel);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestCancelWalker
    extends DirectoryWalker<File> {
        private String cancelFileName;
        private boolean suppressCancel;

        TestCancelWalker(String cancelFileName, boolean suppressCancel) {
            this.cancelFileName = cancelFileName;
            this.suppressCancel = suppressCancel;
        }

        protected List<File> find(File startDirectory) throws IOException {
            ArrayList<File> results = new ArrayList<File>();
            this.walk(startDirectory, results);
            return results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection<File> results) throws IOException {
            results.add(directory);
            if (this.cancelFileName.equals(directory.getName())) {
                throw new DirectoryWalker.CancelException(directory, depth);
            }
        }

        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            results.add(file);
            if (this.cancelFileName.equals(file.getName())) {
                throw new DirectoryWalker.CancelException(file, depth);
            }
        }

        protected void handleCancelled(File startDirectory, Collection<File> results, DirectoryWalker.CancelException cancel) throws IOException {
            if (!this.suppressCancel) {
                super.handleCancelled(startDirectory, results, cancel);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestFalseFileFinder
    extends TestFileFinder {
        protected TestFalseFileFinder(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected boolean handleDirectory(File directory, int depth, Collection<File> results) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestFileFinder
    extends DirectoryWalker<File> {
        protected TestFileFinder(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected TestFileFinder(IOFileFilter dirFilter, IOFileFilter fileFilter, int depthLimit) {
            super(dirFilter, fileFilter, depthLimit);
        }

        protected List<File> find(File startDirectory) {
            ArrayList<File> results = new ArrayList<File>();
            try {
                this.walk(startDirectory, results);
            }
            catch (IOException ex) {
                Assert.fail((String)ex.toString());
            }
            return results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection<File> results) {
            results.add(directory);
        }

        protected void handleFile(File file, int depth, Collection<File> results) {
            results.add(file);
        }
    }
}

